#include <ncbi_pch.hpp>
#include "objutils.hpp"
#include <objects/general/general__.hpp>
#include <objects/seqloc/seqloc__.hpp>
USING_NCBI_SCOPE;
using namespace objects;

void CObjectIdWriteHooker::WriteChoiceVariant(CObjectOStream& os, const CConstObjectInfoCV& variant)
{
	//const CObject_id& objid = *CType<CObject_id>::Get(variant.GetVariant().GetPointedObject());
	const CObject_id& objid = *reinterpret_cast<const CObject_id*> (variant.GetVariant().GetObjectPtr());
	if (objid.Which() == CObject_id::e_Id)
	{
		char dimBuf[16];
		sprintf(dimBuf, "%d", objid.GetId());
		
		CObject_id rep_id;
		rep_id.SetStr(dimBuf);
		
		//const CTypeInfo* typeInfo = ObjectInfo(rep_id);
		
		
		//CConstObjectInfoCV infoCV(ObjectInfo(rep_id));
		os.WriteObject(ObjectInfo(rep_id));
		//DefaultWrite(os, infoCV);
		//os << rep_id;
	}
	else DefaultWrite(os, variant);
}

CObjectOStream * CreateObjOStream(CNcbiOstream& os, ESerialDataFormat eFormat, TSerial_Format_Flags fFormatFlags, bool numeric_user_id_to_string)
{
	CObjectOStream *pOStream = CObjectOStream::Open(eFormat, os, eNoOwnership, fFormatFlags);
	
	if (eSerial_Xml == eFormat)	//Get rid of dtd
	{
		CObjectOStreamXml *p_os_xml = dynamic_cast< CObjectOStreamXml* > (pOStream);
		if (nullptr != p_os_xml)
			p_os_xml->SetReferenceDTD(false);
	}
	
	if (numeric_user_id_to_string)
		CObjectTypeInfo(objects::CSeq_id::GetTypeInfo()).FindVariant("local").SetLocalWriteHook(*pOStream, new CObjectIdWriteHooker);
	
	return pOStream;
}

CObjectIStream * CreateObjIStream(ncbi::CNcbiIstream& is, ESerialDataFormat eFormat)
{
	return CObjectIStream::Open(eFormat, is, eNoOwnership);
}



