template<typename TSequenceDerived>
void ParseSequencesFromSeqSet(const ncbi::objects::CBioseq_set& src, std::vector<TSequenceDerived> &dst)
{
    const std::list< ncbi::CRef< ncbi::objects::CSeq_entry > > &rEntries = src.GetSeq_set();
	size_t total_seqs = rEntries.size();

	dst.reserve(dst.size() + total_seqs);
	
	for (std::list< ncbi::CRef< ncbi::objects::CSeq_entry > >::const_iterator iter = rEntries.begin(); iter != rEntries.end(); ++iter)
	{
		dst.emplace_back();
		TSequenceDerived & rSeq = dst.back();
		const ncbi::objects::CBioseq & rBioseq = (*iter)->GetSeq();

		FillSequenceFromBioseq(rBioseq, rSeq);
		// -- add masks
	}
}
