template <typename TEnumLitType>
ncbi::CArgAllow * AllowEnumLits()
{
	if (0 == TEnumLitType::eEnumStop) return nullptr;
	
	ncbi::CArgAllow_Strings * pAllowed = new ncbi::CArgAllow_Strings;
	for (TENUMIDX i = 0; i < TEnumLitType::eEnumStop; ++i)
		pAllowed->AllowValue(TEnumLitType::dimLits[i]);
	
	return pAllowed;
}

template <typename TNumeric>
const char * NumericDefVal(TNumeric n)
{
	static std::list<std::string> st_storage;
    st_storage.emplace_back(ncbi::NStr::NumericToString<TNumeric>(n));
	return st_storage.back().c_str();
}

