#if !defined(__CACHEOPS__)
#define __CACHEOPS__


#include "datacache.hpp"

#if defined(__DB_OFFLINE__)
#include "compactstore.hpp"
#else
#include <shlu2/BasicUtils/compactstore.hpp>
#endif

template<typename TPOD>
CDataCache & operator << (CDataCache &dc, const TPOD & d);

template<typename TPOD>
CDataCache & operator >> (CDataCache &dc, TPOD & d);

template<>
CDataCache & operator << (CDataCache &dc, const std::string & d);

template<>
CDataCache & operator >> (CDataCache &dc, std::string & d);

template<typename TPOD>
void CachePODData(CDataCache &dc, const std::vector<TPOD> & d);

template<>
void CachePODData(CDataCache &dc, const std::vector<std::string> & d);

template<typename TPOD>
void RestorePODData(CDataCache &dc, std::vector<TPOD> & d);

template<>  //specialize for string vectors
void RestorePODData(CDataCache &dc, std::vector<std::string> & d);

template<typename TPOD>
void CachePODData(CDataCache &dc, const std::list<TPOD> & d);

template<typename TPOD>
void RestorePODData(CDataCache &dc, std::list<TPOD> & d);

template<typename TKEY, typename TPOD>
void CachePODData(CDataCache &dc, const std::map<TKEY, TPOD> & d);

template<typename TKEY, typename TPOD>
void RestorePODData(CDataCache &dc, std::map<TKEY, TPOD> & d);

template<typename TKEY, typename TPOD, template<typename D, typename A = std::allocator<D> > class C>
void CachePODDataMMap(CDataCache &dc, const std::map<TKEY, C<TPOD> > &d);

template<typename TKEY, typename TPOD, template<typename D, typename A = std::allocator<D> > class C>
void RestorePODDataMMap(CDataCache &dc, std::map<TKEY, C<TPOD> > &d);


template<typename TCachable, template<typename D, typename A = std::allocator<D> > class C >
void CacheArray(CDataCache &dc, const C<TCachable> & d);

template<typename TCachable, template<typename D, typename A = std::allocator<D> > class C >
void RestoreArray(CDataCache &dc, C<TCachable> & d);

template<typename TKEY, typename TCachable>
void CacheMap(CDataCache &dc, const std::map<TKEY, TCachable>  & d);

template<typename TKEY, typename TCachable>
void RestoreMap(CDataCache &dc, std::map<TKEY, TCachable>  & d);

template<typename TKEY, typename TCachable, template<typename D, typename A = std::allocator<D> > class C>
void CacheMMap(CDataCache &dc, const std::map<TKEY, TCachable>  & d);

template<typename TKEY, typename TCachable, template<typename D, typename A = std::allocator<D> > class C>
void RestoreMMap(CDataCache &dc, std::map<TKEY, TCachable>  & d);

template <typename TCOMPSTORE>
void CacheCompactStore(CDataCache &dc, const TCOMPSTORE &d);

template <typename TCOMPSTORE>
void RestoreCompactStore(CDataCache &dc, TCOMPSTORE &d);
#include "impl/cacheops_impl.hpp"

#endif
