-- See the NOTICE file distributed with this work for additional information
-- regarding copyright ownership.
-- 
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
-- 
--      http://www.apache.org/licenses/LICENSE-2.0
-- 
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.

# patch_73_74_g.sql
#
# Title: Adding transcript index to transcript_intron_supporting_evidence
#
# Description:
#
# Adding an index on transcript id to transcript_intron_supporting_evidence to
# speed up retrieval of supporting features from a Transcript object 

CREATE INDEX transcript_idx ON transcript_intron_supporting_evidence(transcript_id);

# patch identifier
INSERT INTO meta (species_id, meta_key, meta_value) VALUES (NULL, 'patch', 'patch_73_74_g.sql|add_transcript_idx_tise');

 
