-- See the NOTICE file distributed with this work for additional information
-- regarding copyright ownership.
-- 
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
-- 
--      http://www.apache.org/licenses/LICENSE-2.0
-- 
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.

# patch_66_67_e.sql
#
# Title: Adding an index to gene canonical transcript id
#
# Description: This is a lookup which is normally fast but when we have a lot
# of genes in a core schema (multispecies DBs) then these queries slow down 
# 

ALTER TABLE gene ADD KEY canonical_transcript_id_idx (canonical_transcript_id);

# Patch identifier:
INSERT INTO meta (species_id, meta_key, meta_value)
  VALUES (NULL, 'patch', 'patch_66_67_e.sql|index_canonical_transcript_id');
