=head1 LICENSE

See the NOTICE file distributed with this work for additional information
regarding copyright ownership.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

=cut

package Bio::EnsEMBL::Compara::PipeConfig::Legacy::Example::LastzMasterConf_conf;

#
#Test with a master and pairwise alignment configuration file (lastz.conf)
#human chr 22 vs mouse chr 16 and human chr 22 vs rat chr 11
#Use lastz.conf to define the location of the core databases.
#Set the master to the ensembl release for this test only.
#

use strict;
use warnings;
use base ('Bio::EnsEMBL::Compara::PipeConfig::PairAligner_conf');  # Inherit from base PairAligner class


sub default_options {
    my ($self) = @_;
    return {
	    %{$self->SUPER::default_options},   # inherit the generic ones

	    #'master_db' => 'mysql://user@host/ensembl_compara_master',
	    master_db => 'mysql://ensro@ens-livemirror:3306/ensembl_compara_73', #set to ensembl release for test only

	    #Location of executables
	    'pair_aligner_exe' => '/software/ensembl/compara/bin/lastz',

	    #
            #Skip pairaligner stats module
            #
            'skip_pairaligner_stats' => 1,
            'bed_dir' => $self->o('dump_dir').'/bed_files', 
            'output_dir' => $self->o('dump_dir').'/output', 

 	   };
}

1;
