
# Extension for AnnoTrack using RedMine
# (C) Felix Kokocinski, WTSI, 2009
#
# Additional content for the issues controller & views


####### controller functions ##########


# index() is diverted to index_annotrack() in app/controller/issues_controller.rb !

require 'net/http'

def features_for_show 

    if(@template.check_input_string(params[:id])>0)
      redirect_to :controller => 'welcome', :action => 'index'
      return
    end

    #fsk: collect subfeatures
    @subfeatures = Subfeature.find( :all, :conditions => ["issue_id = ?", params[:id]] )
    @subfeatures = @subfeatures.sort_by { |a| a.subfeature_start }

    #fsk: collect flags
    @flags = Flag.find( :all, :conditions => ["issue_id = ?", params[:id]] ).sort_by { |a| a.flag_name }

    #get issue names for flag-causing-issues and solution strings for resolved flags
    @flagging_issue_names = Array.new
    @flagging_solutions = Array.new
    @flagging_notes = Array.new
    for flag in @flags
      if((defined? flag.flag_issue_id) and !(flag.flag_issue_id == 0) and !(flag.flag_issue_id.blank?))
        issue_id   = Issue.find(flag.flag_issue_id)
        if((defined? issue_id) and (issue_id != 0))
          issue_name = issue_id.subject
          if(defined? issue_name and !issue_name.blank?)
            @flagging_issue_names.push(issue_name)
            else
            @flagging_issue_names.push(' ')
          end
        end
      else
        @flagging_issue_names.push('-')
      end
      if(defined? flag.reason)
        @flagging_solutions.push(flag.reason)
      else
        @flagging_solutions.push(' ')
      end
	if(defined? flag.note and !flag.note.blank?)
          @flagging_notes.push(flag.note)
	else
          @flagging_notes.push(' ')
	end
    end	

    #collect flags of related issues
    @related_flags = Hash.new()
    if @issue.relations.any?
        @issue.relations.each do |relation|
           coll_flags = Array.new()
           relations_flags = Flag.find( :all, :conditions => ["issue_id = ?", relation.issue_to_id] ).sort_by { |a| a.flag_name }
           if(relations_flags.any?)
             relations_flags.each do |rf|
               coll_flags.push(rf.flag_name) 
             end
           else
             coll_flags.push("-")
           end

           @related_flags[relation.issue_to_id.to_s] = coll_flags
        end
    end

  #get secondary id
  @sec_id = IdConversion.get_other_id(@issue.subject)

  #get add. annotations
  @annotations = @issue.custom_values.find(:all, :include => :custom_field, :order => "#{CustomField.table_name}.position") 

end


####### view functions ##########

# links to various genome browsers and other sites
# adjust for your specific set-up
def show_browserlinks

 content = "<strong>" + l(:label_link_out) + "</strong>" +
  "<table cellspacing=10 cellpadding=5> " +
  "<tr>"

  if(Setting.browser_zfin=="1")
    genename = @issue.description.match(/Genename:\s(\w+)/)
    if(!(genename.nil?))
      genename = genename.to_s
      genename = genename.sub!("Genename: ", "")
      content = content + "<td>" + 
        link_to("ZFIN (gene name)", l(:zfin_link) + genename.to_s, :target => "_blank") +
        "</td>"
    end
  end

  if((Setting.browser_congo=="1") and @issue.subject.match("^CONGO.*"))
    loc = @issue.Tchrom + ':' + @issue.Tstart.to_s + '-' + @issue.Tend.to_s
    content = content + "<td>" +
      link_to("CONGO (region)", l(:congo_link1) + loc + l(:congo_link2), :target => "_blank") +
      "</td>"
  end

  if((Setting.browser_congo=="1") and @issue.subject.match("^CCDS.*"))
    ccds_links = @issue.subject.split('_')
    content = content + "<td>" +
      link_to("CCDS", l(:ccds_link) + ccds_links[0], :target => "_blank" ) +
      "</td>"
  end

  if((Setting.browser_vega_transcript=="1") and @issue.subject.match("^OTT.*"))
    content = content + "<td>" +
      link_to('VEGA (id)', l(:vega_transcript_link1) + Setting.organism.to_s + l(:vega_transcript_link2) +
              @issue.subject, :target => '_blank') +
      "</td>"
  end

  if((Setting.browser_ensembl_transcript=="1") and @issue.subject.match("^ENS.*"))
    content = content + "<td>" +
      link_to('ENSEMBL (id)', l(:ensembl_transcript_link1) + Setting.organism.to_s + l(:ensembl_transcript_link2) + 
              @issue.subject, :target => '_blank') + "</td>"
  end

  if(Setting.browser_vega_region=="1")
    link = l(:vega_region_link1) + Setting.organism + l(:vega_region_link2) + 
      @issue.Tchrom.to_s + ":" + @issue.Tstart.to_s + '-' + @issue.Tend.to_s
    if(!(Setting.browseradd_vega=="0"))
      link = link + Setting.browseradd_vega.to_s
    end
    content = content + "<td>" +
      link_to("VEGA (region)", link, :target => "_blank") + 
      "</td>"
  end

  if(Setting.browser_ensembl_region=="1")
    link = l(:ensembl_region_link1) + Setting.organism.to_s + l(:ensembl_region_link2) + 
      @issue.Tchrom.to_s + ":" + @issue.Tstart.to_s + '-' + @issue.Tend.to_s
    if(!(Setting.browseradd_ensembl=="0"))
      link = link + Setting.browseradd_ensembl.to_s
    end
    content = content + "<td>" +
      link_to("ENSEMBL (region)", link, :target => "_blank") + 
      "</td>"
  end

  if(Setting.browser_ucsc=="1")
    content = content + "<td>" +
      link_to("UCSC (region)", l(:ucsc_region_link1) + Setting.ucsc_db.to_s + l(:ucsc_region_link2) + @issue.Tchrom.to_s + ":" + 
              @issue.Tstart.to_s + '-' + @issue.Tend.to_s, :target => "_blank") +
      "</td>"
  end

  if(Setting.browser_ncbi=="1")
    content = content + "<td>" +
      link_to("NCBI (region)", l(:ncbi_region_link) + @issue.Tchrom.to_s + "&BEG=" + @issue.Tstart.to_s + '&END=' + 
              @issue.Tend.to_s, :target => "_blank") +
      "</td>"
  end


  content = content + "</tr></table><hr />"

 return content
end


# list all active flags for this transcript
def show_flags

 content = "<strong>Flags</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<small>"
 @link_newtag = "/flags/new?issue_id=#{@issue.id}"
 @issue_id = @issue.id
 content = content + link_to("[" + l(:label_add_flag) + "]", { :controller => 'flags', :action => 'new', :new_issue_id => @issue_id }, :popup =>false) +
	"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" +
	link_to("[" + l(:label_add_verifyflag) + "]", { :controller => 'flags', :action => 'new_tec', :new_issue_id => @issue_id }, :popup => false) +
	"</small>"
	
 if @flags.any?
   unresolved = 0
   content = content + form_tag(:controller => 'flags', :action => 'edit_all') + "<table cellspacing=10>"
   for i in 0..(@flags.length-1)
     flag = @flags[i]
     flagging_issue_name = @flagging_issue_names[i]
     flagging_solution = @flagging_solutions[i]
     flagging_note = @flagging_notes[i]
     content = content + "<tr><td>"
     if flag.flag_name =~ /^verify/
       if Tec.find_by_flag_id(flag.id).nil?
         content = content + "</td><td>Error finding flag!</td><td>&nbsp;</td></tr>\n"
         next
       end

       content = content + "<div class='tec'>" + flag.flag_name + "&nbsp;&nbsp;&nbsp;"
       userid = Tec.find_by_flag_id(flag.id).user
       username = User.find(userid).lastname
       content = content + "( " + username + ", " + flag.created_date.to_s + " )" + 
         "</div></td><td>&nbsp;</td><td>&nbsp;"
     else
       # checkbox for multiple selection
       if flag.checked_date.nil?
         content = content + check_box("flagselect", flag.id) +
           "&nbsp;&nbsp;&nbsp;"
       else
         content = content + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"
       end

       if flag.flag_issue_id.blank? or flag.flag_issue_id<1
         content = content + flag.flag_name
       else
         content = content + link_to(flag.flag_name, {:controller => 'issues', :action => 'show', :id => flag.flag_issue_id})
       end
       content = content + "&nbsp;&nbsp;&nbsp;( " + flagging_issue_name + ", &nbsp;&nbsp;" + flag.created_date.to_s + " )</td>"
       content = content + "<td>&nbsp;<em>" + flagging_note + "</em></td>"
       content = content + "<td>&nbsp;&nbsp;&nbsp;"
       if flag.checked_date
         content = content + link_to("resolved", { :controller => 'flags', :action => 'edit', :id => flag.id }, :popup =>false) +
           "&nbsp;&nbsp;" + flag.checked_date.to_s + "&nbsp;&nbsp;( " + flagging_solution + " )"
       else
         unresolved = 1
         content = content + link_to(image_tag("/images/check2.gif", :alt => "Flag correct"), { :controller => 'flags', :action => 'edit', :id => flag.id, :sol => "annotate" }, :popup =>false) +
 	     "&nbsp;&nbsp;&nbsp;" + 
             link_to(image_tag("/images/dismiss2.gif", :alt => "Flag wrong"),  { :controller => 'flags', :action => 'edit', :id => flag.id, :sol => "reject" }, :popup =>false) + "<br />\n"
       end
     end
     content = content + "</td></tr>\n"
   end
   # resolve multiple flags
   if(unresolved==1)
     content = content + "<tr><td>resolve all checked:&nbsp;&nbsp;&nbsp;" + 
       image_submit_tag("/images/check2.gif",   { :name => 'submitflag', :value => "annotate" }) +
       "&nbsp;&nbsp;&nbsp;" + 
       image_submit_tag("/images/dismiss2.gif", { :name => 'submitflag', :value => "reject" }) +
       "&nbsp;&nbsp;&nbsp;</td></tr>"
   end
   content = content + "\n</table></form>\n"
 end

 return content
end


# list all subfeatures (exons, etc)
def show_subfeatures

  content = ""
  if @subfeatures.any?
    content = content + "<hr />"
    content_for :header_tags do
      javascript_include_tag 'expand_content'
    end
    content = content + "<strong>" + l(:field_subfeatures) + "</strong>&nbsp;(" +
        @subfeatures.length.to_s + ")&nbsp;&nbsp;&nbsp;" +
	"[<a id='subfeaturetablelink' href=\"javascript:toggle1('subfeaturetable');\">+</a>]<br />\n" +
	"<div id=\"subfeaturetable\" style=\"display: none\">\n" +
        "<table cellspacing=10><tr>\n" +
	"<td>type</td>" +
	"<td>chromosome</td>" +
	"<td>start</td>" +
	"<td>end</td>" +
	"<td>phase</td>" +
        "<!-- <td>created</td>" +
	"<td>modified</td> -->\n" +
        "</tr>\n"
    for subfeature in @subfeatures
      content = content + "<tr style=\"bold\">\n" +
	"<td>" + subfeature.subfeature_type + "</td>" +
	"<td>" + subfeature.subfeature_chr.to_s + "</td>" +
	"<td>" + subfeature.subfeature_start.to_s + "</td>" +
	"<td>" + subfeature.subfeature_end.to_s + "</td>" +
	"<td>" + subfeature.subfeature_phase.to_s + "</td>" +
        "<!-- <td>" + subfeature.created_on.to_s + "</td>" +
	"<td>" + subfeature.updated_on.to_s + "</td> -->\n" +
        "</tr>\n"
    end
    content = content + "</table></div>\n"
  end

  return content
end


# list additional annotation (xrefs, etc.)
def show_additional_annotation

  valuecontent = ""
  count = 0
  if @annotations.any?
    for annotation in @annotations

      #filter for "^_"
      fname = annotation.custom_field.name.to_s
      if( fname =~ /^_/ )
        fname2 = fname.gsub(/^_/,"")
        fvalues = annotation.value.split(' (')
        fvalue1 = fvalues[0].to_s
        fvalue2 = fvalues[1].to_s.gsub!(/\)/,"")
        #create link #add_link_HGNC:
        linkname1 = "add_link_" + fname2
        linkname2 = "add_link_" + fname2 + "2"
        link = l(:"#{linkname1}") + fvalue2 + l(:"#{linkname2}")
        #create content
        valuecontent = valuecontent + "<tr><td>" + fname2 + ": " + fvalue1 + " (" + link_to(fvalue2, link, :target => "_blank" ) + ")" +
        "</td></tr>\n"
        count=count+1
      end

    end

    if count > 0
      content = "<hr />"
      content_for :header_tags do
        javascript_include_tag 'expand_content'
      end
      content = content + "<strong>" + l(:field_annotation) + "</strong>&nbsp;(" +
        count.to_s + ")&nbsp;&nbsp;&nbsp;" +
	"[<a id='annotationlink' href=\"javascript:toggle1('annotationtable');\">+</a>]<br />\n" +
	"<div id=\"annotationtable\" style=\"display: none\">\n" +
        "<table cellspacing=10><tr>\n";
      content = content + valuecontent + "</table></div>\n"
    end

  end

  return content
end


# display gene model image where possible,
# pulled from Ensembl or Havana in this case
def show_ensembl_image

  content = "<hr /><strong>" + l(:field_ensemblimage) + "</strong>&nbsp;&nbsp;" +
    "[<a id='ensemblimage_link' href=\"javascript:toggle1('ensemblimage');\">+</a>]<p>\n" +
    "<div id=\"ensemblimage\" style=\"display: none\">\n"
  tname = @issue.subject
  if((tname.match("^ENST.*")) or (tname.match("^ENS...T.*")) or (tname.match("^OTT...T.*")))
    if(tname.match("^ENST.*") or tname.match("^ENS...T.*"))
      base_url_1 = "http://www.ensembl.org/" + Setting.organism.to_s + "/Component/Transcript/Web/TranscriptImage?db=core;t="
    elsif(tname.match("^OTT...T.*"))
      base_url_1 = "http://vega.sanger.ac.uk/" + Setting.organism.to_s + "/Component/Transcript/Web/TranscriptImage?db=core;t="
    end
    base_url_2 = ";export=png"
    image_size = "-0.6"
    full_url = base_url_1 + @issue.subject + base_url_2 + image_size

    begin
      # check if exists!
      url = URI.parse(full_url)
      httpConn = Net::HTTP.new(url.host, url.port)
      httpConn.open_timeout = 2
      httpConn.read_timeout = 7
      # response = httpConn.request_head(full_url)
      response = httpConn.request_get(full_url)
    rescue Exception => err
      content = content + "Unable to fetch image<br /></div></p>"
      logger.debug "Error fetching image from Ensembl " + err
      return content
    end
    if(response.code == "200")
      if(response.read_body.match(".*not found.*"))
        content = ""
      else
        content = content + "<img src=\"" + full_url + "\" /><br />" + "</div></p>"
      end
    else
      content = content + "Unable to fetch image<br /></div></p>"
    end
  else
    content = ""
  end

  return content
end
