
=head1 NAME

gencode_tracking_system / set_flag_from_file

=head1 DESCRIPTION

Helper script for the GENCODE tracking system.
fill in the sequence for transcripts selected for experimental verification

=head1 CONTACT

Felix Kokocinski, fsk@sanger.ac.uk

=head1 COPYRIGHT

Copyright Felix Kokocinski, 2008-2010, 
supported by Wellcome Trust Sanger Institute (UK) 
and National Human Genome Research Institute (USA).

You may distribute this module under the same terms as perl itself, 
citing the original source.

=cut

use strict;
use warnings;
use gencode_tracking_system::core;
use gencode_tracking_system::config;

my $loutre_dbhost = "otterlive";
my $loutre_dbport = "3301";
my $loutre_dbname = "loutre_human";
my $loutre_dbuser = "ottro";
my $loutre_dbpass = "";

my $coordsys = "toplevel";
my $coordversion = "GRCh37";

my ($tracking_dbh, $loutre_dbh, $sql);
my %transcripts;

$tracking_dbh = connect_db($DBHOST, $DBPORT, $DBNAME, $DBUSER, $DBPASS)
  or die "cant connect to to database $DBNAME @ $DBHOST.\n";
print "Conected to $DBNAME @ $DBHOST.\n";

$loutre_dbh = connect_ensembl($loutre_dbhost, $loutre_dbport, $loutre_dbname, $loutre_dbuser, $loutre_dbpass)
  or die "cant connect to to database $loutre_dbname @ $loutre_dbhost.\n";
print "Conected to $loutre_dbname @ $loutre_dbhost.\n";

my $sa = $loutre_dbh->get_SliceAdaptor or die;

#get ids and coordinates of entries requiring update
$sql = 'SELECT id, chromosome, start, end, strand '.
       'FROM tec_features WHERE sequence IS NULL;';
my $prepare_si = $tracking_dbh->prepare($sql);

#prepare store statement
$sql = 'UPDATE tec_features SET sequence=? WHERE id=?';
my $prepare_update = $tracking_dbh->prepare($sql);

$prepare_si->execute();
while(my ($tf_id, $chrom, $start, $end, $strand) = $prepare_si->fetchrow_array){
  print "Have $coordsys, $coordversion, $chrom, $start, $end, $strand, $tf_id.\n";
  $strand eq '-'? $strand = -1 : $strand = 1;
  my $slice = $sa->fetch_by_region($coordsys, 11, $start, $end, $strand, $coordversion);
  print "SLICE: $slice\n"; next;
  if($slice){
    my $seq = $slice->seq;
    #store to db
    print "\t".$seq."\n";
  }
}



__END__
