class Flag < ActiveRecord::Base
   belongs_to :issues

   def self.get_stats

     resolved_flag_count = Hash.new(0)
     total_flag_hash = Hash.new(0)
     resolved_flag_hash = Hash.new{ |hash,key| hash[key] = Hash.new(0) }

     sql = ActiveRecord::Base.connection()

     query_result = sql.execute("select count(*) as count, flag_name as flag_name, reason as reason from flags where issue_id>0 and checked_date IS NOT NULL group by flag_name, reason order by flag_name, reason;")
     while row = query_result.fetch_row do
       resolved_flag_count[row[1]] += row[0].to_i
       resolved_flag_hash[row[1]][row[2]] = row[0].to_i
     end

     query_result = sql.execute("select count(*) as count, flag_name as flag_name from flags where issue_id>0 group by flag_name order by flag_name;")
       
     while row = query_result.fetch_row do
       total_flag_hash[row[1]] += row[0].to_i
     end

     result = { 'resolved' => resolved_flag_count,
                'total'    => total_flag_hash,
	        'hash'     => resolved_flag_hash }

     query_result.free
     return result

   end

end
