
=head1 NAME

gencode_tracking_system::update

=head1 DESCRIPTION

Helper script for the GENCODE tracking system.
Check all flags are remove duplicated entries, keeping those that have been resolved already.

=head1 CONTACT

Felix Kokocinski, fsk@sanger.ac.uk

=head1 COPYRIGHT

Copyright Felix Kokocinski, 2008-2010, 
supported by Wellcome Trust Sanger Institute (UK) 
and National Human Genome Research Institute (USA).

You may distribute this module under the same terms as perl itself, 
citing the original source.

=cut

use strict;
use warnings;
use gencode_tracking_system::core;
use gencode_tracking_system::config;
use Getopt::Long;

my ($sql, $flag_name);
my $tracking_dbh = connect_db($DBHOST, $DBPORT, $DBNAME, $DBUSER, $DBPASS)
  or die "cant connect to to database $DBNAME @ $DBHOST.\n";
print "Conected to $DBNAME @ $DBHOST ($WRITE).\n";

&GetOptions(
	    'flag_name:s'  => \$flag_name,
	   );

my $k = 0;
my %all_flags;
my @to_remove;
my %resolved;
my $limit = ''; #' limit 100';

#collect all flags
$sql = 'select id, issue_id, flag_name, note, checked_date from flags where flag_name like "'.$flag_name.'"'.$limit;
my $transcr_sth = $tracking_dbh->prepare($sql);
$transcr_sth->execute();
FLAG:
while(my ( $id, $issue_id, $flag_name, $note, $checked_date ) = $transcr_sth->fetchrow_array){

  #take first part of note field only
  my @notes = split(";", $note);
  my $notepart = $notes[0]."_".$notes[1];

  #create key
  my $flag_key = $flag_name."_".$issue_id."_".$notepart;

  #print "FLAG\t$flag_key\n";
  if(exists($all_flags{$flag_key})){

    #check if this one is resolved already
    if($checked_date and $checked_date ne "NULL"){
      #is the first one resolved?
      if(!$resolved{$flag_key}){
	#remove first one
	push(@to_remove, $all_flags{$flag_key});
      }
      else{
	#both were resolved already, ignore
	$k++;
      }
    }
    else{
      #remove this one
      push(@to_remove, $id);
    }
  }
  else{
    #record new flag
    $all_flags{$flag_key} = $id;
    #record resolved status
    if($checked_date and $checked_date ne "NULL"){
      $resolved{$flag_key} = 1;
    }
    else{
      $resolved{$flag_key} = 0;
    }
  }
}
$transcr_sth->finish;

#remove redundant ones
$sql = 'delete from flags where id = ?';
my $remove_sth = $tracking_dbh->prepare($sql);
foreach my $flag_id (@to_remove){
  print "REMOVE $flag_id\n";
  $remove_sth->execute($flag_id);
}

$remove_sth->finish;
disconnect_db($tracking_dbh);

print "FOUND ".(scalar keys %all_flags)." unique flags, ".(scalar @to_remove)." redundant ones, $k redundant ones were resolved already\n";
