
=head1 NAME

gencode_tracking_system / maintenance

=head1 DESCRIPTION

Helper script for the GENCODE tracking system for testing & maintanace.
Reads gencode_tracking_system::config settings.

=head1 SYNOPSIS

To delete all entries of the category "ENSEMBL_introns":
 perl scripts/maintenance.pl -delete category -what ENSEMBL_introns

=head1 CONTACT

Felix Kokocinski, fsk@sanger.ac.uk

=head1 COPYRIGHT

Copyright Felix Kokocinski, 2008-2010, 
supported by Wellcome Trust Sanger Institute (UK) 
and National Human Genome Research Institute (USA).

You may distribute this module under the same terms as perl itself, 
citing the original source.

=cut

use strict;
use warnings;
use Getopt::Long;
use gencode_tracking_system::core;
use gencode_tracking_system::config;

my $delete    = undef;
my $to_delete = undef;
my ($tracking_dbh, $category, $project, $issue);

&GetOptions(
	    'delete=s'    => \$delete,
	    'what=s'      => \$to_delete,
	   );

#connect to tracking system db
$tracking_dbh = connect_db($DBHOST, $DBPORT, $DBNAME, $DBUSER, $DBPASS)
  or die "cant connect to to database $DBNAME @ $DBHOST.\n";
if($VERBOSE){ print "Connected to $DBNAME @ $DBHOST.\n" }

if($delete){
  if($to_delete){
    if($delete eq "project"){      $project = $to_delete }
    elsif($delete eq "issue"){       $issue = $to_delete }
    elsif($delete eq "category"){
      my $category_id = get_category_id( $to_delete, $tracking_dbh );
      if(!$category_id){
	print STDERR "Could not find category $to_delete.\n";
	exit 1;
      }
      $category = $to_delete;
    }else{
      print STDERR "Please speciy delete.\n";
      exit 1;
    }

    print "DELETING $delete $to_delete? (y|n)\n";
    chomp ( my $answer = <> );
    if($answer =~ /y/i){
      delete_projects($tracking_dbh, $category, $project, $issue);
    }
  }
  elsif($delete eq "all"){
    print "DELETING ALL DATA??? (y|n)\n";
    chomp ( my $answer = <> );
    if($answer =~ /y/i){
      print "ARE YOU SURE? (y|n)\n";
      chomp ( my $answer = <> );
      if($answer =~ /y/i){
	delete_projects($tracking_dbh, $category, $project, $issue, 1);
      }
    }
  }

}

