#!/usr/local/ensembl/bin/perl -w

# Helper script for the GENCODE tracking system, to be run nightly.
#
# Connect to the external DAS servers,
# fetch data, store in internal tracking system db
# and recalculate dependant fields in db


package gencode_tracking_system::sources::ucsc_retro;

use strict;
use gencode_tracking_system::core;
use gencode_tracking_system::config;
use base 'Exporter';

our @EXPORT = qw( run_update );

sub run_update {
  my ($response, $chrom, $tracking_dbh, $prepare_hash, $user_id, $category_id, $previous_genes) = @_;

  my $gene_type   = "ucsc_retrofinder";
  my $gene_status = undef;
  my %new_features = ();

  my ($current_transcript_id, $current_gene_id);

  # go through loci
  while (my ($url, $features) = each %$response) {

    if(ref $features eq "ARRAY"){
      print "Received ".scalar @$features." features.\n" if $VERBOSE;

    FEATURES:
      foreach my $feature (@$features) {
	
	#remove duplicates from overlapping regions
	if(defined $previous_genes and exists $previous_genes->{$feature->{'feature_id'}}){
	  next FEATURES;
	}
	$new_features{$feature->{'feature_id'}} = 1;

	my %transcript;

	#build structure for transcript
	$transcript{'chrom'}        = $chrom;
	$transcript{'biotype'}      = $gene_type;
	$transcript{'status'}       = $gene_status;
	$transcript{'type'}         = "transcript";
	$transcript{'start'}        = $feature->{'start'};
	$transcript{'end'}          = $feature->{'end'};
	$transcript{'strand'}       = $feature->{'strand'};
	$transcript{'id'}           = $feature->{'feature_id'};
	$transcript{'description'}  = "Score: ".$feature->{'score'};


	#clone gene from transcript
	my %gene = %transcript;
	$gene{'type'} = "gene";
	$gene{'description'} = "";

	#store gene
	if($VERBOSE){
	  print "GENE:\n";
	  print_element(\%gene);
	}

	$current_gene_id = store_features($tracking_dbh, $prepare_hash, \%gene, 'gene', 0, 0, 
        				  $user_id, $category_id);

	#store transcript
	if($VERBOSE){
	  print "TRANSCRIPT:\n";
	  print_element(\%transcript);
	}
	$current_transcript_id = store_features($tracking_dbh, $prepare_hash, \%transcript,
						'transcript', $current_gene_id, 0, 
						$user_id, $category_id);

      }
      @$features = ();
    }
  }

  return \%new_features;
}


1;
