class Group < ActiveRecord::Base

  def self.group(*user_id)
    if(user_id.empty?)
      group_id = User.current.group_id
    else
      group_id = User.find(user_id[0]).group_id
    end
    group = Group.find_by_id(group_id)
  end


  def self.rights(group_id)
    rights = Group.find_by_id(group_id).rights.split(", ")
  end


  def self.right_to?(action, *add_parameter)

    user_id = add_parameter[0]||""
    action_specific = add_parameter[1]||""

    if(user_id.empty?)
      group_id = User.current.group_id
    else
      group_id = User.find(user_id).group_id
    end
    grouprights = Group.rights(group_id)

    right = grouprights.include?(action)

    #specific rights can be added to the action parameter:
    if(!right and !(action_specific.empty?))
      action = action + "_" + add_parameter[1].to_s
      right = grouprights.include?(action)
    end

    return right
  end


  def self.groups
    Group.find :all
  end
  
end
