#if !defined(__STRUCTIFX_HPP__)
#define __STRUCTIFX_HPP__

#include <corelib/ncbistr.hpp>
#include <corelib/ncbimisc.hpp>
#include <corelib/ncbitype.h>

typedef ncbi::TGi GI_t;
typedef ncbi::TTaxId TaxId_t;
typedef ncbi::TSeqPos SeqLen_t;
typedef ncbi::TSignedSeqPos SeqPos_t;

//typedef ncbi::TUintId PssmId_t, PIG_t, IPG_t, ArchId_t, PubMedId_t, GeneId_t, MmdbId_t;
typedef unsigned int PssmId_t, PIG_t, IPG_t, ArchId_t, PubMedId_t, GeneId_t, MmdbId_t, AssemblyId_t;
typedef Uint4 Flags_t;
//typedef ncbi::TIntId ClusterId_t, PrefTaxId_t;
typedef int ClusterId_t, PrefTaxId_t;

typedef int TCompatibleID;  // compatible with SQL int type. GI_t is not compatible

typedef double BitScore_t, EValue_t;


constexpr const SeqLen_t k_SeqLen_Max = ~((SeqLen_t)(-1));

enum class INTERNAL_CODE: int
{
	e_OK = 0,
	e_PIGPEN_HOLE = 1
};


#endif
