## RPSBlast Post-processor - Source Package

##### (revised 16 May 2023)

### Table of Contents

1. [Background](#background)
2. [Download the source package](#dwonload-the-source-packages)
3. [Build the source code](#build-the-source-code)
    1. [Obtain BLAST source package](#obtain-blast-source-package)
    2. [Embed rpsbproc source code](#embed-rpsbproc-source-code)
    3. [Build on Linux system](#build-on-linux-system)
    4. [Build on Windows system](#build-on-windows-system)


### Background

This is the source code package for the *RPSBlast Post-processor(rpsbproc)* command line utility, for users who prefer to build the programs on their own computers. For instruction on how to use this program, please download the binary package [here](https://ftp.ncbi.nih.gov/pub/mmdb/cdd/rpsbproc).

### Download the source package

`rpsbproc` utility must work with `rpsblast` or `rpstblastn` and requires the NCBI C++ core toolkit to build. The BLAST team provided an optimized version of the toolkit to support their set of BLAST programs, so we can just download their source package and add the `rpsbproc` project in so it is built along with all BLAST programs.<br /><br />

1. Download RpsbProc source package

    Download the RpsbProc source package [here](https://ftp.ncbi.nih.gov/pub/mmdb/cdd/RpsbProc/current/RpsbProc-src.tar.gz)  and untar it (Since you are reading this file, you probably have already done so):
    
    ```
    $ wget https://ftp.ncbi.nih.gov/pub/mmdb/cdd/rpsbproc/current/RpsbProc-src.tar.gz
    $ tar xzf RpsbProc-src.tar.gz
    $ cd RpsbProc
    $ tree
    
    .
    |-- HOWTO.build.md
    |-- src
    |   |-- Makefile.in
    |   |-- Makefile.rpsbproc.app
    |   |-- common
    ...........
    |   `-- rpsbproc_main.cpp
    `-- utils
        |-- embedsrc.sh
        `-- getblsrc.sh
    4 directories, 63 files
    ```

2. Download the latest BLAST source package

    Next we need to download the blast source package. The current version of blast is 2.14.0:
    ```
    $ wget https://ftp.ncbi.nih.gov/blast/executables/LATEST/ncbi-blast-2.14.0+-src.tar.gz && tar -xzf ncbi-blast-2.14.0+-src.tar.gz && rm -f ncbi-blast-2.14.0+-src.tar.gz
    $ tree
    .
    |-- HOWTO.build.md
    |-- ncbi-blast-2.14.0+-src
    |   `-- c++
    |       |-- compilers
    |       |   .........
    |       |-- configure
    |       |-- configure.orig
    |       |-- include
    |       |   .........
    |       |-- scripts
    |       |   .........
    |       `-- src
    |           |-- CMakeLists.txt
    |           |-- Makefile.in
    |           |-- algo
    |           |   .........
    |           |-- app
    .................
    |-- src
    |   |-- Makefile.in
    |   |-- Makefile.rpsbproc.app
    |   |-- common
    .................
    `-- utils
        |-- embedsrc.sh
        `-- getblsrc.sh
    
    547 directories, 6705 files
    ```
    
    On Linux system, the `utils/getblsrc.sh` shell script does this automatically. Just run
    
    ```
    $ utils/getblsrc.sh
    ```
    
    It will automatically download the latest version of BLAST source code package and unpack it.

3. Add the RpsbProc project source code to the BLAST package
    1. Create a subdirectory `RpsbProc` under `ncbi-blast-2.14.0+-src/c++/src/app` and copy all files and subdirectories in`src` directory into it:
        ```
        $ mkdir "ncbi-blast-2.14.0+-src/c++/src/app/RpsbProc"
		$ cp -r src/* ncbi-blast-2.14.0+-src/c++/src/app/RpsbProc/
        ```
    2. Edit ncbi-blast-2.14.0+-src/c++/src/app/Makefile.in to append `RpsbProc` (case sensitive, must match the name of the directory you just created) to the "SUB_PROJ" line:
		```
        $ vi ncbi-blast-2.9.0+-src/c++/src/app/Makefile.in
        ```
        On Linux, this can be done automatically with the following command:
        ```
        $ utils/embedsrc.sh -b ncbi-blast-2.14.0+-src
        ```
    Now the source code is ready to be built.
    
### Build the source code

On Linux system, just run the following commands:

```
$ cd ncbi-blast-2.14.0+-src/c++
$ ./configure
$ make -k -j10
```

It may take a while for the builder to finish. If successful, all built binaries are under

```
ncbi-blast-2.14.0+-src/c++/ReleaseMT/bin
```

If build on Windows system, we recommend to use VS2015 or later.<br /><br />

1. Launch VS and open the following solution:

    ```
    ncbi-blast-2.14.0+-src\c++\compilers\vs2015\static\build\ncbi_cpp.sln
    ```
    
2. Select the solution configuration `ReleaseDLL` and solution platform `x64`
3. Build the `_CONFIGURE_` project.<br /><br />
    *** Note: Visual Studio will prompt to reload solutions as it has been changed, but please leave the prompt window open and wait until the project is completely built *** <br /><br />
    
    After the build is complete, new projects are created. Click the "Reload All" button on the prompt window to reload all projects. It may take several minutes to complete.
4. After all projects are loaded, build the `_BUILD_ALL_` project. It may take some time to complete.
	
5. If successful, all built binaries should be under 
    ```
    ncbi-blast-2.9.0+-src\c++\compilers\vs2015\static\bin\ReleaseMT
    ```
    