template<typename T>
int CDataCache::WriteToBuffer(const T &data)
{
    int retval = CDataCache::eDataOk;
    try
    {
        data.SaveToCache(*this);
    }
    catch (int e) {retval = e;}
    return retval;
}


template<typename T>
int CDataCache::ReadFromBuffer(const T &data)
{
    int retval = CDataCache::eDataOk;
    try
    {
        data.RestoreFromCache(*this);
    }
    catch (int e) {retval = e;}
    return retval;
}


template<typename T>
int CDataCache::CacheData(const T& data, std::string &key)
{
    int retval = CDataCache::eDataOk;
    this->ResetData();
    try
    {
        data.SaveToCache(*this);
        retval = this->Flush(key);
    }
    catch (int e) {retval = e;}
    return retval;
}



template<typename T>
int CDataCache::RetrieveData(const std::string &key, T& data)
{
    int retval = CDataCache::eDataOk;
    this->ResetData();
    
    try
    {
        retval = this->Load(key);
        data.RestoreFromCache(*this);
    }
    catch (int e) {retval = e;}
    return retval;
    
}
