#include <ncbi_pch.hpp>
#include "cacheops.hpp"

using namespace std;
template<>
CDataCache & operator << (CDataCache &dc, const string & d)
{
    dc.PushString(d);
    return dc;
}
template<>
CDataCache & operator >> (CDataCache &dc, string & d)
{
    dc.ReadString(d);
    return dc;
}

template<>
void CachePODData(CDataCache &dc, const vector<string> & d)
{
    size_t ttl_items = d.size();
    dc << ttl_items;
    
    for (const string & s : d)
        dc << s;
}

template<>  //specialize for string vectors
void RestorePODData(CDataCache &dc, vector<string> & d)
{
    size_t ttl_items = 0;
    d.clear();
    dc >> ttl_items;
    if (ttl_items > 0)
    {
        d.insert(d.end(), ttl_items, string{});
        for (size_t i = 0; i < ttl_items; ++i)
            dc >> d[i];
    }
}

/////CDataCache & operator << (CDataCache &dc, const CPdbId& d)
/////{
/////	dc << d.m_usedelim;
/////	//dc.PushData(&d.m_usedelim, sizeof(char));
/////	dc.PushData(d.m_mol, (CPdbId::PDBMOL_LEN + 1) * sizeof(char));
/////	dc.PushData(d.m_chain, (CPdbId::PDBCHN_MAX_LEN + 1) * sizeof(char));
/////	
/////	return dc;
/////}
/////
/////CDataCache & operator >> (CDataCache &dc, CPdbId& d)
/////{
/////    dc >> d.m_usedelim;
/////	//dc.ReadData(&d.m_usedelim, sizeof(char));
/////	dc.ReadData(d.m_mol, (CPdbId::PDBMOL_LEN + 1) * sizeof(char));
/////	dc.ReadData(d.m_chain, (CPdbId::PDBCHN_MAX_LEN + 1) * sizeof(char));
/////	
/////	return dc;
/////}
/////
/////CDataCache & operator << (CDataCache &dc, const TDocsum& d)
/////{
/////	dc << d.m_iGi << d.m_strAccession << d.m_strNcbiId
/////        << d.m_uiSeqLen << d.m_strTitle << d.m_bIsNa << d.m_iTaxId
/////        << d.m_iGenCode << d.m_iMGenCode << d.m_strSciName << d.m_strBlastName << d.m_strCommonName;
/////    
/////        
/////	//dc.PushData(&d.m_iGi, sizeof(GI_t));
/////	//dc.PushString(d.m_strAccession);
/////	//dc.PushString(d.m_strNcbiId);
/////	//dc.PushData(&d.m_uiSeqLen, sizeof(SeqLen_t));
/////	//dc.PushString(d.m_strTitle);
/////	//dc.PushData(&d.m_bIsNa, sizeof(bool));
/////	//dc.PushData(&d.m_iTaxId, sizeof(TaxId_t));
/////	//// -- reference http://www.ncbi.nlm.nih.gov/Taxonomy/Utils/wprintgc.cgi
/////	//dc.PushData(&d.m_iGenCode, sizeof(int));
/////	//dc.PushData(&d.m_iMGenCode, sizeof(int));	//mitochondrial genetic code
/////	//dc.PushString(d.m_strSciName);	//scientific name
/////	//dc.PushString(d.m_strBlastName);	//blast name
/////	//dc.PushString(d.m_strCommonName);	//common name
/////	return dc;
/////}
/////
/////CDataCache & operator >> (CDataCache &dc, TDocsum& d)
/////{
/////    dc >> d.m_iGi >> d.m_strAccession >> d.m_strNcbiId
/////        >> d.m_uiSeqLen >> d.m_strTitle >> d.m_bIsNa >> d.m_iTaxId
/////        >> d.m_iGenCode >> d.m_iMGenCode >> d.m_strSciName >> d.m_strBlastName >> d.m_strCommonName;
/////    
/////	//dc.ReadData(&d.m_iGi, sizeof(GI_t));
/////	//dc.ReadString(d.m_strAccession);
/////	//dc.ReadString(d.m_strNcbiId);
/////	//dc.ReadData(&d.m_uiSeqLen, sizeof(SeqLen_t));
/////	//dc.ReadString(d.m_strTitle);
/////	//dc.ReadData(&d.m_bIsNa, sizeof(bool));
/////	//dc.ReadData(&d.m_iTaxId, sizeof(TaxId_t));
/////	//// -- reference http://www.ncbi.nlm.nih.gov/Taxonomy/Utils/wprintgc.cgi
/////	//dc.ReadData(&d.m_iGenCode, sizeof(int));
/////	//dc.ReadData(&d.m_iMGenCode, sizeof(int));	//mitochondrial genetic code
/////	//dc.ReadString(d.m_strSciName);	//scientific name
/////	//dc.ReadString(d.m_strBlastName);	//blast name
/////	//dc.ReadString(d.m_strCommonName);	//common name
/////	return dc;
/////}
/////
/////CDataCache & operator << (CDataCache &dc, const TSequence& d)
/////{
/////	dc << (const TDocsum&)d << d.m_iInputType << d.m_strCleanedInput
/////        << d.m_strSeqData << d.m_Src << d.m_B64PackedIds << d.m_OriDefline
/////        << d.m_iValid << d.m_iStatus << d.m_iPig << d.m_iFrom << d.m_iTo << d.m_vecMaskedRegions;
/////	//dc.PushData(&d.m_iInputType, sizeof(int));	//CCleanInput::EStringDataType values
/////	//dc.PushString(d.m_strCleanedInput);	//also from CCleanInput
/////	//dc.PushString(d.m_strSeqData);	//1-letter seqdata
/////	//dc.PushString(d.m_Src);
/////	//dc.PushString(d.m_B64PackedIds);
/////	//dc.PushString(d.m_OriDefline);
/////	//dc.PushData(&d.m_iValid, sizeof(int));
/////	//dc.PushData(&d.m_iStatus, sizeof(int));
/////	//dc.PushData(&d.m_iPig, sizeof(PIG_t));	//if has one. otherwise 0
/////	//// -- added 2012/4/12 -- for range. m_iStart is default to 0, m_iEnd is default to -1, meaning whole length.
/////	//dc.PushData(&d.m_iFrom, sizeof(SeqPos_t));
/////	//dc.PushData(&d.m_iTo, sizeof(SeqPos_t));
/////	////std::vector<int> m_vecGis;	//from db, 	alias gi
/////	//size_t n = d.m_vecMaskedRegions.size();
/////	//dc.PushData(&n, sizeof(size_t));
/////	//if (n > 0)
/////	//{
/////	//	const TSequence::__SegMask *p = &d.m_vecMaskedRegions.front();
/////	//	dc.PushData(p, n * sizeof(TSequence::__SegMask));
/////	//}
/////	
/////	return dc;
/////}
/////	
/////CDataCache & operator >> (CDataCache &dc, TSequence& d)
/////{
/////    dc >> (TDocsum&)d >> d.m_iInputType >> d.m_strCleanedInput
/////        >> d.m_strSeqData >> d.m_Src >> d.m_B64PackedIds >> d.m_OriDefline
/////        >> d.m_iValid >> d.m_iStatus >> d.m_iPig >> d.m_iFrom >> d.m_iTo >> d.m_vecMaskedRegions;
/////    
/////	//dc >> (TDocsum&)d;
/////	//dc.ReadData(&d.m_iInputType, sizeof(int));	//CCleanInput::EStringDataType values
/////	//dc.ReadString(d.m_strCleanedInput);	//also from CCleanInput
/////	//dc.ReadString(d.m_strSeqData);	//1-letter seqdata
/////	//dc.ReadString(d.m_Src);
/////	//dc.ReadString(d.m_B64PackedIds);
/////	//dc.ReadString(d.m_OriDefline);
/////	//dc.ReadData(&d.m_iValid, sizeof(int));
/////	//dc.ReadData(&d.m_iStatus, sizeof(int));
/////	//dc.ReadData(&d.m_iPig, sizeof(PIG_t));	//if has one. otherwise 0
/////	//// -- added 2012/4/12 -- for range. m_iStart is default to 0, m_iEnd is default to -1, meaning whole length.
/////	//dc.ReadData(&d.m_iFrom, sizeof(SeqPos_t));
/////	//dc.ReadData(&d.m_iTo, sizeof(SeqPos_t));
/////	////std::vector<int> m_vecGis;	//from db, 	alias gi
/////	//size_t n = 0;
/////	//dc.ReadData(&n, sizeof(size_t));
/////	//d.m_vecMaskedRegions.clear();
/////	//
/////	//if (n > 0)
/////	//{
/////	//	d.m_vecMaskedRegions.insert(d.m_vecMaskedRegions.end(), n, TSequence::__SegMask());
/////	//	TSequence::__SegMask *p = &d.m_vecMaskedRegions.front();
/////	//	dc.ReadData(p, n * sizeof(TSequence::__SegMask));
/////	//}
/////	
/////	return dc;
/////}
/////
///////CDataCache & operator << (CDataCache &dc, const CSegSet& d)
///////{
///////    dc << d.m_iFactor;
///////    ArraySaveToCache(dc, d.m_lstContainer);
///////    dc << d.m_ulGapThreshold;
///////    
///////	////dc.PushData(&d.m_iFactor, sizeof(int));
///////	//size_t n = d.m_lstContainer.size();
///////	//dc.PushData(&n, sizeof(size_t));
///////	//if (n > 0)
///////	//	for (const auto & v : d.m_lstContainer)
///////	//		dc.PushData(&v, sizeof(TSeg_base));
///////	//dc.PushData(&d.m_ulGapThreshold, sizeof(SeqLen_t));
///////	return dc;
///////}
///////
///////CDataCache & operator >> (CDataCache &dc, CSegSet& d)
///////{
///////    dc >> d.m_iFactor;
///////    ArrayReadFromCache(dc, d.m_lstContainer);
///////    dc >> d.m_ulGapThreshold;
///////    
///////	//dc.ReadData(&d.m_iFactor, sizeof(int));
///////	//
///////	//size_t n = 0;
///////	//dc.ReadData(&n, sizeof(size_t));
///////	//d.m_lstContainer.clear();
///////	//if (n > 0)
///////	//	for (size_t i = 0; i < n; ++i)
///////	//	{
///////	//		d.m_lstContainer.emplace_back();
///////	//		dc.ReadData(&d.m_lstContainer.back(), sizeof(TSeg_base));
///////	//	}
///////	//dc.ReadData(&d.m_ulGapThreshold, sizeof(SeqLen_t));
///////	return dc;
///////}
/////
/////CDataCache & operator << (CDataCache &dc, const TDomSite& d)
/////{
/////	dc << (const CSegSet &)d << d.m_strTitle << d.m_strDescr << d.m_strMotif
/////        << d.m_iMotifuse << d.m_iIndex << d.m_iType << d.m_iCompleteSize << d.m_flags;
/////	//dc.PushString(d.m_strTitle);	//short title
/////	//dc.PushString(d.m_strDescr);	//descrption, future use
/////	//dc.PushString(d.m_strMotif);
/////	//dc.PushData(&d.m_iMotifuse, sizeof(int));
/////	//dc.PushData(&d.m_iIndex, sizeof(int));
/////	//dc.PushData(&d.m_iType, sizeof(int));
/////	//dc.PushData(&d.m_iCompleteSize, sizeof(SeqPos_t));
/////	//dc.PushData(&d.m_flags, sizeof(Flags_t));
/////	return dc;
/////}
/////
/////CDataCache & operator >> (CDataCache &dc, TDomSite& d)
/////{
/////    dc >> (CSegSet &)d >> d.m_strTitle >> d.m_strDescr >> d.m_strMotif
/////        >> d.m_iMotifuse >> d.m_iIndex >> d.m_iType >> d.m_iCompleteSize >> d.m_flags;
/////    
/////	//dc >> (CSegSet &)d;
/////	//dc.ReadString(d.m_strTitle);	//short title
/////	//dc.ReadString(d.m_strDescr);	//descrption, future use
/////	//dc.ReadString(d.m_strMotif);
/////	//dc.ReadData(&d.m_iMotifuse, sizeof(int));
/////	//dc.ReadData(&d.m_iIndex, sizeof(int));
/////	//dc.ReadData(&d.m_iType, sizeof(int));
/////	//dc.ReadData(&d.m_iCompleteSize, sizeof(SeqPos_t));
/////	//dc.ReadData(&d.m_flags, sizeof(Flags_t));
/////	return dc;
/////}
/////
/////CDataCache & operator << (CDataCache &dc, const TCluster& d)
/////{
/////    dc << d.m_uiPssmId << d.m_uiLength << d.m_iClusterId << d.m_strAccession
/////        << d.m_strShortName << d.m_strTitle << d.m_strDefline;
/////	//dc.PushData(&d.m_uiPssmId, sizeof(PssmId_t));
/////	//dc.PushData(&d.m_uiLength, sizeof(SeqLen_t));
/////	//dc.PushData(&d.m_iClusterId, sizeof(ClusterId_t));
/////	//
/////	//dc.PushString(d.m_strAccession);
/////	//dc.PushString(d.m_strShortName);
/////	//dc.PushString(d.m_strTitle);
/////	//dc.PushString(d.m_strDefline);
/////	return dc;
/////};
/////
/////CDataCache & operator >> (CDataCache &dc, TCluster& d)
/////{
/////    dc >> d.m_uiPssmId >> d.m_uiLength >> d.m_iClusterId >> d.m_strAccession
/////        >> d.m_strShortName >> d.m_strTitle >> d.m_strDefline;
/////	//dc.ReadData(&d.m_uiPssmId, sizeof(PssmId_t));
/////	//dc.ReadData(&d.m_uiLength, sizeof(SeqLen_t));
/////	//dc.ReadData(&d.m_iClusterId, sizeof(ClusterId_t));
/////	//
/////	//dc.ReadString(d.m_strAccession);
/////	//dc.ReadString(d.m_strShortName);
/////	//dc.ReadString(d.m_strTitle);
/////	//dc.ReadString(d.m_strDefline);
/////	return dc;
/////};
/////
/////CDataCache & operator << (CDataCache &dc, const TDomain& d)
/////{
/////	dc << (const TCluster&)d << d.m_uiHierarchyRoot << d.m_uiHierarchyParent
/////        << d.m_uiClusterPssmId << d.m_dMinBitScore << d.m_bCurated << d.m_bIsStructDom
/////        << d.m_bMultiDom << d.m_strConsensus << d.m_strSource;
/////	//dc.PushData(&d.m_uiHierarchyRoot, sizeof(PssmId_t));	//root pssmid
/////	//dc.PushData(&d.m_uiHierarchyParent, sizeof(PssmId_t));	//root pssmid
/////	//dc.PushData(&d.m_uiClusterPssmId, sizeof(PssmId_t));
/////	//dc.PushData(&d.m_dMinBitScore, sizeof(double));
/////	//dc.PushData(&d.m_bCurated, sizeof(bool));
/////	//dc.PushData(&d.m_bIsStructDom, sizeof(bool));
/////	//dc.PushData(&d.m_bMultiDom, sizeof(bool));
/////	//
/////	//dc.PushString(d.m_strConsensus);
/////	//dc.PushString(d.m_strSource);
/////    
/////    ArraySaveToCache(dc, d.m_lstSpecificFeatures);
/////    ArraySaveToCache(dc, d.m_lstGenericFeatures);
/////	
/////	//size_t n = d.m_lstSpecificFeatures.size();
/////	//dc.PushData(&n, sizeof(size_t));
/////	//if (n > 0)
/////	//{
/////	//	for (const auto & v: d.m_lstSpecificFeatures)
/////	//		dc << v;
/////	//}
/////	//n = d.m_lstGenericFeatures.size();
/////	//dc.PushData(&n, sizeof(size_t));
/////	//if (n > 0)
/////	//{
/////	//	for (const auto & v: d.m_lstGenericFeatures)
/////	//		dc << v;
/////	//}
/////	return dc;
/////}
/////
/////
/////CDataCache & operator >> (CDataCache &dc, TDomain& d)
/////{
/////    dc >> (TCluster&)d >> d.m_uiHierarchyRoot >> d.m_uiHierarchyParent
/////        >> d.m_uiClusterPssmId >> d.m_dMinBitScore >> d.m_bCurated >> d.m_bIsStructDom
/////        >> d.m_bMultiDom >> d.m_strConsensus >> d.m_strSource;
/////    
/////    ArrayReadFromCache(dc, d.m_lstSpecificFeatures);
/////    ArrayReadFromCache(dc, d.m_lstGenericFeatures);
/////    
/////	//dc >> (TCluster&)d;
/////	//dc.ReadData(&d.m_uiHierarchyRoot, sizeof(PssmId_t));	//root pssmid
/////	//dc.ReadData(&d.m_uiHierarchyParent, sizeof(PssmId_t));	//root pssmid
/////	//dc.ReadData(&d.m_uiClusterPssmId, sizeof(PssmId_t));
/////	//dc.ReadData(&d.m_dMinBitScore, sizeof(double));
/////	//dc.ReadData(&d.m_bCurated, sizeof(bool));
/////	//dc.ReadData(&d.m_bIsStructDom, sizeof(bool));
/////	//dc.ReadData(&d.m_bMultiDom, sizeof(bool));
/////	//dc.ReadString(d.m_strConsensus);
/////	//dc.ReadString(d.m_strSource);
/////	//
/////	//size_t n = 0;
/////	//dc.ReadData(&n, sizeof(size_t));
/////	//d.m_lstSpecificFeatures.clear();
/////	//if (n > 0)
/////	//{
/////	//	TDomSite v;
/////	//	for (size_t i = 0; i < n; ++i)
/////	//	{
/////	//		d.m_lstSpecificFeatures.emplace_back(v);
/////	//		dc >> d.m_lstSpecificFeatures.back();
/////	//	}
/////	//}
/////	//
/////	//n = 0;
/////	//dc.ReadData(&n, sizeof(size_t));
/////	//d.m_lstGenericFeatures.clear();
/////	//if (n > 0)
/////	//{
/////	//	TDomSite v;
/////	//	for (size_t i = 0; i < n; ++i)
/////	//	{
/////	//		d.m_lstGenericFeatures.emplace_back(v);
/////	//		dc >> d.m_lstGenericFeatures.back();
/////	//	}
/////	//}
/////	return dc;
/////}
/////
/////CDataCache & operator << (CDataCache &dc, const TDomArch& d)
/////{
/////    dc << d.m_uiArchId << d.m_strArchString << d.m_strReviewLevel;
/////    
/////	//dc.PushData(&d.m_uiArchId, sizeof(ArchId_t));
/////	//dc.PushString(d.m_strArchString);
/////	//dc.PushString(d.m_strReviewLevel);
/////	return dc;
/////}
/////CDataCache & operator >> (CDataCache &dc, TDomArch& d)
/////{
/////    dc >> d.m_uiArchId >> d.m_strArchString >> d.m_strReviewLevel;
/////	//dc.ReadData(&d.m_uiArchId, sizeof(ArchId_t));
/////	//dc.ReadString(d.m_strArchString);
/////	//dc.ReadString(d.m_strReviewLevel);
/////	return dc;
/////}
/////
/////CDataCache & operator << (CDataCache &dc, const TSpDomArch& d)
/////{
/////	dc << (const TDomArch &)d << d.m_strName << d.m_strLabel << d.m_uiSupFamArchId; 
/////	//dc.PushString(d.m_strName);
/////	//dc.PushString(d.m_strLabel);
/////	//dc.PushData(&d.m_uiSupFamArchId, sizeof(ArchId_t));
/////	return dc;
/////}
/////CDataCache & operator >> (CDataCache &dc, TSpDomArch& d)
/////{
/////    dc >> (TDomArch &)d >> d.m_strName >> d.m_strLabel >> d.m_uiSupFamArchId; 
/////	//dc >> (TDomArch &)d;
/////	//dc.ReadString(d.m_strName);
/////	//dc.ReadString(d.m_strLabel);
/////	//dc.ReadData(&d.m_uiSupFamArchId, sizeof(ArchId_t));
/////	return dc;
/////}
/////
/////CDataCache & operator << (CDataCache &dc, const TSeqAlignment& d)
/////{
/////    dc << d.m_uiAlignedLen << d.m_dAlignedPct << d.m_iScore << d.m_dEValue
/////        << d.m_dBitScore << d.m_iNumIdent << d.m_dSeqIdentity << d.m_eAlignType
/////        << d.m_bIsMinus << d.m_ReadingFrame << d.m_iFrom << d.m_iTo
/////        << d.m_vecMStarts << d.m_vecSStarts << d.m_vecLens << d.m_ClipSet;
/////    
/////	//dc.PushData(&d.m_uiAlignedLen, sizeof(SeqLen_t));
/////	//dc.PushData(&d.m_dAlignedPct, sizeof(double));
/////	//dc.PushData(&d.m_iScore, sizeof(int));
/////	//dc.PushData(&d.m_dEValue, sizeof(double));
/////	//dc.PushData(&d.m_dBitScore, sizeof(double));
/////	//dc.PushData(&d.m_iNumIdent, sizeof(int));
/////	//dc.PushData(&d.m_dSeqIdentity, sizeof(double));
/////	//dc.PushData(&d.m_eAlignType, sizeof(TSeqAlignment::EAlignType));
/////	////dc.PushData(&d.m_eStrand, sizeof(int));
/////	//dc.PushData(&d.m_bIsMinus, sizeof(bool));
/////	//dc.PushData(&d.m_ReadingFrame, sizeof(READINGFRAME::TFRAMEINDEX));
/////	//
/////	//dc.PushData(&d.m_iFrom, sizeof(SeqPos_t));
/////	//dc.PushData(&d.m_iTo, sizeof(SeqPos_t));
/////	//
/////	//size_t n = d.m_vecMStarts.size();
/////	//dc.PushData(&n, sizeof(size_t));
/////	//if (n > 0)
/////	//{
/////	//	const SeqPos_t * p = &d.m_vecMStarts.front();
/////	//	dc.PushData(p, n * sizeof(SeqPos_t));
/////	//}
/////	//
/////	//n = d.m_vecSStarts.size();
/////	//dc.PushData(&n, sizeof(size_t));
/////	//if (n > 0)
/////	//{
/////	//	const SeqPos_t * p = &d.m_vecSStarts.front();
/////	//	dc.PushData(p, n * sizeof(SeqPos_t));
/////	//}
/////	//
/////	//n = d.m_vecLens.size();
/////	//dc.PushData(&n, sizeof(size_t));
/////	//if (n > 0)
/////	//{
/////	//	const SeqLen_t * p = &d.m_vecLens.front();
/////	//	dc.PushData(p, n * sizeof(SeqLen_t));
/////	//}
/////	//
/////	//
/////	//dc << d.m_ClipSet;
/////	return dc;
/////}
/////
/////CDataCache & operator >> (CDataCache &dc, TSeqAlignment& d)
/////{
/////    dc >> d.m_uiAlignedLen >> d.m_dAlignedPct >> d.m_iScore >> d.m_dEValue
/////        >> d.m_dBitScore >> d.m_iNumIdent >> d.m_dSeqIdentity >> d.m_eAlignType
/////        >> d.m_bIsMinus >> d.m_ReadingFrame >> d.m_iFrom >> d.m_iTo
/////        >> d.m_vecMStarts >> d.m_vecSStarts >> d.m_vecLens >> d.m_ClipSet;
/////    
/////    
/////	//dc.ReadData(&d.m_uiAlignedLen, sizeof(SeqLen_t));
/////	//dc.ReadData(&d.m_dAlignedPct, sizeof(double));
/////	//dc.ReadData(&d.m_iScore, sizeof(int));
/////	//dc.ReadData(&d.m_dEValue, sizeof(double));
/////	//dc.ReadData(&d.m_dBitScore, sizeof(double));
/////	//dc.ReadData(&d.m_iNumIdent, sizeof(int));
/////	//dc.ReadData(&d.m_dSeqIdentity, sizeof(double));
/////	//dc.ReadData(&d.m_eAlignType, sizeof(TSeqAlignment::EAlignType));
/////	////dc.ReadData(&d.m_eStrand, sizeof(int));
/////	//dc.ReadData(&d.m_bIsMinus, sizeof(bool));
/////	//dc.ReadData(&d.m_ReadingFrame, sizeof(READINGFRAME::TFRAMEINDEX));
/////	//
/////	//dc.ReadData(&d.m_iFrom, sizeof(SeqPos_t));
/////	//dc.ReadData(&d.m_iTo, sizeof(SeqPos_t));
/////	//
/////	//
/////	//size_t n = 0;
/////	//dc.ReadData(&n, sizeof(size_t));
/////	//d.m_vecMStarts.clear();
/////	//if (n > 0)
/////	//{
/////	//	d.m_vecMStarts.insert(d.m_vecMStarts.end(), n, 0);
/////	//	SeqPos_t * p = &d.m_vecMStarts.front();
/////	//	dc.ReadData(p, n * sizeof(SeqPos_t));
/////	//}
/////	//
/////	//n = 0;
/////	//dc.ReadData(&n, sizeof(size_t));
/////	//d.m_vecSStarts.clear();
/////	//if (n > 0)
/////	//{
/////	//	d.m_vecSStarts.insert(d.m_vecSStarts.end(), n, 0);
/////	//	SeqPos_t * p = &d.m_vecSStarts.front();
/////	//	dc.ReadData(p, n * sizeof(SeqPos_t));
/////	//}
/////	//
/////	//n = 0;
/////	//dc.ReadData(&n, sizeof(size_t));
/////	//d.m_vecLens.clear();
/////	//if (n > 0)
/////	//{
/////	//	d.m_vecLens.insert(d.m_vecLens.end(), n, 0);
/////	//	SeqLen_t * p = &d.m_vecLens.front();
/////	//	dc.ReadData(p, n * sizeof(SeqLen_t));
/////	//}
/////	//
/////	//dc >> d.m_ClipSet;
/////	
/////	return dc;
/////}
/////
/////CDataCache & operator << (CDataCache &dc, const TDomSeqAlignment& d)
/////{
/////    dc << (const TSeqAlignment &)d << d.m_uiPssmId << d.m_iRegionIdx << d.m_dNMissing
/////        << d.m_dCMissing << d.m_bSpecQualified << d.m_iRepClass << d.m_bRep
/////        << d.m_bLifted << d.m_bSuppressed;
/////	//dc << (const TSeqAlignment &)d;
/////	//dc.PushData(&d.m_uiPssmId, sizeof(PssmId_t));
/////	//dc.PushData(&d.m_iRegionIdx, sizeof(int));
/////	//dc.PushData(&d.m_dNMissing, sizeof(double));
/////	//dc.PushData(&d.m_dCMissing, sizeof(double));
/////	//dc.PushData(&d.m_bSpecQualified, sizeof(bool));
/////	//dc.PushData(&d.m_iRepClass, sizeof(int));
/////	//dc.PushData(&d.m_bRep, sizeof(bool));
/////	//dc.PushData(&d.m_bLifted, sizeof(bool));
/////	//dc.PushData(&d.m_bSuppressed, sizeof(bool));
/////	return dc;
/////}
/////CDataCache & operator >> (CDataCache &dc, TDomSeqAlignment& d)
/////{
/////    dc >> (TSeqAlignment &)d >> d.m_uiPssmId >> d.m_iRegionIdx >> d.m_dNMissing
/////        >> d.m_dCMissing >> d.m_bSpecQualified >> d.m_iRepClass >> d.m_bRep
/////        >> d.m_bLifted >> d.m_bSuppressed;
/////	//dc >> (TSeqAlignment &)d;
/////	//dc.ReadData(&d.m_uiPssmId, sizeof(PssmId_t));
/////	//dc.ReadData(&d.m_iRegionIdx, sizeof(int));
/////	//dc.ReadData(&d.m_dNMissing, sizeof(double));
/////	//dc.ReadData(&d.m_dCMissing, sizeof(double));
/////	//dc.ReadData(&d.m_bSpecQualified, sizeof(bool));
/////	//dc.ReadData(&d.m_iRepClass, sizeof(int));
/////	//dc.ReadData(&d.m_bRep, sizeof(bool));
/////	//dc.ReadData(&d.m_bLifted, sizeof(bool));
/////	//dc.ReadData(&d.m_bSuppressed, sizeof(bool));
/////	return dc;
/////}
/////
/////CDataCache & operator << (CDataCache &dc, const TDomSeqAlignIndex& d)
/////{
/////    dc << d.m_vecSortedIndice << d.m_vecConciseIndice << d.m_vecStdIndice
/////        << d.m_vecQualifiedFeatIndice << d.m_vecSDIndice;
/////	//size_t n = d.m_vecSortedIndice.size();
/////	//dc.PushData(&n, sizeof(size_t));
/////	//if (n > 0)
/////	//{
/////	//	const size_t *p = &d.m_vecSortedIndice.front();
/////	//	dc.PushData(p, n * sizeof(size_t));
/////	//}
/////	//
/////	//n = d.m_vecConciseIndice.size();
/////	//dc.PushData(&n, sizeof(size_t));
/////	//if (n > 0)
/////	//{
/////	//	const size_t *p = &d.m_vecConciseIndice.front();
/////	//	dc.PushData(p, n * sizeof(size_t));
/////	//}
/////	//
/////	//n = d.m_vecStdIndice.size();
/////	//dc.PushData(&n, sizeof(size_t));
/////	//if (n > 0)
/////	//{
/////	//	const size_t *p = &d.m_vecStdIndice.front();
/////	//	dc.PushData(p, n * sizeof(size_t));
/////	//}
/////	//
/////	//n = d.m_vecQualifiedFeatIndice.size();
/////	//dc.PushData(&n, sizeof(size_t));
/////	//if (n > 0)
/////	//{
/////	//	const size_t *p = &d.m_vecQualifiedFeatIndice.front();
/////	//	dc.PushData(p, n * sizeof(size_t));
/////	//}
/////	//
/////	//n = d.m_vecSDIndice.size();
/////	//dc.PushData(&n, sizeof(size_t));
/////	//if (n > 0)
/////	//{
/////	//	const size_t *p = &d.m_vecSDIndice.front();
/////	//	dc.PushData(p, n * sizeof(size_t));
/////	//}
/////	return dc;
/////}
/////CDataCache & operator >> (CDataCache &dc, TDomSeqAlignIndex& d)
/////{
/////    dc >> d.m_vecSortedIndice >> d.m_vecConciseIndice >> d.m_vecStdIndice
/////        >> d.m_vecQualifiedFeatIndice >> d.m_vecSDIndice;
/////	//size_t n = 0;
/////	//dc.ReadData(&n, sizeof(size_t));
/////	//d.m_vecSortedIndice.clear();
/////	//if (n > 0)
/////	//{
/////	//	d.m_vecSortedIndice.insert(d.m_vecSortedIndice.end(), n, 0);
/////	//	size_t *p = &d.m_vecSortedIndice.front();
/////	//	dc.ReadData(p, n * sizeof(size_t));
/////	//}
/////	//
/////	//n = 0;
/////	//dc.ReadData(&n, sizeof(size_t));
/////	//d.m_vecConciseIndice.clear();
/////	//if (n > 0)
/////	//{
/////	//	d.m_vecConciseIndice.insert(d.m_vecConciseIndice.end(), n, 0);
/////	//	size_t *p = &d.m_vecConciseIndice.front();
/////	//	dc.ReadData(p, n * sizeof(size_t));
/////	//}
/////	//
/////	//n = 0;
/////	//dc.ReadData(&n, sizeof(size_t));
/////	//d.m_vecStdIndice.clear();
/////	//if (n > 0)
/////	//{
/////	//	d.m_vecStdIndice.insert(d.m_vecStdIndice.end(), n, 0);
/////	//	size_t *p = &d.m_vecStdIndice.front();
/////	//	dc.ReadData(p, n * sizeof(size_t));
/////	//}
/////	//
/////	//n = 0;
/////	//dc.ReadData(&n, sizeof(size_t));
/////	//d.m_vecQualifiedFeatIndice.clear();
/////	//if (n > 0)
/////	//{
/////	//	d.m_vecQualifiedFeatIndice.insert(d.m_vecQualifiedFeatIndice.end(), n, 0);
/////	//	size_t *p = &d.m_vecQualifiedFeatIndice.front();
/////	//	dc.ReadData(p, n * sizeof(size_t));
/////	//}
/////	//n = 0;
/////	//dc.ReadData(&n, sizeof(size_t));
/////	//d.m_vecSDIndice.clear();
/////	//if (n > 0)
/////	//{
/////	//	d.m_vecSDIndice.insert(d.m_vecSDIndice.end(), n, 0);
/////	//	size_t *p = &d.m_vecSDIndice.front();
/////	//	dc.ReadData(p, n * sizeof(size_t));
/////	//}
/////	
/////	return dc;
/////}
/////
/////CDataCache & operator << (CDataCache &dc, const TDomQuery& d)
/////{
/////	dc << (const TSequence &)d << d.m_iDataSrc;
/////    
/////    ArraySaveToCache(dc, d.m_vecAlignments);
/////    
/////	//dc.PushData(&d.m_iDataSrc, sizeof(int));
/////	//size_t n = d.m_vecAlignments.size();
/////	//dc.PushData(&n, sizeof(size_t));;
/////	//
/////	//if (n > 0)
/////	//	for (const auto & v : d.m_vecAlignments)
/////	//		dc << v;
/////	
/////	for (size_t i = 0; i < READINGFRAME::TOTAL_RFS; ++i)
/////		dc << d.m_dimSplitAligns[i];
/////	
/////	return dc;
/////}
/////
/////CDataCache & operator >> (CDataCache &dc, TDomQuery& d)
/////{
/////    dc >> (TSequence &)d >> d.m_iDataSrc;
/////    
/////    for (size_t i = 0; i < READINGFRAME::TOTAL_RFS; ++i)
/////		dc >> d.m_dimSplitAligns[i];
/////	
/////	//dc >> (TSequence &)d;
/////	//dc.ReadData(&d.m_iDataSrc, sizeof(int));
/////	//
/////	//size_t n = 0;
/////	//dc.ReadData(&n, sizeof(size_t));
/////	//d.m_vecAlignments.clear();
/////	//if (n > 0)
/////	//{
/////	//	d.m_vecAlignments.insert(d.m_vecAlignments.end(), n, TDomSeqAlignment());
/////	//	for (size_t i = 0; i < n; ++i)
/////	//		dc >> d.m_vecAlignments[i];
/////	//}
/////	//
/////	//for (size_t i = 0; i < READINGFRAME::TOTAL_RFS; ++i)
/////	//	dc >> d.m_dimSplitAligns[i];
/////	
/////	return dc;
/////}
/////
/////CDataCache & operator << (CDataCache &dc, const TSnpData& d)
/////{
/////    dc << d.iSnpId << d.iSnpTitle << d.iMstPos << d.iNbrPos << d.strType << d.strId
/////        << d.cOriRes << d.cMutRes;
/////	//dc.PushData(&d.iSnpId, sizeof(int));
/////	//dc.PushData(&d.iSnpTitle, sizeof(int));
/////	//dc.PushData(&d.iMstPos, sizeof(SeqPos_t));
/////	//dc.PushData(&d.iNbrPos, sizeof(SeqPos_t));
/////	//dc.PushString(d.strType);
/////	//dc.PushString(d.strId);
/////	//dc.PushData(&d.cOriRes, sizeof(char));
/////	//dc.PushData(&d.cMutRes, sizeof(char));
/////	return dc;
/////}
/////
/////CDataCache & operator >> (CDataCache &dc, TSnpData& d)
/////{
/////    dc >> d.iSnpId >> d.iSnpTitle >> d.iMstPos >> d.iNbrPos >> d.strType >> d.strId
/////        >> d.cOriRes >> d.cMutRes;
/////    
/////	//dc.ReadData(&d.iSnpId, sizeof(int));
/////	//dc.ReadData(&d.iSnpTitle, sizeof(int));
/////	//dc.ReadData(&d.iMstPos, sizeof(SeqPos_t));
/////	//dc.ReadData(&d.iNbrPos, sizeof(SeqPos_t));
/////	//dc.ReadString(d.strType);
/////	//dc.ReadString(d.strId);
/////	//dc.ReadData(&d.cOriRes, sizeof(char));
/////	//dc.ReadData(&d.cMutRes, sizeof(char));
/////	return dc;
/////}
/////
/////CDataCache & operator << (CDataCache &dc, const TBlastParams& d)
/////{
/////    dc << d.m_bUseLift << d.m_bUseSuppression << d.m_iSearchMode << d.m_strDbPath
/////        << d.m_strDbName << d.m_dEValCutOff << d.m_bLCFilter << d.m_bCompBasedAdj
/////        << d.m_nMaxHits << d.m_fDataOpts;
/////    
/////	//dc.PushData(&d.m_bUseLift, sizeof(bool));
/////	//dc.PushData(&d.m_bUseSuppression, sizeof(bool));
/////	//dc.PushData(&d.m_iSearchMode, sizeof(int));
/////	//dc.PushString(d.m_strDbPath);
/////	//dc.PushString(d.m_strDbName);
/////	//dc.PushData(&d.m_dEValCutOff, sizeof(double));
/////	//dc.PushData(&d.m_bLCFilter, sizeof(bool));
/////	//dc.PushData(&d.m_bCompBasedAdj, sizeof(bool));
/////	//dc.PushData(&d.m_nMaxHits, sizeof(size_t));
/////	//dc.PushData(&d.m_fDataOpts, sizeof(Flags_t));
/////	return dc;
/////}
/////
/////CDataCache & operator >> (CDataCache &dc, TBlastParams& d)
/////{
/////    dc >> d.m_bUseLift >> d.m_bUseSuppression >> d.m_iSearchMode >> d.m_strDbPath
/////        >> d.m_strDbName >> d.m_dEValCutOff >> d.m_bLCFilter >> d.m_bCompBasedAdj
/////        >> d.m_nMaxHits >> d.m_fDataOpts;
/////	//dc.ReadData(&d.m_bUseLift, sizeof(bool));
/////	//dc.ReadData(&d.m_bUseSuppression, sizeof(bool));
/////	//dc.ReadData(&d.m_iSearchMode, sizeof(int));
/////	//dc.ReadString(d.m_strDbPath);
/////	//dc.ReadString(d.m_strDbName);
/////	//dc.ReadData(&d.m_dEValCutOff, sizeof(double));
/////	//dc.ReadData(&d.m_bLCFilter, sizeof(bool));
/////	//dc.ReadData(&d.m_bCompBasedAdj, sizeof(bool));
/////	//dc.ReadData(&d.m_nMaxHits, sizeof(size_t));
/////	//dc.ReadData(&d.m_fDataOpts, sizeof(Flags_t));
/////	return dc;
/////}
/////
/////CDataCache & operator << (CDataCache &dc, const TBlastProcessInfo& d)
/////{
/////    dc << d.m_strDartServer << d.m_strDartDb << d.m_strDartVer << d.m_strBlastProgram
/////        << d.m_strBlastService << d.m_strSearchCreator << d.m_blStatus
/////        << d.m_bProcessed;
/////    
/////    ArraySaveToCache(dc, d.m_vecStatusMsgs);
/////    
/////	//dc.PushString(d.m_strDartServer);
/////	//dc.PushString(d.m_strDartDb);
/////	//dc.PushString(d.m_strDartVer);
/////	//dc.PushString(d.m_strBlastProgram);
/////	//dc.PushString(d.m_strBlastService);
/////	//dc.PushString(d.m_strSearchCreator);
/////	//dc.PushData(&d.m_blStatus, sizeof(int));
/////    //dc.PushData(&d.m_bProcessed, sizeof(bool));
/////	//size_t cnt = d.m_vecStatusMsgs.size();
/////	//dc.PushData(&cnt, sizeof(size_t));
/////	//for (size_t i = 0; i < cnt; ++i)
/////	//	dc.PushString(d.m_vecStatusMsgs[i]);
/////	
/////	return dc;
/////}
/////
/////CDataCache & operator >> (CDataCache &dc, TBlastProcessInfo& d)
/////{
/////    dc >> d.m_strDartServer >> d.m_strDartDb >> d.m_strDartVer >> d.m_strBlastProgram
/////        >> d.m_strBlastService >> d.m_strSearchCreator >> d.m_blStatus
/////        >> d.m_bProcessed;
/////    
/////    ArrayReadFromCache(dc, d.m_vecStatusMsgs);
/////    
/////	//dc.ReadString(d.m_strDartServer);
/////	//dc.ReadString(d.m_strDartDb);
/////	//dc.ReadString(d.m_strDartVer);
/////	//dc.ReadString(d.m_strBlastProgram);
/////	//dc.ReadString(d.m_strBlastService);
/////	//dc.ReadString(d.m_strSearchCreator);
/////	//dc.ReadData(&d.m_blStatus, sizeof(int));
/////	//dc.ReadData(&d.m_bProcessed, sizeof(bool));
/////	//d.m_vecStatusMsgs.clear();
/////	//size_t cnt = 0;
/////	//dc.ReadData(&cnt, sizeof(size_t));
/////	//if (cnt > 0)
/////	//{
/////	//	d.m_vecStatusMsgs.insert(d.m_vecStatusMsgs.end(), cnt, k_strEmptyString);
/////	//	for (size_t i = 0; i < cnt; ++i)
/////	//		dc.ReadString(d.m_vecStatusMsgs[i]);
/////	//}
/////	
/////	
/////	return dc;
/////}










