## Subfamily Protein Architecture Labeling Engine Utility - Source Package

##### (revised 19 September 2024)


### Background

This is the source code package for the *Subfamily Protein Architecture Labeling Engine (SPARCLE)* command line utility, for users who prefer to build the programs on their own computers. For instruction on how to use this program, please download the binary package [here](https://ftp.ncbi.nih.gov/pub/mmdb/cdd/SparcleLabel/current).

### Download the source package

`sparclbl` utility must work with `rpsblast` and requires the NCBI C++ core toolkit to build, just like `rpsblast` from BLAST team. The BLAST team provided an optimized version of the toolkit to support their set of BLAST programs, so we can just download their source package and add the `sparclbl` project in so it is built along with all BLAST programs.<br /><br />

1. Download SparcleLabel source package

    Download the SparcleLabel source package [here](https://ftp.ncbi.nih.gov/pub/mmdb/cdd/SparcleLabel/current/SparcleLabel-src.tar.gz)  and untar it (Since you are reading this file, you probably have already done so):
    ```
    $ wget https://ftp.ncbi.nih.gov/pub/mmdb/cdd/SparcleLabel/current/SparcleLabel-src.tar.gz
    $ tar xzf SparcleLabel-src.tar.gz
    $ tree
    .
    |-- HOWTO.build.md
    |-- src
    |   |-- ClusterAssignment.def
    |   |-- ClusterAssignment.dtd
    |   |-- ClusterAssignment.module
    |   |-- Makefile.ClusterAssignment.lib
    |   .............
    |   |-- Makefile.sparclbl.app
    |   |-- common
    |   |   ... ... ...
    |   |-- externals.txt
    |   `-- sparclbl_main.cpp
    `-- utils
        |-- embedsrc.sh
        `-- getblsrc.sh
    ```

2. Download the latest BLAST source package

Next we need to download the blast source package. On linux platform, it can be automatically done by running the provided script

```utils/getblsrc.sh```

Under the hood, it does the following:
1. Identify the latest version of BLAST. As of present, the lastest version is 2.16.0
2. Download the source code and decompress:
    ```
    $ wget https://ftp.ncbi.nih.gov/blast/executables/LATEST/ncbi-blast-2.16.0+-src.tar.gz && tar -xzf ncbi-blast-2.16.0+-src.tar.gz && rm -f ncbi-blast-2.16.0+-src.tar.gz
    $ tree
    .
    |-- HOWTO.build.md
    |-- ncbi-blast-2.16.0+-src
    |   `-- c++
    |       |-- compilers
    |       |   .........
    |       |-- configure
    |       |-- configure.orig
    |       |-- includell
    |       |   .........
    |       |-- scripts
    |       |   .........
    |       `-- src
    |           |-- CMakeLists.txt
    |           |-- Makefile.in
    |           |-- algo
    |           |   .........
    |           |-- app
    .................
    |-- src
    |   |-- ClusterAssignment.def
    |   |-- ClusterAssignment.dtd
    .................
    `-- utils
        |-- embedsrc.sh
        `-- getblsrc.sh


    ```

Next we need to embed our source code to the BLAST source tree. Again, this can be easily done by running the following script:

```utils/embedsrc.sh -b ncbi-blast-2.16.0+-src```

it does the following:
 
    1. Create a subdirectory `SparcleLabel` under `ncbi-blast-2.16.0+-src/c++/src/app` and copy all files and subdirectories in`src` directory into it:
        ```
        $ mkdir "ncbi-blast-2.16.0+-src/c++/src/app/SparcleLabel"
		$ cp -r src/* ncbi-blast-2.16.0+-src/c++/src/app/SparcleLabel/
        ```
    2. Edit ncbi-blast-2.16.0+-src/c++/src/app/Makefile.in to append `SparcleLabel` (case sensitive, must match the name of the directory you just created) to the "SUB_PROJ" line:
		```
        $ vi ncbi-blast-2.9.0+-src/c++/src/app/Makefile.in
        ```
        
Now the source code is ready to be built.
    
### Build the programs

On Linux system, just run the following commands:

```
$ cd ncbi-blast-2.16.0+-src/c++
$ ./configure
$ make -k -j10
```

It may take a while for the builder to finish. If successful, all built binaries are under

```
ncbi-blast-2.16.0+-src/c++/ReleaseMT/bin
```

If build on Windows system, we recommend to use VS2015 or later.<br /><br />

1. Launch VS and open the following solution:

    ```
    ncbi-blast-2.16.0+-src\c++\compilers\vs2015\static\build\ncbi_cpp.sln
    ```
    
2. Select the solution configuration `ReleaseDLL` and solution platform `x64`
3. Build the `_CONFIGURE_` project.<br /><br />
    *** Note: Visual Studio will prompt to reload solutions as it has been changed, but please leave the prompt window open and wait until the project is completely built *** <br /><br />
    
    After the build is complete, new projects are created. Click the "Reload All" button on the prompt window to reload all projects. It may take several minutes to complete.
4. After all projects are loaded, build the `_BUILD_ALL_` project. It may take some time to complete.
	
5. If successful, all built binaries should be under 
    ```
    ncbi-blast-2.16.0+-src\c++\compilers\vs2015\static\bin\ReleaseMT
    ```
    