template<typename TSequenceDerived>
void ParseBlastQuery(const ncbi::objects::CBlast4_queries &bq, std::vector<TSequenceDerived> &dst)
{
    dst.clear();
    switch (bq.Which())
    {
        case ncbi::objects::CBlast4_queries::e_not_set:
			return;
        case ncbi::objects::CBlast4_queries::e_Pssm:
		{
            // -- # of query is 1
			const ncbi::objects::CPssm& rPssm = bq.GetPssm().GetPssm();
			if (rPssm.IsSetQuery() && rPssm.CanGetQuery())
			{
				const ncbi::objects::CSeq_entry& rSeqEntry = rPssm.GetQuery();
				if (rSeqEntry.IsSeq())	//must?
				{
					dst.emplace_back();
					TSequenceDerived & rSeq = dst.back();
					//rSeq.m_iGenCode = iGeneticCode;
					const ncbi::objects::CBioseq & rQueryBioseq = rSeqEntry.GetSeq();

					FillSequenceFromBioseq(rQueryBioseq, rSeq);
					
				}
				else if (rSeqEntry.IsSet())	//set
				{
					ParseSequencesFromSeqSet(rSeqEntry.GetSet(), dst);
				}
			}
			return;
        }
        case ncbi::objects::CBlast4_queries::e_Seq_loc_list:
		{
            // -- in seqloc case, the sequence is only identified by an ID. 
            // -- The ID will be converted to string in m_strNcbiId. 
            // -- TSequence will remain invalid. caller must retrieve seqinfo
            // -- from other sources.
            const std::list< ncbi::CRef< ncbi::objects::CSeq_loc > > rEntries = bq.GetSeq_loc_list();
            for (std::list< ncbi::CRef< ncbi::objects::CSeq_loc > > :: const_iterator iterSeqLoc = rEntries.begin(); iterSeqLoc != rEntries.end(); ++iterSeqLoc)
            {
                const ncbi::objects::CSeq_id* pSeqId = (*iterSeqLoc)->GetId();
                if (nullptr != pSeqId)
                {
                    dst.emplace_back();
                    TSequenceDerived & rSeq = dst.back();
                    pSeqId->GetLabel(&rSeq.m_strNcbiId, ncbi::objects::CSeq_id::eBoth);
                    switch ((*iterSeqLoc)->Which())
                    {
                    case ncbi::objects::CSeq_loc::e_Int:
						{
							const ncbi::objects::CSeq_interval &rInt = (*iterSeqLoc)->GetInt();
							rSeq.m_iFrom = (SeqPos_t)rInt.GetFrom();
							rSeq.m_iTo = (SeqPos_t)rInt.GetTo();
						}
						break;
					default:;
                    }
                }
            }
            break;
        }
        case ncbi::objects::CBlast4_queries::e_Bioseq_set:
        {
            ParseSequencesFromSeqSet(bq.GetBioseq_set(), dst);
            break;
        }
        
        
    }
}
