INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 1,'embl_acc','European Nucleotide Archive (was EMBL) accession','ENA');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 2,'status','Status',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 3,'synonym','Synonym',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 4,'name','Name','Alternative/long name');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 5,'type','Type of feature',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 6,'toplevel','Top Level','Top Level Non-Redundant Sequence Region');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 7,'GeneCount','Gene Count','Total Number of Genes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 10,'SNPCount','Short Variants','Total Number of SNPs');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 11,'codon_table','Codon Table','Alternate codon table');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 12,'_selenocysteine','Selenocysteine',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 13,'bacend','bacend',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 14,'htg','htg','High Throughput phase attribute');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 15,'miRNA','Micro RNA','Coordinates of the mature miRNA');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 16,'non_ref','Non Reference','Non Reference Sequence Region');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 17,'sanger_project','Sanger Project name',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 18,'clone_name','Clone name',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 19,'fish','FISH location',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 21,'org','Sequencing centre',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 22,'method','Method',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 23,'superctg','Super contig id',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 24,'inner_start','Max start value',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 25,'inner_end','Min end value',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 26,'state','Current state of clone',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 27,'organisation','Organisation sequencing clone',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 28,'seq_len','Accession length',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 29,'fp_size','FP size',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 30,'BACend_flag','BAC end flags',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 31,'fpc_clone_id','fpc clone',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 32,'KnwnPCCount','protein_coding_KNOWN','Number of Known Protein Coding');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 33,'NovPCCount','protein_coding_NOVEL','Number of Novel Protein Coding');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 36,'PredPCCount','protein_coding_PREDICTED','Number of Predicted Protein Coding');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 37,'IGGeneCount','IG_gene','Number of IG Genes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 38,'IGPsGenCount','IG_pseudogene','Number of IG Pseudogenes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 39,'TotPsCount','total_pseudogene','Total Number of Pseudogenes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 42,'KnwnPCProgCount','protein_coding_in_progress_KNOWN','Number of Known Protein Coding in progress');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 43,'NovPCProgCount','protein_coding_in_progress_NOVEL','Number of Novel Protein Coding in progress');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 44,'AnnotSeqLength','Annotated sequence length','Annotated Sequence');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 45,'TotCloneNum','Total number of clones','Total Number of Clones');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 46,'NumAnnotClone','Fully annotated clones','Number of Fully Annotated Clones');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 47,'ack','Acknowledgement','Acknowledgement for manual annotation');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 48,'htg_phase','High throughput phase','High throughput genomic sequencing phase');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 49,'description','Description','A general descriptive text attribute');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 50,'chromosome','Chromosome','Chromosomal location for supercontigs that are not assembled');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 51,'nonsense','Nonsense Mutation','Strain specific nonesense mutation');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 52,'author','Author','Group resonsible for Vega annotation');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 53,'author_email','Author email address','Author email address');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 54,'remark','Remark','Annotation remark');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 55,'transcr_class','Transcript class','Transcript class');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 57,'ccds','CCDS','CCDS identifier');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 58,'CCDS_PublicNote','CCDS Public Note','Public Note for CCDS identifier, provided by http://www.ncbi.nlm.nih.gov/CCDS');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 59,'Frameshift','Frameshift','Frameshift modelled as intron');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 62,'ncRNA','Structure','RNA secondary structure line');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 63,'skip_clone','skip clone  Skip clone in align_by_clone_identity.pl',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 64,'coding_cnt','Coding genes','Number of protein coding Genes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 67,'pseudogene_cnt','Pseudogenes','Number of pseudogenes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 80,'supercontig','SuperContig name',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 81,'well_name','Well plate name',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 82,'bacterial','Bacterial',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 90,'bacend_well_nam','BACend well name',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 91,'alt_well_name','Alt well name',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 92,'TranscriptEdge','Transcript Edge',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 93,'alt_embl_acc','Alt European Nucleotide Archive (was EMBL) acc',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 94,'alt_org','Alt org',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 95,'intl_clone_name','International Clone Name',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 96,'embl_version','European Nucleotide Archive (was EMBL) Version',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 97,'chr','Chromosome Name','Chromosome Name Contained in the Assembly');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 98,'equiv_asm','Equivalent EnsEMBL assembly','For full chromosomes made from NCBI AGPs');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 109,'HitSimilarity','hit similarity','percentage id to parent transcripts');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 110,'HitCoverage','hit coverage','coverage of parent transcripts');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 111,'PropNonGap','proportion non gap','proportion non gap');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 112,'NumStops','number of stops',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 113,'GapExons','gap exons','number of gap exons');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 114,'SourceTran','source transcript','source transcript');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 115,'EndNotFound','end not found','end not found');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 116,'StartNotFound','start not found','start not found');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 117,'Frameshift Fra','Frameshift modelled as intron',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 118,'ensembl_name','Ensembl name','Name of equivalent Ensembl chromosome');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 119,'NoAnnotation','NoAnnotation','Clones without manual annotation');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 120,'hap_contig','Haplotype contig','Contig present on a haplotype');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 121,'annotated','Clone Annotation Status',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 122,'keyword','Clone Keyword',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 123,'hidden_remark','Hidden Remark',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 124,'mRNA_start_NF','mRNA start not found',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 125,'mRNA_end_NF','mRNA end not found',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 126,'cds_start_NF','CDS start not found',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 127,'cds_end_NF','CDS end not found',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 128,'write_access','Write access for Sequence Set','1 for writable , 0 for read-only');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 129,'hidden','Hidden Sequence Set',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 130,'vega_name','Vega name','Vega seq_region.name');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 131,'vega_export_mod','Export mode','E (External), I (Internal) etc');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 132,'vega_release','Vega release','Vega release number');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 133,'atag_CLE','Clone_left_end','Clone_lef_end feature marked in GAP database');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 134,'atag_CRE','Clone_right_end','Clone_right_end feature marked in GAP database');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 135,'atag_Misc','Misc','miscellaneous feature marked in GAP database');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 136,'atag_Unsure','Unsure','region of uncertain DNA sequence marked in GAP database');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 137,'MultAssem','Multiple Assembled seq region','Part of Seq Region is part of more than one assembly');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 140,'wgs','WGS contig','WGS contig integrated into the map');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 141,'bac','AGP clones','tiling path of clones');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 142,'GeneGC','Gene GC','Percentage GC content for this gene');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 143,'TotAssemblyLeng','Finished sequence length','Length of the assembly not counting sequence gaps');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 144,'amino_acid_sub','Amino acid substitution','Some translations have been manually curated for amino acid substitiutions. For example a stop codon may be changed to an amino acid in order to prevent premature truncation, or one amino acid can be substituted for another.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 145,'_rna_edit','rna_edit','RNA edit');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 146,'kill_reason','Kill Reason','Reason why a transcript has been killed');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 147,'strip_UTR','Strip UTR','Transcript needs bad UTR removing');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 148,'TotAssLength','Finished sequence length','Finished Sequence');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 149,'PsCount','pseudogene','Number of Pseudogenes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 152,'TotPTCount','total_processed_transcript','Total Number of Processed Transcripts');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 153,'TotPCCount','total_protein_coding','Total Number of Protein Coding');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 156,'PolyPsCount','polymorphic_pseudogene','Number of Polymorphic Pseudogenes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 157,'TotIGGeneCount','total_IG_gene','Total Number of IG Genes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 158,'ProcPsCount','proc_pseudogene','Number of Processed Pseudogenes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 159,'UnPsCount','unproc_pseudogene','Number of Unprocessed Pseudogenes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 160,'TPsCount','transcribed_pseudogene','Number of Transcribed Pseudogenes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 161,'TECCount','TEC','Number of TEC Genes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 164,'IsoPoint','Isoelectric point','Pepstats attributes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 165,'Charge','Charge','Pepstats attributes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 166,'MolecularWeight','Molecular weight','Pepstats attributes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 167,'NumResidues','Number of residues','Pepstats attributes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 168,'AvgResWeight','Ave. residue weight','Pepstats attributes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 170,'initial_met','Initial methionine','Set first amino acid to methionine');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 171,'NonGapHCov','NonGapHCov',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 172,'otter_support','otter support','Evidence ID that was used as supporting feature for building a gene in Vega');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 173,'enst_link','enst link','Code to link a OTTT with an ENST when they both share the CDS of ENST');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 174,'upstream_ATG','upstream ATG','Alternative ATG found upstream of the defined as start ATG for the transcript');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 175,'TPPsCount','transcribed_processed_pseudogene','Number of Transcribed Processed Pseudogenes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 176,'TUPsCount','transcribed_unprocessed_pseudogene','Number of Transcribed Unprocessed Pseudogenes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 177,'UniPsCount','unitary_pseudogene','Number of Unitary Pseudogenes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 180,'TUyPsCount','transcribed_unitary_pseudogene','Number of Transcribed Unitary Pseudogenes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 181,'PolyCount','polymorphic','Number of Polymorphic Genes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 184,'TRGeneCount','TR_gene','Number of TR Genes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 185,'TRPsCount','TR_pseudo','Number of TR Pseudogenes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 186,'tp_ott_support','otter protein transcript support','Evidence ID that was used as supporting feature for building a gene in Vega');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 187,'td_ott_support','otter dna transcript support','Evidence ID that was used as supporting feature for building a gene in Vega');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 188,'ep_ott_support','otter protein exon support','Evidence ID that was used as supporting feature for building a gene in Vega');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 189,'ed_ott_support','otter dna exon support','Evidence ID that was used as supporting feature for building a gene in Vega');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 191,'StopGained','SNP causes stop codon to be gained','This transcript has a variant that causes a stop codon to be gained in at least 10 percent of a HapMap population');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 192,'StopLost','SNP causes stop codon to be lost','This transcript has a variant that causes a stop codon to be lost in at least 10 percent of a HapMap population');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 198,'lost_frameshift','lost_frameshift','Frameshift on the query sequence is lost in the target sequence');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 199,'AltThreePrime','Alternate three prime end','The position of other possible three prime ends for the transcript');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 216,'GeneInLRG','Gene in LRG','This gene is contained within an LRG region');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 217,'GeneOverlapLRG','Gene overlaps LRG','This gene is partially overlapped by a LRG region (start or end outside LRG)');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 218,'readthrough_tra','readthrough transcript','Havana readthrough transcripts');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 300,'CNE','Constitutive exon','An exon that is always included in the mature mRNA, even in different mRNA isoforms');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 301,'CE','Cassette exon','One exon is spliced out of the primary transcript together with its flanking introns');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 302,'IR','Intron retention','A sequence is spliced out as an intron or remains in the mature mRNA transcript');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 303,'MXE','Mutually exclusive exons','In the simpliest case, one or two consecutive exons are retained but not both');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 304,'A3SS','Alternative 3\' sites','Two or more splice sites are recognized at the 5\' end of an exon. An alternative 3\' splice junction (acceptor site) is used, changing the 5\' boundary of the downstream exon');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 305,'A5SS','Alternative 5\' sites','Two or more splice sites are recognized at the 3\' end of an exon. An alternative 5\' splice junction (donor site) is used, changing the 3\' boundary of the upstream exon');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 306,'AFE','Alternative first exon','The second exons of each variant have identical boundaries, but the first exons do not overlap');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 307,'ALE','Alternative last exon','Penultimate exons of each splice variant have identical boundaries, but the last exons do not overlap');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 308,'II','Intron isoform','Alternative donor or acceptor splice sites lead to truncation or extension of introns, respectively');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 309,'EI','Exon isoform','Alternative donor or acceptor splice sites leads to truncation or extension of exons, respectively');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 310,'AI','Alternative initiation','Alternative choice of promoters');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 311,'AT','Alternative termination','Alternative choice of polyadenylation sites');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 312,'patch_fix','Assembly Patch Fix','Assembly patch that will, in the next assembly release, replace the corresponding sequence found in the current assembly');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 313,'patch_novel','Assembly Patch Novel','Assembly patch that will, in the next assembly release, be retained as an alternate non-reference sequence in a similar way to haplotypes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 314,'LRG','Locus Reference Genomic','Locus Reference Genomic sequence');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 315,'NoEvidence','Evidence for transcript removed','Supporting evidence for this projected transcript has been removed');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 316,'circular_seq','Circular sequence','Circular chromosome or plasmid molecule');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 317,'external_db','External database','External database to which seq_region name may be linked');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 318,'split_tscript','split_tscript','split_tscript');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 319,'Threep','Three prime end','Alternate three prime end');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 320,'gene_cluster','Gene cluster','Havana annotated gene cluster');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 328,'_rib_frameshift','Ribosomal Frameshift','Position and magnitude of frameshift');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 345,'vega_ref_chrom','Vega reference chromosome','Haplotypes reference a regular chromosome (indicated in the value of the attribute)');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 346,'PutPCCount','protein_coding_PUTATIVE','Number of Putative Protein Coding');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 347,'proj_alt_seq','Projection altered sequence','Projected sequence differs from original');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 348,'hav_gene_type','Havana gene biotype','Gene biotype assigned by Havana');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 353,'noncoding_cnt','Non coding genes','Number of non coding genes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 358,'PHIbase_mutant','PHI-base mutant','PHI-base phenotype of the mutants');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 360,'ncrna_host','ncrna_host','Havana ncrna_host gene');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 361,'peptide-class','Peptide classification','The classification of the gene or transcript based on alignment to NR (values: TE WH NH)');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 362,'working-set','Working Gene Set','High-confidence set of genes, composed of evidence-based genes and non-overlapping protein-coding ab initio gene models');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 363,'filtered-set','Filtered Gene Set v1','Working genes that are screened for TE content and orthology with sorghum and rice');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 364,'super-set','Super Working Gene Set','Set of all working gene set loci from both Builds 4a and 5a');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 365,'projected4a2','Projected by alignment','Temporary (Monday, August 23, 2010)');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 366,'merged','Merged species',NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 367,'karyotype_rank','Rank in the karyotype','For a given seq_region, if it is part of the species karyotype, will indicate its rank');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 368,'noncoding_acnt','Non coding genes','Number of non coding genes on alternate sequences');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 369,'coding_acnt','Coding genes','Number of protein coding genes on alternate sequences');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 370,'pseudogene_acnt','Pseudogenes','Number of pseudogenes on alternate sequences');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 371,'clone_end','Clone end','Side of the contig on which a vector lies (enum:RIGHT, LEFT)');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 372,'contig_scaffold','Contig Scaffold','Scaffold that contains mutually ordered contigs');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 373,'current_version','Current Accession Version','Identifies the most recent version of an accession');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 374,'seq_status','Sequence Status','Sequence status.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 375,'clone_vector','Vector sequence','A clone-end vector associated with a contig (enum:SP6, T7).');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 376,'creation_date','Creation date','Creation date of annotation');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 377,'update_date','Update date','Last update date of annotation');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 378,'seq_date','Sequence date','Sequence date');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 379,'has_stop_codon','Contains stop codon','Translation attribute');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 380,'havana_cv','Havana CV term','Controlled vocabulary terms from Havana');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 381,'TlPPsCount','translated_processed_pseudogene','Number of Translated Processed Pseudogenes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 382,'NoTransRefError','No translations due to reference error','This gene is believed to include protein coding transcripts, but no transcript has a translation due to a reference assembly error making specifying the translation impossible.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 383,'parent_exon_key','parent_exon_key','The exon key to identify a projected transcript\'s parent transcript.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 386,'parent_sid','parent_sid','The parent stable ID to identify a projected transcript\'s parent transcript. For internal statistics use only since this method does not work in all cases.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 387,'noncoding_acnt_s','Small non coding genes','Number of small non coding genes on alternate sequences');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 388,'noncoding_acnt_m','Misc non coding genes','Number of unclassified (miscellaneous) non coding genes on alternate sequences');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 389,'noncoding_cnt_s','Small non coding genes','Number of small non coding genes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 390,'noncoding_cnt_l','Long non coding genes','Number of long non coding genes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 391,'TlUPsCount','translated_unprocessed_pseudogene','Number of Translated Unprocessed Pseudogenes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 393,'AFFYMETRIXCount','AFFYMETRIX Count','Total Number of AFFYMETRIX features');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 394,'RFLPCount','RFLP Count','Total Number of RFLP features');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 395,'xref_id','Xref ID','ID of associated database reference');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 396,'vega_chr_type','Vega chrom type','Type of chromosome - haplotype, other, etc');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 398,'genscan','Genscan gene predictions','Number of prediction genes generated by Genscan');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 399,'gsc','GSC gene prediction','Number of prediction genes generated by gsc');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 400,'snap','Snap gene prediction','Number of prediction genes generated by Snap');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 401,'fgenesh','FGENESH gene prediction','Number of prediction genes generated by FGENESH');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 402,'genefinder','Genefinder gene prediction','Number of prediction genes generated by Genefinder');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 403,'transcript_cnt','Gene transcripts','Number of transcripts');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 404,'transcript_acnt','Gene transcripts','Number of transcripts on the alternate sequences');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 405,'ref_length','Golden Path Length','Length of the primary assembly');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 406,'total_length','Base Pairs','Total length of the assembly');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 407,'refseq_compare','refseq_compare','This attribute can be applied to both gene and transcript. It is supposed to give an indication of whether the annotation in the ensembl database is matched by annotation that we have imported from refseq. At the gene level, the match is unlikely to be an exact match because all or some of the transcripts may differ. Also, the biotype e.g. coding potential may differ. therefore, matching is a bit fuzzy and is done primarily on genomic location and then also takes gene length and gene name into consideration.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 408,'coding_rcnt','Readthrough coding genes','Number of readthrough coding genes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 409,'coding_racnt','Readthrough coding genes','Number of readthrough coding genes on alternate sequences');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 410,'noncoding_racnt_l','Readthrough long non coding genes','Number of readthrough long non coding genes on alternate sequences');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 411,'noncoding_racnt_s','Readthrough small non coding genes','Number of readthrough small non coding genes on alternate sequences');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 412,'noncoding_rcnt_s','Readthrough small non coding genes','Number of readthrough small non coding genes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 413,'noncoding_rcnt_l','Readthrough long non coding genes','Number of readthrough long non coding genes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 414,'pseudogene_rcnt','Readthrough pseudogenes','Number of readthrough pseudogenes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 415,'pseudogene_racnt','Readthrough pseudogenes','Number of readthrough pseudogenes on alternate sequences');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 416,'gencode_level','GENCODE annotation level','level 1 (verified loci), level 2 (manually annotated loci), level 3 (automatically annotated loci)');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 417,'gencode_basic','GENCODE basic annotation','GENCODE Basic is a view provided by UCSC for users. It includes a subset of the GENCODE transcripts. In general, for protein coding genes it will show only the full length models (unless a protein coding gene has no full-length models, in which case other rules apply). For noncoding genes, it will also only show the full-length (mRNA start and end found) models (unless there are no full-length models, in which case other rules apply).');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 418,'struct_var','Structural variants','Total Number of structural variants');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 419,'genblast','GenBlastG gene predictions','Number of prediction genes generated by GenBlastG');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 420,'syn_gene_pairs','Syntenic gene pairs','Syntenic gene relationship from Gramene pipeline');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 421,'vectorbase_maker_pre','VectorBase gene predictions','Number of prediction genes generated with MAKER, by VectorBase.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 422,'trnascan','tRNAscan-SE predictions','Number of predicted tRNA genes generated by tRNAscan-SE');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 423,'tgac_pred_supp7','T. turgidum RNA-seq alignments','Number of T. turgidum RNA-seq alignments from Krasileva et al.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 424,'tgac_pred_supp17','T. aestivum RNA-seq alignments','Number of T. aestivum RNA-seq alignments from Krasileva et al.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 425,'genome_component','Genome Component Name','For polyploid genome, the genome component name the seq_region belongs to');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 426,'transcript_whl','RNA-seq transcripts','RNA-seq transcripts from EchinoBase');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 427,'appris','APPRIS','APPRIS is a system that deploys a range of computational methods to provide value to the annotations of the human genome. APPRIS also selects one of the CDS for each gene as the principal isoform. APPRIS defines the principal variant by combining protein structural and functional information and information from the conservation of related species. principal1 - APPRIS principal isoform. principal2 - APPRIS candidate isoform (CCDS). principal3 - APPRIS candidate isoform (earliest CCDS). principal4 - APPRIS candidate isoform (longest CCDS). principal5 - APPRIS candidate isoform (longest coding sequence). alternative1 - APPRIS candidate isoform that is conserved in at least three tested species. alternative2 - APPRIS candidate isoform that appears to be conserved in fewer than three tested species');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 428,'TSL','Transcript Support Level','Transcription Support Level (TSL) is a method to highlight the well-supported and poorly-supported transcript models for users. The method relies on the primary data that can support full-length transcript structure and data are provided by UCSC.  The following categories are assigned to each of the evaluated annotations. tsl1 - all splice junctions of the transcript are supported by at least one non-suspect mRNA. tsl2 - the best supporting mRNA is flagged as suspect or the support is from multiple ESTs. tsl3 - the only support is from a single EST. tsl4 - the best supporting EST is flagged as suspect. tsl5 - no single transcript supports the model structure. tslNA - the transcript was not analyzed for one of the following reasons: pseudogene annotation, including transcribed pseudogenes.Human leukocyte antigen (HLA) transcript. Immunoglobin gene transcript.  T-cell receptor transcript. Single-exon transcript (will be included in a future version)');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 429,'protein_coverage','Protein Coverage','Protein coverage for this gene derived from geneTree in compara');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 430,'consensus_coverage','Consensus Coverage','Consensus coverage for this gene derived from geneTree in compara');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 431,'has_start_codon','Contains start codon','Translation attribute');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 437,'lncRNACount','lncRNA_Count','Number of lncRNAs');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 438,'ncRNACount','ncRNA_Count','Number of ncRNAs');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 439,'UnclassPTCount','UnclassPT_Count','Number of Unclassified Processed Transcripts');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 444,'noncoding_cnt_m','Misc non coding genes','Number of unclassified (miscellaneous) non coding genes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 445,'noncoding_rcnt_m','Readthrough misc non coding genes','Number of readthrough unclassified (miscellaneous) non coding genes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 446,'noncoding_racnt_m','Readthrough misc non coding genes','Number of readthrough unclassified (miscellaneous) non coding genes on alternate sequences');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 447,'noncoding_acnt_l','Long non coding genes','Number of long non coding genes on alternate sequences');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 448,'noncoding_racnt','Readthrough non coding genes','Number of readthrough non coding genes on alternate sequences');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 449,'noncoding_rcnt','Readthrough non coding genes','Number of readthrough non coding genes');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 450,'rseq_mrna_match','RefSeq model genomic seq to mRNA match','This is a transcript attribute that signifies an exact match between the underlying genomic sequence of the RefSeq transcript with the corresponding RefSeq mRNA sequence the model was built from (based on a match between the transcript stable id and an accession in the RefSeq mRNA file). An exact match occurs when the underlying genomic sequence of the model can be perfectly aligned to the mRNA sequence post polyA clipping.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 451,'rseq_mrna_nonmatch','RefSeq model genomic seq to mRNA non-match','This is a transcript attribute that signifies a non-match between the underlying genomic sequence of the RefSeq transcript with the corresponding RefSeq mRNA sequence the model was built from. A non-match is deemed to have occurred if the underlying genomic sequence does not have a perfect alignment to the mRNA sequence post polyA clipping. It can also signify that no comparison was possible as the model stable id may not have had a corresponding entry in the RefSeq mRNA file (sometimes happens when accessions are retired or changed). When a non-match occurs one or several of the following transcript attributes will also be present to provide more detail on the nature of the non-match: rseq_5p_mismatch, rseq_cds_mismatch, rseq_3p_mismatch, rseq_nctran_mismatch, rseq_no_comparison');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 452,'rseq_5p_mismatch','RefSeq model genomic seq (5\' UTR) to mRNA mismatch','This is a transcript attribute that signifies a mismatch between the underlying genomic sequence of the RefSeq transcript with the corresponding RefSeq mRNA sequence the model was built from. Specifically, there is a mismatch in the 5\' UTR of the RefSeq model. Information about the mismatch can be found in the value field of the transcript attribute.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 453,'rseq_cds_mismatch','RefSeq model genomic seq (CDS) to mRNA mismatch','This is a transcript attribute that signifies a mismatch between the underlying genomic sequence of the RefSeq transcript with the corresponding RefSeq mRNA sequence the model was built from. Specifically, there is a mismatch in the CDS of the RefSeq model. Information about the mismatch can be found in the value field of the transcript attribute.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 454,'rseq_3p_mismatch','RefSeq model genomic seq (3\' UTR) to mRNA mismatch','This is a transcript attribute that signifies a mismatch between the underlying genomic sequence of the RefSeq transcript with the corresponding RefSeq mRNA sequence the model was built from. Specifically, there is a mismatch in the 3\' UTR of the RefSeq model. Information about the mismatch can be found in the value field of the transcript attribute.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 455,'rseq_nctran_mismatch','RefSeq model genomic seq (non-coding) to mRNA mismatch','This is a transcript attribute that signifies a mismatch between the underlying genomic sequence of the RefSeq transcript with the corresponding RefSeq mRNA sequence the model was built from. This is a comparison between the entire underlying genomic sequence of the RefSeq model to the mRNA in the case of RefSeq models that are non-coding. Information about the mismatch can be found in the value field of the transcript attribute.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 456,'rseq_no_comparison','RefSeq model no comparison made to mRNA','This is a transcript attribute that signifies that no alignment was carried out between the underlying genomic sequence of RefSeq model and a corresponding RefSeq mRNA. The reason for this is generally that no corresponding, unversioned accession was found in the RefSeq mRNA file for the transcript stable id. This sometimes happens when accessions are retired or replaced. A second possibility is that the sequences were too long and problematic to align (though this is rare). The value field gives more information about the reason no comparison was possible.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 457,'rseq_ens_match_wt','RefSeq model to overlapping Ensembl model whole transcript match','This is a transcript attribute that signifies that for the RefSeq transcript there is an overlapping Ensembl model that is identical across the whole transcript. A whole transcript match is defined as follows: 1) In the case that both models are coding, the transcript, CDS and peptide sequences are all identical and the genomic coordinates of every exon match. 2) In the case that both transcripts are non-coding the transcript sequences and the genomic coordinates of every exon are identical. No comparison is made between a coding and a non-coding transcript. Useful related attributes are: rseq_ens_match_cds and rseq_ens_no_match.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 458,'rseq_ens_match_cds','RefSeq model to overlapping Ensembl model CDS match','This is a transcript attribute that signifies that for the RefSeq transcript there is an overlapping Ensembl model that is identical across the CDS region only. A CDS match is defined as follows: the CDS and peptide sequences are identical and the genomic coordinates of every translatable exon match. Useful related attributes are: rseq_ens_match_wt and rseq_ens_no_match.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 459,'rseq_ens_no_match','RefSeq model to overlapping Ensembl model no match','This is a transcript attribute that signifies that for the RefSeq transcript there is no overlapping Ensembl model that is identical across either the whole transcript or the CDS. This is caused by differences between the transcript, CDS or peptide sequences or between the exon genomic coordinates. Useful related attributes are: rseq_ens_match_wt and rseq_ens_match_cds.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 468,'ccds_transcript','CCDS transcript','This attribute signifies that a transcript has a matching CCDS transcript (the accession of which will be in the value column of the transcript_attrib entry). A match occurs when the genomic coordinates of all coding exons of the transcript are identical to the genomic coordinate of all coding exons in the overlapping CCDS model.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 469,'SO_accession','SO accession','Sequence Ontology accession');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 470,'SO_term','SO term','Sequence Ontology term');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 471,'display_term','display term','Ensembl display term');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 472,'NCBI_term','NCBI term','NCBI term');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 473,'feature_SO_term','feature SO term','Sequence Ontology term for the associated feature');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 474,'rank','rank','Relative severity of this variation consequence');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 475,'polyphen_prediction','polyphen prediction','PolyPhen-2 prediction');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 476,'sift_prediction','sift prediction','SIFT prediction');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 477,'short_name','Short name','A shorter name for an instance, e.g. a VariationSet');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 478,'dbsnp_clin_sig','dbSNP/ClinVar clinical significance','The clinical significance of a variant as reported by ClinVar and dbSNP');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 479,'dgva_clin_sig','DGVa clinical significance','The clinical significance of a structural variant as reported by DGVa');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 480,'clinvar_clin_sig','ClinVar clinical significance','The clinical significance of a variant as reported by ClinVar');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 481,'prot_func_analysis','Protein function analysis ','The program used to make protein function predictions');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 482,'associated_gene','Associated gene','ID of gene(s) linked by phenotype association');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 483,'risk_allele','Risk allele','Risk allele in phenotype association');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 484,'p_value','P-value','P-value denoting significance of an observed phenotype annotation');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 485,'variation_names','Variation names','Variant ID(s) linked with a phenotype association');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 486,'sample_id','Sample ID','Sample ID for source of phenotype association');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 487,'strain_id','Strain ID','Strain ID for source of phenotype association');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 488,'lod_score','LOD score','Log Of Odds score');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 489,'variance','Variance','Variance statistic');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 490,'inheritance_type','Inheritance type','Inheritance type of a trait');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 491,'external_id','External ID','External identifier for an entity');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 492,'odds_ratio','Odds ratio','Odds ratio used to denote significance of an observed phenotype annotation');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 493,'beta_coef','Beta coefficient','Beta coefficient (or standardized coefficient) used to denote significance of an observed phenotype annotation');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 494,'allele_symbol','Allele symbol','Allele symbol linked with phenotype association');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 495,'allele_accession_id','Allele accession ID','Allele accession ID linked with phenotype association');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 496,'marker_accession_id','Marker accession ID','Marker ID linked with phenotype association');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 497,'evidence','Variant evidence status','Evidence status for a variant');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 498,'review_status','ClinVar review_status','ClinVar review_status for assertation');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 499,'based_on','Evidence type used for protein impact prediction','Evidence type used for a PolyPhen protein impact prediction');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 500,'conservation_score','Sift conservation score','Median conservation va in an alignment used to make a Sift prediction');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 501,'sequence_number','Number of sequences in alignment','Number of protein sequences in the alignment use to make a protein impact prediction');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 502,'otter_truncated','Otter truncated feature','This feature extends beyond the slice, but has been trimmed. (For use in otter client-server communications.)');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 503,'trans_spliced','Trans-spliced transcript','A single RNA transcript derived from multiple precursor mRNAs.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 505,'genebuild_msu7_tes','TE-related Gene (MSU)','Number of TE-related genes predicted by <a href="http://rice.plantbiology.msu.edu">MSU</a> through a process of automatic and manual curation');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 506,'ibsc_low_confidence','PGSB low-confidence','Number of low-confidence genes annotated by the <A HREF="http://pgsb.helmholtz-muenchen.de/plant/barley/index.jsp">International Barley Sequencing Consortium</A>');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 507,'pubmed_id','PubMed ID','PubMed identifier');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 508,'var_att','variation_attrib','An attribute of a variation');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 509,'ontology_mapping','Ontology Mapping','Method used to link a description to an ontology term');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 510,'enst_refseq_compare','ENST/RefSeq sequence and structural comparisons','Each Ensembl transcript is compared to overlapping RefSeq transcripts. The comparison is only coding-coding or non-coding to non-coding. The calculations are as follows: Foreach Ensembl transcript:  Fetch overlapping RefSeq transcripts  Foreach RefSeq transcript:    1) Check if all exon coordinates match    2) Check if transcript sequences match    3) If both transcripts are protein coding:        a) Check if the CDS exon coordinates match        b) Check if the CDS sequences match        c) Check if the translation sequences match Checks 1 & 2 only are run on pairs of non-coding transcripts, while checks 1, 2, 3a, 3b and 3c are run for pairs of protein coding transcripts. For non-coding models: RefSeq transcript accessions passing checks 1 and 2 will get a line in the value column consisting of all such accessions (separated by ":") suffixed  by ":whole_transcript", to indicate these RefSeq accessions have a complete sequence and structural match across the entire transcript. Checks 3a, 3b and 3c are not considered as the transcripts are non-coding For coding models: RefSeq transcript accessions passing all five checks will get a line in the value column consisting of all such accessions (separated by ":") suffixed  by ":whole_transcript", to indicate these RefSeq accessions have a complete sequence and structural match across the entire transcript RefSeq transcript accessions passing tests 3a,3b and 3c (but not both test 1 & 2)  will get a line in the value column consisting of all such accessions (separated by ":") suffixed  by ":cds_only", to indicate these RefSeq accessions have a sequence and structural match across only the CDS region.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 511,'rna_gene_biotype','Biotype','Biotype of an RNA gene');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 512,'cmscan_truncated','Truncated','In a cmscan alignment, the end of the gene which is truncated');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 513,'cmscan_accuracy','Accuracy','The accuracy value in a cmscan alignment');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 514,'cmscan_bias','Bias','The bias value in a cmscan alignment');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 515,'cmscan_gc','GC','The GC value in a cmscan alignment');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 516,'cmscan_significant','Significant','The significant value in a cmscan alignment');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 517,'rfam_accession','Accession','Rfam accession');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 518,'broken_translation','broken translation','Transcript contains translation which contains stop codon.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 519,'proj_parent_t','projection parent transcript','Stable identifier of the parent transcript this transcript was projected from (projection between different species and/or assemblies).');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 520,'proj_parent_g','projection parent gene','Stable identifier of the parent gene this gene was projected from (projection between different species and/or assemblies).');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 521,'MIM','MIM id','MIM id');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 522,'vectorbase_adar','VectorBase gene predictions','Number of prediction genes generated with MAKER, by VectorBase.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 523, '_transl_start', 'Translation start', 'The start position for translation within a transcript-level seq_edit.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 524, '_transl_end', 'Translation end', 'The end position for translation within a transcript-level seq_edit.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 525, 'submitter', 'submitter', 'A group submitting data to a major repository eg. ClinVar');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 527, 'submitter_id','Submitter_ID','ID for data submitter');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 526, 'DateLastEvaluated','EvalDate','The most recent date on which evidence was evaluated and this conclusion drawn.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 528,'qtaro_category','Q-TARO Category','The phenotype "Category of Object Character" in the <a href="http://qtaro.abr.affrc.go.jp">Q-TARO (QTL Annotation Rice Online) database</a>');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 529,'qtaro_parent_a','Q-TARO Parent A','Parent A in the <a href="http://qtaro.abr.affrc.go.jp">Q-TARO (QTL Annotation Rice Online) database</a> QTL Information Table. ');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 530,'qtaro_parent_b','Q-TARO Parent B','Parent B in the <a href="http://qtaro.abr.affrc.go.jp">Q-TARO (QTL Annotation Rice Online) database</a> QTL Information Table. ');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 531,'cadd_pred','CADD prediction','CADD prediction');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 532,'dbnsfp_revel_pred','dbNSFP REVEL prediction','dbNSFP REVEL prediction');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 533,'dbnsfp_meta_lr_pred','dbNSFP MetaLR prediction','dbNSFP MetaLR prediction');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES ( 534,'dbnsfp_ma_pred','dbNSFP mutation assessor prediction','dbNSFP mutation assessor prediction');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES  (535, 'MANE_Select', 'MANE Select', 'The Matched Annotation from NCBI and EMBL-EBI is a collaboration between Ensembl/GENCODE and RefSeq. The MANE Select is a default transcript per human gene that is representative of biology, well-supported, expressed and highly-conserved. This transcript set matches GRCh38 and is 100% identical between RefSeq and Ensembl/GENCODE for 5\' UTR, CDS, splicing and 3\'UTR.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES  (536, 'Ensembl_Select', 'Ensembl Select', 'The Ensembl Select is a transcript identified by a pipeline that takes into account several criteria including transcript support (TSL), functional importance (APPRIS), representation in RefSeq and UniProt databases, length and coverage of pathogenic variants, where available.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES  (537, 'TAGENE_transcript', 'TAGENE pipeline transcript', 'Transcript created or extended using a model assembled from RNA-seq long reads using the TAGENE pipeline.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES  (538, 'legacy_biotype', 'Legacy biotype', 'Obsolete biotype previously assigned to this Ensembl object.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES  (539, 'KASP_markers', 'KASP_markers', 'KASP markers designed to be genome-specific with PolyMarker');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES  (540, 'mirna_arm', 'miRNA arm', 'Hairpin arm from which this miRNA has come from');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES  (541, '_stop_codon_rt', 'Stop Codon Readthrough', NULL);
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES  (542, 'citation_source', 'Citation source', 'Variant citation data source');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES  (544, 'phenotype_type', 'Phenotype type', 'Type of the phenotype information');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES  (545,'external_plant_links','external_plant_links','Links to external plant related sources');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES  (546,'coord_system_tag','coord_system_tag',"A way to store information about  seq_region\'s virtual coord_system names for single level assemblies. For example, we have an assembly with toplevel seq_regions (\"primary_assembly\") only, and we want to store the initial type of seq_regions like contig, scaffold, supercontig, chromosome, etc.");
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES  (547,'sequence_location','sequence_location',"To identify sequence locations / cellular compartments that DNA sequence comes from.Values are supposed to be SO compliant (children of the plastid_sequence SO:0000740 and nuclear_sequence SO:0000738 ): \"apicoplast_chromosome\", \"chloroplast_chromosome\", \"chromoplast_chromosome\", \"cyanelle_chromosome\", \"leucoplast_chromosome\", \"macronuclear_chromosome\", \"micronuclear_chromosome\", \"mitochondrial_chromosome\", \"nuclear_chromosome\".");
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES  (548,'BRC4_seq_region_name','BRC4_seq_region_name','seq_region name for the BRC4 project');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES  (549,'EBI_seq_region_name','EBI_seq_region_name','EBI seq_region name for the BRC4 project data roundtripping');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (550, 'MANE_Plus_Clinical', 'MANE Plus Clinical', 'Transcripts in the MANE Plus Clinical set are additional transcripts per locus necessary to support clinical variant reporting, for example transcripts containing known Pathogenic or Likely Pathogenic clinical variants not reportable using the MANE Select set. Note there may be additional clinically relevant transcripts in the wider RefSeq and Ensembl/GENCODE sets but not yet in MANE.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (551, 'maker_edit_dist', 'MAKER-P gene predictions', 'Annotation Edit Distance');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (552, 'maker_exon_edit_dist', 'MAKER-P gene predictions', 'Exon Annotation Edit Distance');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (553, 'maker_quality_index', 'MAKER-P gene predictions', 'Quality Index');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (554, 'is_canonical', 'Ensembl Canonical', 'This transcript is the chosen canonical for its gene. For protein-coding genes, this is the MANE_Select transcript if there is one. If not, the canonical transcript is chosen by a pipeline that takes into account several criteria including transcript support (TSL), functional importance (APPRIS), representation in RefSeq and UniProt databases, length and coverage of pathogenic variants, where available. For non protein-coding genes, it is usually the longest transcript with the same biotype as its parent gene.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (555, 'added_seq_accession', 'Added sequence accession', 'Source assembly accession INSDC ID (similar to assembly.accession meta_key) for the out of assembly seq_regions. Should be the proper INSDC assembly or  ENA, GenBank individual sequence ID. Used with the seq_regions coming from the additional assemblies (i.e. apicoplasts, mitochondria, etc). Mandatory for added sequences.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (556, 'added_seq_asm_pr_nam', 'Added sequence assembly provider name', 'Source assembly provider name for the out of assembly seq_regions (coming from the additional assemblies, i.e., apicoplasts, mitochondria, etc). Should have the corresponding added_seq_accession attrib for the same seq region. Mandatory for added sequences.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (557, 'added_seq_asm_pr_url', 'Added sequence assembly provider url', 'Source assembly provider url for the out of assembly seq_regions (coming from the additional assemblies, i.e., apicoplasts, mitochondria, etc). Should have the corresponding added_seq_accession attrib for the same seq region. Mandatory for added sequences.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (558, 'added_seq_ann_pr_nam', 'Added sequence annotation provider name', 'Source annotation provider name for the out of assembly seq_regions (coming from the additional assemblies, i.e., apicoplasts, mitochondria, etc). Should have the corresponding added_seq_accession attrib for the same seq region. Should be present if there are models on such seq_regions.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (559, 'added_seq_ann_pr_url', 'Added sequence annotation provider url', 'Source annotation provider url for the out of assembly seq_regions (coming from the additional assemblies, i.e., apicoplasts, mitochondria, etc). Should have the corresponding added_seq_accession attrib for the same seq region. Should be present if there are models on such seq_regions.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (560, 'artef_dupl', 'Artifactual duplication', 'Annotation on artifactual regions of the genome assembly');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (561, 'g2p_confidence', 'G2P confidence', 'G2P confidence category from the G2P panels');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (562, 'mutation_consequence', 'Mutation consequence', 'G2P mutation consequence');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (563, 'mutated_samples', 'Number mutated samples', 'Number of mutated samples from the Cancer Gene Census');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (564, 'samples_tested', 'Number samples tested', 'Number of samples tested from the Cancer Gene Census');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (565, 'samples_mutation', 'Number samples with mutation type', 'Number of samples with mutation type from the Cancer Gene Census');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (566, 'wb_auto_summary', 'WormBase-imported automated summary', 'WormBase automated summary text attribute');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (567, 'Ga4gh_id', 'Bacteria Sequence Checksum', 'Checksum generated sequence for all biological features Chromosomes, super contigs, cDNA, CDS, Peptides');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (568, 'md5_toplevel', 'Toplevel Sequence Checksum MD5', 'Toplevel genomic sequences checksum like chromosomes and supercontigs');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (569, 'sha512t24u_toplevel', 'Toplevel Sequence Checksum SHA512', 'Toplevel genomic sequences checksum like chromosomes and supercontigs');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (570, 'sha512t24u_cds', 'sha512 Checksum for cds sequences', 'sha512 Checksum for cds sequences');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (571, 'md5_cds', 'md5 Checksum for cds sequences', 'md5 Checksum for cds sequences');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (572, 'sha512t24u_cdna', 'sha512 Checksum for cdna sequences', 'sha512 Checksum for cdna sequences');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (573, 'md5_cdna', 'md5 Checksum for cdna sequences', 'md5 Checksum for cdna sequences');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (574, 'sha512t24u_pep', 'sha512 Checksum for translation sequences ', 'sha512 Checksum for translation sequences');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (575, 'md5_pep', 'md5 Checksum for translation sequences', 'md5 Checksum for translation sequences ');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (576, 'gencode_primary', 'GENCODE primary annotation', 'Gencode Primary replaces Gencode Basic for protein coding genes as the set of the most biologically relevant transcripts. Protein coding transcripts are compared to MANE Select or to Ensembl Canonical where MANE Select is not yet defined. The features (exons and introns) that are novel to the reference transcript are filtered and assessed for biological relevance using conservation and expression data. The transcripts having the filtered features are retained for the set. For noncoding genes, the Gencode Primary set is identical to the Gencode Basic set.');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (577, 'somatic_clin_sig', 'ClinVar somatic classification', 'The somatic classification of a variant as reported by ClinVar');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (578, 'oncogenic_clin_sig', 'ClinVar somatic classification of oncogenicity', 'The somatic classification of oncogenicity of a variant as reported by ClinVar');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (579, 'somatic_status', 'ClinVar somatic review_status', 'ClinVar review_status for assertation for somatic classification');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (580, 'oncogenic_status', 'ClinVar somatic oncogenicity review_status', 'ClinVar review_status for assertation for somatic classification of oncogenicity');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (581, 'somatic_date', 'Date last evaluated for ClinVar evidence', 'The most recent date on which evidence was evaluated and this conclusion drawn for ClinVar somatic classification');
INSERT IGNORE INTO attrib_type (attrib_type_id, code, name, description) VALUES (582, 'oncogenic_date', 'Date last evaluated for ClinVar evidence', 'The most recent date on which evidence was evaluated and this conclusion drawn for ClinVar somatic classification of oncogenicity');

INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (1, 469, 'SO:0001483');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (2, 470, 'SNV');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (3, 471, 'SNP');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (4, 469, 'SO:1000002');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (5, 470, 'substitution');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (6, 469, 'SO:0001019');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (7, 470, 'copy_number_variation');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (8, 471, 'CNV');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (9, 469, 'SO:0000667');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (10, 470, 'insertion');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (11, 469, 'SO:0000159');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (12, 470, 'deletion');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (13, 469, 'SO:1000032');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (14, 470, 'indel');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (15, 469, 'SO:0000705');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (16, 470, 'tandem_repeat');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (17, 469, 'SO:0001059');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (18, 470, 'sequence_alteration');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (19, 469, 'SO:0001628');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (20, 470, 'intergenic_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (21, 471, 'INTERGENIC');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (24, 471, 'UPSTREAM');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (27, 471, 'DOWNSTREAM');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (32, 469, 'SO:0001575');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (33, 470, 'splice_donor_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (34, 471, 'ESSENTIAL_SPLICE_SITE');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (36, 470, 'splice_acceptor_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (37, 469, 'SO:0001630');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (38, 470, 'splice_region_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (39, 471, 'SPLICE_SITE');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (40, 469, 'SO:0001627');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (41, 470, 'intron_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (42, 471, 'INTRONIC');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (43, 469, 'SO:0001623');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (44, 470, '5_prime_UTR_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (45, 471, '5PRIME_UTR');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (46, 469, 'SO:0001624');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (47, 470, '3_prime_UTR_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (48, 471, '3PRIME_UTR');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (54, 471, 'SYNONYMOUS_CODING');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (55, 469, 'SO:0001583');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (57, 471, 'NON_SYNONYMOUS_CODING');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (62, 469, 'SO:0001587');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (63, 470, 'stop_gained');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (64, 471, 'STOP_GAINED');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (65, 469, 'SO:0001578');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (66, 470, 'stop_lost');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (67, 471, 'STOP_LOST');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (68, 469, 'SO:0001567');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (69, 470, 'stop_retained_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (70, 469, 'SO:0002012');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (72, 469, 'SO:0001589');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (73, 470, 'frameshift_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (74, 471, 'FRAMESHIFT_CODING');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (75, 469, 'SO:0001626');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (76, 470, 'incomplete_terminal_codon_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (77, 471, 'PARTIAL_CODON');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (78, 469, 'SO:0001621');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (79, 470, 'NMD_transcript_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (80, 471, 'NMD_TRANSCRIPT');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (81, 469, 'SO:0001619');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (82, 470, 'non_coding_transcript_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (83, 471, 'WITHIN_NON_CODING_GENE');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (84, 469, 'SO:0001620');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (85, 470, 'mature_miRNA_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (86, 471, 'WITHIN_MATURE_miRNA');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (87, 469, 'SO:0001580');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (88, 470, 'coding_sequence_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (89, 471, 'CODING_UNKNOWN');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (90, 469, 'SO:0001566');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (91, 470, 'regulatory_region_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (92, 471, 'REGULATORY_REGION');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (97, 469, 'SO:0000234');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (98, 470, 'mRNA');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (99, 469, 'SO:0000673');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (100, 470, 'transcript');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (101, 469, 'SO:0000185');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (102, 470, 'primary_transcript');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (103, 469, 'SO:0000655');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (104, 470, 'ncRNA');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (105, 469, 'SO:0000276');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (106, 470, 'miRNA');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (107, 469, 'SO:0005836');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (108, 470, 'regulatory_region');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (109, 469, 'SO:0000409');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (110, 470, 'binding_site');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (111, 470, 'structural_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (112, 469, 'SO:0001537');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (113, 471, 'SV');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (114, 470, 'probe');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (115, 469, 'SO:0000051');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (116, 471, 'CNV_PROBE');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (118, 473, 'transcript');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (119, 474, '20');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (120, 474, '21');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (122, 474, '18');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (124, 474, '19');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (125, 472, 'splice-5');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (126, 473, 'primary_transcript');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (127, 474, '1');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (128, 472, 'splice-3');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (129, 469, 'SO:0001574');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (130, 474, '8');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (131, 472, 'intron');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (132, 474, '15');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (133, 472, 'untranslated_5');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (134, 473, 'mRNA');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (135, 474, '13');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (136, 472, 'untranslated_3');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (137, 474, '14');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (138, 474, '5');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (139, 472, 'cds-synon');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (140, 474, '10');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (141, 472, 'missense');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (142, 474, '7');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (143, 474, '6');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (144, 472, 'nonsense');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (145, 474, '3');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (146, 474, '4');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (147, 472, 'frameshift');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (149, 474, '16');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (150, 473, 'ncRNA');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (151, 474, '17');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (152, 473, 'miRNA');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (153, 474, '12');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (154, 474, '11');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (155, 473, 'regulatory_region');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (157, 473, 'TF_binding_site');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (158, 469, 'SO:0001782');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (159, 470, 'TF_binding_site_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (176, 477, 'hapmap');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (177, 477, 'ind_venter');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (178, 477, 'ind_watson');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (179, 477, 'fail_all');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (180, 477, 'fail_nonref');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (181, 477, 'fail_ambig');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (182, 477, 'fail_gt_fq');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (183, 477, 'fail_incons_map');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (184, 477, 'fail_mult_map');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (185, 477, 'fail_no_alleles');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (186, 477, 'fail_no_gt');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (187, 477, 'fail_no_map');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (188, 477, 'fail_no_seq');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (189, 477, 'fail_non_nt');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (190, 477, 'fail_mult_alleles');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (191, 477, 'ph_hgmd_pub');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (193, 477, 'ph_nhgri');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (194, 477, 'ph_omim');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (195, 477, 'ph_variants');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (196, 477, 'ph_uniprot');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (197, 477, 'ph_cosmic');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (198, 477, 'ph_ega');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (200, 470, 'copy_number_gain');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (201, 469, 'SO:0001742');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (202, 471, 'gain');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (203, 470, 'copy_number_loss');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (204, 469, 'SO:0001743');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (205, 471, 'loss');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (206, 470, 'inversion');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (207, 469, 'SO:1000036');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (208, 470, 'complex_structural_alteration');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (209, 469, 'SO:0001784');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (210, 471, 'complex alteration');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (211, 470, 'tandem_duplication');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (212, 469, 'SO:1000173');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (213, 471, 'tandem duplication');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (214, 477, 'fail_dbsnp_suspect');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (215, 478, 'unknown');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (216, 478, 'untested');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (217, 478, 'non-pathogenic');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (218, 478, 'probable-non-pathogenic');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (219, 478, 'probable-pathogenic');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (220, 478, 'pathogenic');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (221, 478, 'drug-response');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (222, 478, 'histocompatibility');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (223, 478, 'other');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (224, 479, 'Not tested');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (225, 479, 'Benign');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (226, 479, 'Pathogenic');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (227, 479, 'Uncertain Significance');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (228, 479, 'likely benign');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (229, 479, 'likely pathogenic');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (242, 470, 'mobile_element_insertion');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (243, 469, 'SO:0001837');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (244, 471, 'mobile element insertion');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (245, 477, 'PorcineSNP60');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (253, 470, 'duplication');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (254, 469, 'SO:1000035');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (255, 470, 'sequence_feature');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (256, 469, 'SO:0000110');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (257, 477, 'hapmap_ceu');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (258, 477, 'hapmap_hcb');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (259, 477, 'hapmap_jpt');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (260, 477, 'hapmap_yri');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (261, 474, '26');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (262, 474, '22');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (263, 474, '23');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (265, 474, '25');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (266, 474, '24');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (267, 481, 'sift');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (268, 481, 'polyphen_humvar');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (269, 481, 'polyphen_humdiv');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (270, 476, 'tolerated');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (271, 476, 'deleterious');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (272, 475, 'probably damaging');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (273, 475, 'possibly damaging');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (274, 475, 'benign');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (275, 475, 'unknown');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (286, 470, 'interchromosomal_breakpoint');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (287, 469, 'SO:0001873');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (288, 471, 'interchromosomal breakpoint');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (289, 470, 'intrachromosomal_breakpoint');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (290, 469, 'SO:0001874');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (291, 471, 'intrachromosomal breakpoint');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (292, 470, 'translocation');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (293, 469, 'SO:0000199');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (294, 474, '38');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (295, 469, 'SO:0001631');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (296, 470, 'upstream_gene_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (297, 469, 'SO:0001632');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (298, 470, 'downstream_gene_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (299, 469, 'SO:0001819');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (300, 470, 'synonymous_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (301, 470, 'missense_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (302, 469, 'SO:0001821');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (303, 470, 'inframe_insertion');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (304, 469, 'SO:0001822');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (305, 470, 'inframe_deletion');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (306, 470, 'start_lost');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (307, 469, 'SO:0001792');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (308, 470, 'non_coding_transcript_exon_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (309, 474, '36');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (310, 474, '30');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (311, 469, 'SO:0001893');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (312, 470, 'transcript_ablation');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (313, 469, 'SO:0001889');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (314, 470, 'transcript_amplification');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (315, 469, 'SO:0001895');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (316, 470, 'TFBS_ablation');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (317, 469, 'SO:0001892');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (318, 470, 'TFBS_amplification');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (319, 474, '28');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (320, 469, 'SO:0001894');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (321, 470, 'regulatory_region_ablation');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (322, 474, '31');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (323, 469, 'SO:0001891');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (324, 470, 'regulatory_region_amplification');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (325, 474, '33');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (326, 469, 'SO:0001907');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (327, 470, 'feature_elongation');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (328, 469, 'SO:0001906');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (329, 470, 'feature_truncation');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (330, 474, '37');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (331, 471, 'duplication');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (332, 477, 'Affy_500K');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (333, 477, 'Affy_SNP6');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (334, 477, 'Illumina_660Q');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (335, 477, 'Illumina_1M-duo');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (337, 477, 'Cardio-Metabo_Chip');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (338, 477, 'HumanOmni1-Quad');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (339, 477, 'Illumina_CytoSNP12v1');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (340, 477, 'HumanHap650Y');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (341, 477, 'HumanOmni2.5');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (342, 477, 'Human610_Quad');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (343, 477, 'HumanHap550');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (344, 477, 'esp_6500');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (345, 477, 'clin_assoc');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (346, 473, 'sequence_feature');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (348, 477, 'Chicken600K');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (350, 477, 'BovineHD');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (351, 477, 'BovineLD');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (352, 477, 'BovineSNP50');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (353, 477, 'MGP');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (354, 477, 'HumanOmni5');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (355, 477, 'phencode');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (356, 477, 'OvineSNP50');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (357, 477, 'OvineHDSNP');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (358, 477, 'ExomeChip');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (359, 477, 'ImmunoChip');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (360, 477, 'all_chips');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (361, 470, 'novel_sequence_insertion');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (362, 469, 'SO:0001838');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (363, 471, 'novel sequence insertion');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (364, 479, 'not provided');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (365, 479, 'association');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (366, 479, 'risk factor');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (367, 497, 'Multiple_observations');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (368, 497, 'Frequency');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (369, 497, 'HapMap');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (370, 497, '1000Genomes');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (371, 497, 'Cited');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (372, 497, 'ESP');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (373, 477, 'HumanOmniExpress');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (374, 477, 'ClinVar');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (375, 470, 'genetic_marker');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (376, 469, 'SO:0001645');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (377, 480, 'uncertain significance');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (378, 480, 'not provided');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (379, 480, 'benign');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (380, 480, 'likely benign');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (381, 480, 'likely pathogenic');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (382, 480, 'pathogenic');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (383, 480, 'drug response');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (384, 480, 'histocompatibility');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (385, 480, 'other');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (386, 480, 'confers sensitivity');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (387, 480, 'risk factor');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (388, 480, 'association');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (389, 480, 'protective');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (390, 477, 'HumanCoreExome');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (391, 476, 'tolerated - low confidence');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (392, 476, 'deleterious - low confidence');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (395, 477, 'LSDB');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (396, 477, 'dbPEX');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (397, 477, 'HbVar');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (398, 477, 'Infevers');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (399, 477, 'KAT6BDB');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (400, 477, 'LMDD');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (401, 477, 'OIVD');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (402, 477, 'PAHdb');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (404, 477, '1kg_3');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (405, 477, '1kg_3_afr');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (406, 477, '1kg_3_amr');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (407, 477, '1kg_3_eas');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (408, 477, '1kg_3_sas');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (409, 477, '1kg_3_eur');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (410, 477, '1kg_3_com');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (411, 477, '1kg_3_afr_com');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (412, 477, '1kg_3_amr_com');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (413, 477, '1kg_3_eas_com');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (414, 477, '1kg_3_sas_com');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (415, 477, '1kg_3_eur_com');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (416, 469, 'SO:0001818');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (417, 470, 'protein_altering_variant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (418, 497, 'Phenotype_or_Disease');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (419, 477, 'lsdb_variants');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (420, 477, 'exac');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (421, 497, 'ExAC');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (422, 470, 'interchromosomal_translocation');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (423, 469, 'SO:0002060');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (424, 470, 'intrachromosomal_translocation');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (425, 469, 'SO:0002061');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (426, 470, 'Alu_insertion');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (427, 469, 'SO:0002063');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (428, 477, 'PorcineLD');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (429, 477, 'PorcineHD');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (430, 477, 'Affy_PorcineHD');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (431, 470, 'complex_substitution');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (432, 469, 'SO:1000005');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (433, 471, 'complex substitution');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (434, 497, '1000Bull_Genomes');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (435, 497, 'WTSI_MGP');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (436, 508, 'co-located allele');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (437, 509, 'Data source');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (438, 509, 'OLS exact');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (439, 509, 'OLS partial');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (440, 509, 'Zooma exact');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (441, 509, 'Zooma partial');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (442, 509, 'Manual');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (443, 509, 'HPO');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (444, 509, 'Orphanet');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (445, 477, 'CTM');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (446, 477, 'LVP');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (447, 477, 'RexD');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (448, 477, 'Bora_Bora');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (449, 477, 'Perm-R');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (450, 477, 'Imida-R');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (451, 477, 'Propo-R');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (452, 477, 'JPD_insecticide_resistance');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (453, 477, 'PMID:24168143_dengue_functional_polymorphisms');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (454, 477, 'PMID:24593293_insecticide_resistance');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (455, 477, 'Australia_2011');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (456, 477, 'Florida_2011');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (457, 477, 'Puerto_Rico_2013');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (458, 477, 'Uganda_2011');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (459, 477, 'Mexico_2013');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (460, 477, 'Texas_2011');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (461, 477, 'Hawaii_2011');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (462, 477, 'Thailand_2011');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (463, 477, 'PMID_25721127_Aedes_SNP_chip_all_field_isolates');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (464, 477, 'Senegal_Goudiry_2011');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (465, 477, 'Tahiti_2013');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (466, 477, 'Brazil_2013');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (467, 477, 'Senegal_Sedhiou_2011');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (468, 477, 'agsnp01');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (469, 477, '4ARR');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (470, 477, 'KISUMU');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (471, 477, 'Akron');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (472, 477, 'L3-5');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (473, 477, 'G3');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (474, 477, 'TEP1_variations');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (475, 477, 'agsnp01_66k');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (476, 477, 'lstm_gg_0.8k');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (477, 477, 'S.marcescens_infectivity_resistance');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (478, 477, 'affy_250k_snps');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (479, 477, 'perl_1m_snps');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (480, 477, 'cao_snps');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (481, 477, 'wtchg_snps');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (482, 477, 'wtchg_insertions');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (483, 477, 'wtchg_all_variations');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (484, 477, 'wtchg_substitutions');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (485, 477, 'salk_snps');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (486, 477, 'nordborg_snps');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (487, 477, 'salk_all_variations');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (488, 477, 'nordborg_all_variations');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (489, 477, 'salk_deletions');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (490, 477, '1001_snps');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (491, 477, '1001_deletions');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (492, 477, '1001_insertions');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (493, 477, '1001_substitutions');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (494, 477, '1001_all_variations_bc');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (495, 477, 'nordborg_substitutions');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (496, 477, 'salk_substitutions');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (497, 477, 'wtchg_deletions');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (498, 477, 'cao_all_variations');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (499, 477, 'wgs_SNP');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (500, 477, 'RNA-seq_SNP');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (501, 477, 'MxB_popseq_SNP');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (502, 477, 'OWB_popseq_SNP');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (503, 477, 'iSelect_9k');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (504, 477, 'Indiana');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (505, 477, 'Maine');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (506, 477, 'Massachusetts');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (507, 477, 'New_Hampshire');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (508, 477, 'North_Carolina');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (509, 477, 'Wikel_ODU_colony');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (510, 477, 'Wikel_UTMB_colony');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (511, 477, 'Wisconsin');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (512, 477, 'Virginia');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (513, 477, 'Florida');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (514, 477, 'RADSeq_tick_population_analysis');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (515, 477, 'duitama');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (516, 477, 'zhao');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (517, 477, 'bgi');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (518, 477, 'omap');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (519, 477, 'mcnally');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (520, 477, '3k');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (521, 477, 'myles_hq_snps');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (522, 477, 'PMID:26206155_deltamethrin_resistance_study');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (523, 477, 'PMID:26206155_high_significance_deltamethrin_resistance_variants');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (524, 477, 'PMID:23708298_Anopheles_16_genomes');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (525, 477, 'Burkina_Faso');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (526, 477, 'Cameroon');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (527, 477, 'Tanzania');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (528, 477, 'Iran_A_form');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (529, 477, 'Iran_D_form');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (530, 477, 'DDT_resistant');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (531, 477, 'DDT_susceptible');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (532, 477, 'Haleta');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (533, 477, 'Queensland');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (534, 477, 'Madang');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (535, 477, 'Tanna');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (536, 477, 'Folonzo');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (537, 477, 'Kiribina');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (538, 477, 'arabiensis');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (539, 477, 'coluzzii');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (540, 477, 'gambiae');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (541, 477, 'goundry');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (542, 477, 'MR4_colony_variations_WTSI-Ag-GVP-0.1');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (543, 477, 'Campo');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (544, 477, 'Ballingho');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (545, 477, 'Ipono');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (546, 477, 'Luba');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (547, 477, 'Kenya');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (548, 477, 'Mpumalanga');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (549, 477, 'India');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (550, 477, 'Thailand');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (551, 477, 'Zimbabwe');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (552, 477, 'China_S');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (553, 477, 'China_R');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (554, 477, 'Indian_strain_colony');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (555, 477, 'AS01-WBAN');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (556, 477, 'AS01-CHB');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (557, 477, 'AS01-BAN');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (558, 477, 'AS01-IRN');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (559, 477, 'AS01-KAZ');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (560, 469, 'SO:0002096');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (561, 470, 'short_tandem_repeat_variation');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (562, 471, 'short tandem repeat variation');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (563, 469, 'SO:0001786');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (564, 470, 'loss_of_heterozygosity');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (565, 471, 'loss of heterozygosity');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (566, 477, 'Axiom820');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (567, 477, 'Axiom35');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (568, 477, 'EMS_Kronos');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (569, 477, 'EMS_Cadenza');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (570, 477, 'KASP');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (571, 477, 'HapMap_WEC');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (572, 477, 'HapMap_GBS');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (573, 497, 'TOPMed');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (575, 470, 'SVA_insertion');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (578, 477, 'IHVs_AB');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (579, 477, 'IHVs_AD');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (580, 477, 'IHVs_BD');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (581, 477, 'iSelect');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (582, 470, 'mobile_element_deletion');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (583, 469, 'SO:0002066');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (584, 471, 'mobile element deletion');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (585, 497, 'gnomAD');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (586, 477, 'gnomAD');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (587, 477, 'GoatSNP50');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (588, 509, 'Rat Genome Database');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (589, 509, 'Animal_QTLdb');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (590, 509, 'ClinVar');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (591, 509, 'G2P');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (592, 509, 'NHGRI-EBI GWAS catalog');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (593, 509, 'MGP');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (594, 509, 'IMPC');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (595, 477, 'Illumina_EquineSNP50');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (596, 531, 'likely benign');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (597, 531, 'likely deleterious');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (598, 532, 'likely disease causing');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (599, 532, 'likely benign');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (600, 533, 'tolerated');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (601, 534, 'high');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (602, 534, 'medium');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (603, 534, 'low');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (604, 534, 'neutral');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (605, 481, 'dbnsfp_cadd');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (606, 481, 'dbnsfp_meta_lr');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (607, 481, 'dbnsfp_mutation_assessor');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (608, 481, 'dbnsfp_revel');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (609, 481, 'cadd');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (610, 539, 'link_to_primer');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (611, 539, 'snp_type');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (612, 539, 'total_contigs');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (613, 539, 'primer_type');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (614, 539, 'ems_genotype');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (615, 542, 'EPMC');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (616, 542, 'UCSC');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (617, 542, 'dbSNP');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (618, 542, 'GWAS');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (619, 542, 'dbGaP');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (620, 542, 'ClinVar');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (621, 481, 'dbnsfp_meta_svm');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (622, 477, 'VBP0000002');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (623, 477, 'VBP0000003');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (624, 477, 'VBP0000004');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (625, 477, 'VBP0000007');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (626, 477, 'VBP0000015');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (627, 477, 'VBP0000119');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (628, 477, 'VBP0000120');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (629, 477, 'VBP0000121');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (630, 477, 'VBP0000122');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (631, 477, 'VBP0000124');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (632, 477, 'VBP0000125');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (633, 477, 'VBP0000163');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (634, 477, 'VBP0000177');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (635, 477, 'VBP0000187');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (636, 477, 'VBP0000193');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (637, 477, 'VBP0000201');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (638, 477, 'VBP0000205');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (639, 477, 'VBP0000212');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (640, 477, 'VBP0000226');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (641, 477, 'VBP0000227');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (642, 477, 'VBP0000269');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (643, 477, 'VBP0000295');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (644, 477, 'VBP0000454');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (645, 477, 'VBP0000504');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (646, 477, 'VBP0000505');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (647, 470, 'Alu_deletion');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (648, 470, 'LINE1_deletion');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (654, 470, 'SVA_deletion');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (656, 470, 'LINE1_insertion');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (657, 470, 'HERV_insertion');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (658, 470, 'HERV_deletion');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (659, 539, 'mutant_quality');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (660, 539, 'residual_heterogeneity');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (661, 477, 'TaBW280K');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (662, 477, 'snp90K_Svevo');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (663, 544, 'non_specified');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (664, 544, 'tumour');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (665, 544, 'trait');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (666, 545, 'cerealsdb_external_links');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (667, 477, 'SARS_CoV-2_2alt');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (668, 480, 'affects');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (669, 545, 'cerealsdb_qtl');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (670, 477, 'ENA_SARS_CoV-2_var');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (671, 477, 'EMS_Kronos_Promoters');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (672, 477, 'Nottingham_WRC');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (673, 477, 'COG-UK');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (674, 477, 'Watkins-exome-capture');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (675, 477, 'Exome_Capture_Diversity');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (676, 545, 'seedstor_links');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (677, 470, 'complex_chromosomal_rearrangement');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (678, 542, 'G2P');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (679, 477, 'barley50k');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (680, 477, 'EMS_Kronos_Exome_Capture');
INSERT IGNORE INTO attrib (attrib_id, attrib_type_id, value) VALUES (681, 477, 'Watkins_Collection');

INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 1, 1);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 1, 2);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 1, 3);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 2, 4);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 2, 5);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 3, 6);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 3, 7);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 3, 8);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 4, 9);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 4, 10);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 5, 11);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 5, 12);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 6, 13);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 6, 14);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 7, 15);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 7, 16);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 8, 17);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 8, 18);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 38, 97);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 38, 98);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 39, 99);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 39, 100);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 40, 101);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 40, 102);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 41, 103);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 41, 104);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 42, 105);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 42, 106);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 43, 107);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 43, 108);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 44, 109);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 44, 110);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 45, 111);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 45, 112);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 45, 113);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 46, 114);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 46, 115);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 46, 116);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 49, 200);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 49, 201);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 49, 202);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 50, 203);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 50, 204);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 50, 205);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 51, 206);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 51, 207);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 52, 208);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 52, 209);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 52, 210);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 53, 211);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 53, 212);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 53, 213);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 54, 242);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 54, 243);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 54, 244);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 60, 255);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 60, 256);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 79, 72);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 79, 73);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 79, 74);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 79, 134);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 79, 138);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 79, 147);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 87, 286);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 87, 287);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 87, 288);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 88, 289);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 88, 290);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 88, 291);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 89, 292);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 89, 293);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 90, 19);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 90, 20);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 90, 21);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 90, 294);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 91, 24);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 91, 118);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 91, 266);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 91, 295);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 91, 296);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 92, 27);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 92, 118);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 92, 265);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 92, 297);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 92, 298);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 93, 32);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 93, 33);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 93, 34);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 93, 125);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 93, 126);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 93, 145);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 94, 34);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 94, 36);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 94, 126);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 94, 128);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 94, 129);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 94, 145);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 95, 37);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 95, 38);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 95, 39);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 95, 126);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 95, 135);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 97, 43);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 97, 44);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 97, 45);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 97, 122);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 97, 133);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 97, 134);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 98, 46);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 98, 47);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 98, 48);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 98, 124);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 98, 134);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 98, 136);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 99, 54);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 99, 132);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 99, 134);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 99, 139);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 99, 299);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 99, 300);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 100, 55);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 100, 57);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 100, 134);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 100, 141);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 100, 153);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 100, 301);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 101, 57);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 101, 134);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 101, 140);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 101, 302);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 101, 303);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 102, 57);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 102, 134);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 102, 154);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 102, 304);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 102, 305);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 103, 62);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 103, 63);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 103, 64);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 103, 134);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 103, 144);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 103, 146);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 104, 65);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 104, 66);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 104, 67);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 104, 134);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 104, 143);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 105, 54);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 105, 68);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 105, 69);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 105, 132);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 105, 134);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 106, 57);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 106, 70);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 106, 134);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 106, 142);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 106, 306);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 107, 75);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 107, 76);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 107, 77);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 107, 134);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 107, 137);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 109, 81);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 109, 82);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 109, 83);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 109, 150);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 109, 263);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 111, 84);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 111, 85);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 111, 86);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 111, 151);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 111, 152);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 112, 87);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 112, 88);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 112, 89);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 112, 134);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 112, 149);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 113, 90);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 113, 91);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 113, 92);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 113, 155);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 113, 309);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 114, 92);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 114, 157);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 114, 158);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 114, 159);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 114, 310);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 115, 127);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 115, 134);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 115, 311);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 115, 312);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 116, 130);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 116, 134);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 116, 313);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 116, 314);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 117, 157);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 117, 261);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 117, 315);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 117, 316);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 118, 157);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 118, 317);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 118, 318);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 118, 319);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 119, 157);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 119, 320);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 119, 321);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 119, 322);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 120, 157);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 120, 323);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 120, 324);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 120, 325);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 121, 309);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 121, 326);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 121, 327);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 121, 346);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 122, 328);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 122, 329);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 122, 330);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 122, 346);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 123, 253);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 123, 254);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 123, 331);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 124, 40);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 124, 41);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 124, 42);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 124, 120);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 124, 126);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 124, 131);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 125, 78);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 125, 79);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 125, 80);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 125, 134);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 125, 262);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 126, 83);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 126, 119);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 126, 150);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 126, 307);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 126, 308);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 127, 361);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 127, 362);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 127, 363);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 128, 375);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 128, 376);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 129, 134);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 129, 153);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 129, 416);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 129, 417);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 130, 422);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 130, 423);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 131, 424);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 131, 425);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 132, 426);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 132, 427);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 133, 431);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 133, 432);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 133, 433);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 134, 560);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 134, 561);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 134, 562);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 135, 563);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 135, 564);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 135, 565);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 137, 582);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 137, 583);
INSERT IGNORE INTO attrib_set (attrib_set_id, attrib_id) VALUES ( 137, 584);
