# Ensembl Variation API

[![GitHub](https://img.shields.io/github/license/Ensembl/ensembl-variation.svg)](https://github.com/Ensembl/ensembl-variation/blob/release/115/LICENSE)
[![Build Status](https://travis-ci.org/Ensembl/ensembl-variation.png?branch=release/115)](https://travis-ci.org/Ensembl/ensembl-variation)
[![Coverage Status](https://coveralls.io/repos/github/Ensembl/ensembl-variation/badge.svg?branch=release/115)](https://coveralls.io/github/Ensembl/ensembl-variation?branch=release/115)

[travis]: https://travis-ci.org/Ensembl/ensembl-variation
[coveralls]: https://coveralls.io/r/Ensembl/ensembl-variation

The Ensembl Variation API (Application Programme Interface) serves as a middle layer between the underlying MySQL database and the user's script. It aims to encapsulate the database layout by providing high level access to the database.

Find more information (including the installation guide and a tutorial) on the Ensembl website: http://www.ensembl.org/info/docs/api/variation/


## Download
To clone the Ensembl Variation API, use the following command:

```
git clone https://github.com/Ensembl/ensembl-variation.git
```

## API requirements
In order to use the Ensembl Variation API, an installation of the same version of the "Ensembl Core" API is mandatory. A guide for installing all Ensembl APIs and their respective prerequisites is available here:
http://www.ensembl.org/info/docs/api/api_installation.html

## API tutorial
An extensive tutorial for the Ensembl Variation API can be found at:

http://www.ensembl.org/info/docs/api/variation/variation_tutorial.html

## Contributions

If you wish to contribute to this repository or any Ensembl repository, please refer to [our contribution guide](https://github.com/Ensembl/ensembl/blob/release/115/CONTRIBUTING.md).


## Contact us
Please email comments or questions to the public Ensembl developers list at 

<http://lists.ensembl.org/mailman/listinfo/dev>.

Questions may also be sent to the Ensembl help desk at

<http://www.ensembl.org/Help/Contact>.
