-- See the NOTICE file distributed with this work for additional information
-- regarding copyright ownership.
-- 
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
-- 
--      http://www.apache.org/licenses/LICENSE-2.0
-- 
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.

# patch_79_80_b.sql
#
# Title: Remove "genebuild" from the unique key of genome_db
#
# Description:
#   We only have 1 genebuild of each species at a given time, so we
#   can consider than the couple (name,assembly) is unique

ALTER TABLE genome_db DROP KEY name, ADD UNIQUE name (name,assembly,genome_component);

# Patch identifier
INSERT INTO meta (species_id, meta_key, meta_value)
  VALUES (NULL, 'patch', 'patch_79_80_b.sql|genebuild_unique');
