=head1 LICENSE

See the NOTICE file distributed with this work for additional information
regarding copyright ownership.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

=cut

=head1 NAME

Bio::EnsEMBL::Compara::PipeConfig::Vertebrates::HighConfidenceOrthologs_conf

=head1 SYNOPSIS

    init_pipeline.pl Bio::EnsEMBL::Compara::PipeConfig::Vertebrates::HighConfidenceOrthologs_conf -host mysql-ens-compara-prod-X -port XXXX \
        -member_type <protein_or_ncrna>

=head1 DESCRIPTION

A simple pipeline to populate the high- and low-confidence levels on the
Vertebrates Compara database. See parent class for additional information.

=cut

package Bio::EnsEMBL::Compara::PipeConfig::Vertebrates::HighConfidenceOrthologs_conf;

use strict;
use warnings;

use base ('Bio::EnsEMBL::Compara::PipeConfig::HighConfidenceOrthologs_conf');


sub default_options {
    my ($self) = @_;
    return {
        %{ $self->SUPER::default_options() },               # inherit other stuff from the base class

        'division'   => 'vertebrates',

        'compara_db' => '#expr( (#member_type# eq "protein") ? "compara_ptrees" : "compara_nctrees" )expr#',

        'range_label'  => $self->o('member_type'),
        'range_filter' => {
            'protein' => [
                [ 0,          1400000000 ],
                [ 1800000000, 1900000000 ],
                [ 2000000000, 2100000000 ],
            ],
            'ncrna'   => [
                [ 1400000000, 1800000000 ],
                [ 1900000000, 2000000000 ],
                [ 2100000000             ], # single value means 2100000000+
            ],
        },

        # In this structure, the "thresholds" are for resp. the GOC score, the WGA coverage and %identity
        'threshold_levels' => [
            {
                'taxa'          => [ 'Apes', 'Murinae' ],
                'thresholds'    => [ 75, 75, 80 ],
            },
            {
                'taxa'          => [ 'Mammalia', 'Aves', 'Percomorpha' ],
                'thresholds'    => [ 75, 75, 50 ],
            },
            {
                'taxa'          => [ 'all' ],
                'thresholds'    => [ 50, 50, 25 ],
            },
        ],
    };
}

sub pipeline_wide_parameters {
    my ($self) = @_;
    return {
        %{$self->SUPER::pipeline_wide_parameters},          # here we inherit anything from the base class

        'range_filter' => $self->o('range_filter'),
    }
}


1;
