=head1 LICENSE

See the NOTICE file distributed with this work for additional information
regarding copyright ownership.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

=cut


=head1 CONTACT

  Please email comments or questions to the public Ensembl
  developers list at <http://lists.ensembl.org/mailman/listinfo/dev>.

  Questions may also be sent to the Ensembl help desk at
  <http://www.ensembl.org/Help/Contact>.

=head1 NAME

Bio::EnsEMBL::Compara::HAL::UCSCMapping 

=head1 DESCRIPTION

Module to store the UCSC synonyms until they are available in the core database

=cut

package Bio::EnsEMBL::Compara::HAL::UCSCMapping;

use strict;
use warnings;


my $u2e_mapping_mouse = {
"chr1" => "1",
"chr10" => "10",
"chr11" => "11",
"chr12" => "12",
"chr13" => "13",
"chr14" => "14",
"chr15" => "15",
"chr16" => "16",
"chr17" => "17",
"chr18" => "18",
"chr19" => "19",
"chr2" => "2",
"chr3" => "3",
"chr4" => "4",
"chr5" => "5",
"chr6" => "6",
"chr7" => "7",
"chr8" => "8",
"chr9" => "9",
"chr1_GL456210_random" => "GL456210.1",
"chr1_GL456211_random" => "GL456211.1",
"chr1_GL456212_random" => "GL456212.1",
"chr1_GL456213_random" => "GL456213.1",
"chr4_GL456216_random" => "GL456216.1",
"chr7_GL456219_random" => "GL456219.1",
"chr1_GL456221_random" => "GL456221.1",
"chrX_GL456233_random" => "GL456233.1",
"chrUn_GL456239" => "GL456239.1",
"chr4_GL456350_random" => "GL456350.1",
"chr5_GL456354_random" => "GL456354.1",
"chrUn_GL456359" => "GL456359.1",
"chrUn_GL456360" => "GL456360.1",
"chrUn_GL456366" => "GL456366.1",
"chrUn_GL456367" => "GL456367.1",
"chrUn_GL456368" => "GL456368.1",
"chrUn_GL456370" => "GL456370.1",
"chrUn_GL456372" => "GL456372.1",
"chrUn_GL456378" => "GL456378.1",
"chrUn_GL456379" => "GL456379.1",
"chrUn_GL456381" => "GL456381.1",
"chrUn_GL456382" => "GL456382.1",
"chrUn_GL456383" => "GL456383.1",
"chrUn_GL456385" => "GL456385.1",
"chrUn_GL456387" => "GL456387.1",
"chrUn_GL456389" => "GL456389.1",
"chrUn_GL456390" => "GL456390.1",
"chrUn_GL456392" => "GL456392.1",
"chrUn_GL456393" => "GL456393.1",
"chrUn_GL456394" => "GL456394.1",
"chrUn_GL456396" => "GL456396.1",
"chr4_JH584292_random" => "JH584292.1",
"chr4_JH584293_random" => "JH584293.1",
"chr4_JH584294_random" => "JH584294.1",
"chr4_JH584295_random" => "JH584295.1",
"chr5_JH584296_random" => "JH584296.1",
"chr5_JH584297_random" => "JH584297.1",
"chr5_JH584298_random" => "JH584298.1",
"chr5_JH584299_random" => "JH584299.1",
"chrY_JH584300_random" => "JH584300.1",
"chrY_JH584301_random" => "JH584301.1",
"chrY_JH584302_random" => "JH584302.1",
"chrY_JH584303_random" => "JH584303.1",
"chrUn_JH584304" => "JH584304.1",
"chrM" => "MT",
"chrX" => "X",
"chrY" => "Y",
};

my $u2e_mapping_rat = {
"chr1" => "1",
"chr10" => "10",
"chr11" => "11",
"chr12" => "12",
"chr13" => "13",
"chr14" => "14",
"chr15" => "15",
"chr16" => "16",
"chr17" => "17",
"chr18" => "18",
"chr19" => "19",
"chr2" => "2",
"chr20" => "20",
"chr3" => "3",
"chr4" => "4",
"chr5" => "5",
"chr6" => "6",
"chr7" => "7",
"chr8" => "8",
"chr9" => "9",
"chrUn_AABR07022239v1" => "AABR07022239.1",
"chrUn_AABR07022257v1" => "AABR07022257.1",
"chrUn_AABR07022258v1" => "AABR07022258.1",
"chrUn_AABR07022259v1" => "AABR07022259.1",
"chrUn_AABR07022263v1" => "AABR07022263.1",
"chrUn_AABR07022264v1" => "AABR07022264.1",
"chrUn_AABR07022265v1" => "AABR07022265.1",
"chrUn_AABR07022266v1" => "AABR07022266.1",
"chrUn_AABR07022273v1" => "AABR07022273.1",
"chrUn_AABR07022279v1" => "AABR07022279.1",
"chrUn_AABR07022284v1" => "AABR07022284.1",
"chrUn_AABR07022287v1" => "AABR07022287.1",
"chrUn_AABR07022288v1" => "AABR07022288.1",
"chrUn_AABR07022298v1" => "AABR07022298.1",
"chrUn_AABR07022299v1" => "AABR07022299.1",
"chrUn_AABR07022300v1" => "AABR07022300.1",
"chrUn_AABR07022301v1" => "AABR07022301.1",
"chrUn_AABR07022304v1" => "AABR07022304.1",
"chrUn_AABR07022333v1" => "AABR07022333.1",
"chrUn_AABR07022334v1" => "AABR07022334.1",
"chrUn_AABR07022335v1" => "AABR07022335.1",
"chrUn_AABR07022336v1" => "AABR07022336.1",
"chrUn_AABR07022337v1" => "AABR07022337.1",
"chrUn_AABR07022342v1" => "AABR07022342.1",
"chrUn_AABR07022350v1" => "AABR07022350.1",
"chrUn_AABR07022359v1" => "AABR07022359.1",
"chrUn_AABR07022367v1" => "AABR07022367.1",
"chrUn_AABR07022368v1" => "AABR07022368.1",
"chrUn_AABR07022378v1" => "AABR07022378.1",
"chrUn_AABR07022404v1" => "AABR07022404.1",
"chrUn_AABR07022405v1" => "AABR07022405.1",
"chrUn_AABR07022416v1" => "AABR07022416.1",
"chrUn_AABR07022425v1" => "AABR07022425.1",
"chrUn_AABR07022428v1" => "AABR07022428.1",
"chrUn_AABR07022431v1" => "AABR07022431.1",
"chrUn_AABR07022456v1" => "AABR07022456.1",
"chrUn_AABR07022478v1" => "AABR07022478.1",
"chrUn_AABR07022479v1" => "AABR07022479.1",
"chrUn_AABR07022504v1" => "AABR07022504.1",
"chrUn_AABR07022511v1" => "AABR07022511.1",
"chrUn_AABR07022514v1" => "AABR07022514.1",
"chrUn_AABR07022517v1" => "AABR07022517.1",
"chrUn_AABR07022519v1" => "AABR07022519.1",
"chrUn_AABR07022531v1" => "AABR07022531.1",
"chrUn_AABR07022532v1" => "AABR07022532.1",
"chrUn_AABR07022559v1" => "AABR07022559.1",
"chrUn_AABR07022573v1" => "AABR07022573.1",
"chrUn_AABR07022594v1" => "AABR07022594.1",
"chrUn_AABR07022608v1" => "AABR07022608.1",
"chrUn_AABR07022616v1" => "AABR07022616.1",
"chrUn_AABR07022619v1" => "AABR07022619.1",
"chrUn_AABR07022620v1" => "AABR07022620.1",
"chrUn_AABR07022621v1" => "AABR07022621.1",
"chrUn_AABR07022626v1" => "AABR07022626.1",
"chrUn_AABR07022627v1" => "AABR07022627.1",
"chrUn_AABR07022628v1" => "AABR07022628.1",
"chrUn_AABR07022629v1" => "AABR07022629.1",
"chrUn_AABR07022630v1" => "AABR07022630.1",
"chrUn_AABR07022645v1" => "AABR07022645.1",
"chrUn_AABR07022654v1" => "AABR07022654.1",
"chrUn_AABR07022671v1" => "AABR07022671.1",
"chrUn_AABR07022672v1" => "AABR07022672.1",
"chrUn_AABR07022676v1" => "AABR07022676.1",
"chrUn_AABR07022684v1" => "AABR07022684.1",
"chrUn_AABR07022707v1" => "AABR07022707.1",
"chrUn_AABR07022726v1" => "AABR07022726.1",
"chrUn_AABR07022729v1" => "AABR07022729.1",
"chrUn_AABR07022737v1" => "AABR07022737.1",
"chrUn_AABR07022738v1" => "AABR07022738.1",
"chrUn_AABR07022753v1" => "AABR07022753.1",
"chrUn_AABR07022759v1" => "AABR07022759.1",
"chrUn_AABR07022760v1" => "AABR07022760.1",
"chrUn_AABR07022783v1" => "AABR07022783.1",
"chrUn_AABR07022793v1" => "AABR07022793.1",
"chrUn_AABR07022802v1" => "AABR07022802.1",
"chrUn_AABR07022827v1" => "AABR07022827.1",
"chrUn_AABR07022828v1" => "AABR07022828.1",
"chrUn_AABR07022829v1" => "AABR07022829.1",
"chrUn_AABR07022830v1" => "AABR07022830.1",
"chrUn_AABR07022857v1" => "AABR07022857.1",
"chrUn_AABR07022871v1" => "AABR07022871.1",
"chrUn_AABR07022880v1" => "AABR07022880.1",
"chrUn_AABR07022881v1" => "AABR07022881.1",
"chrUn_AABR07022884v1" => "AABR07022884.1",
"chrUn_AABR07022885v1" => "AABR07022885.1",
"chrUn_AABR07022905v1" => "AABR07022905.1",
"chrUn_AABR07022906v1" => "AABR07022906.1",
"chrUn_AABR07022907v1" => "AABR07022907.1",
"chrUn_AABR07022920v1" => "AABR07022920.1",
"chrUn_AABR07022921v1" => "AABR07022921.1",
"chrUn_AABR07022922v1" => "AABR07022922.1",
"chrUn_AABR07022923v1" => "AABR07022923.1",
"chrUn_AABR07022926v1" => "AABR07022926.1",
"chrUn_AABR07022934v1" => "AABR07022934.1",
"chrUn_AABR07022944v1" => "AABR07022944.1",
"chrUn_AABR07022957v1" => "AABR07022957.1",
"chrUn_AABR07022973v1" => "AABR07022973.1",
"chrUn_AABR07022990v1" => "AABR07022990.1",
"chrUn_AABR07022993v1" => "AABR07022993.1",
"chrUn_AABR07022994v1" => "AABR07022994.1",
"chrUn_AABR07023014v1" => "AABR07023014.1",
"chrUn_AABR07023024v1" => "AABR07023024.1",
"chrUn_AABR07023031v1" => "AABR07023031.1",
"chrUn_AABR07023052v1" => "AABR07023052.1",
"chrUn_AABR07023067v1" => "AABR07023067.1",
"chrUn_AABR07023068v1" => "AABR07023068.1",
"chrUn_AABR07023168v1" => "AABR07023168.1",
"chrUn_AABR07023321v1" => "AABR07023321.1",
"chrUn_AABR07023324v1" => "AABR07023324.1",
"chrUn_AABR07023325v1" => "AABR07023325.1",
"chrUn_AABR07023445v1" => "AABR07023445.1",
"chrUn_AABR07023534v1" => "AABR07023534.1",
"chrUn_AABR07023560v1" => "AABR07023560.1",
"chrUn_AABR07023949v1" => "AABR07023949.1",
"chrUn_AABR07023967v1" => "AABR07023967.1",
"chrUn_AABR07023968v1" => "AABR07023968.1",
"chrUn_AABR07023990v1" => "AABR07023990.1",
"chrUn_AABR07024005v1" => "AABR07024005.1",
"chrUn_AABR07024006v1" => "AABR07024006.1",
"chrUn_AABR07024007v1" => "AABR07024007.1",
"chrUn_AABR07024031v1" => "AABR07024031.1",
"chrUn_AABR07024032v1" => "AABR07024032.1",
"chrUn_AABR07024039v1" => "AABR07024039.1",
"chrUn_AABR07024040v1" => "AABR07024040.1",
"chrUn_AABR07024041v1" => "AABR07024041.1",
"chrUn_AABR07024042v1" => "AABR07024042.1",
"chrUn_AABR07024043v1" => "AABR07024043.1",
"chrUn_AABR07024044v1" => "AABR07024044.1",
"chrUn_AABR07024045v1" => "AABR07024045.1",
"chrUn_AABR07024046v1" => "AABR07024046.1",
"chrUn_AABR07024047v1" => "AABR07024047.1",
"chrUn_AABR07024066v1" => "AABR07024066.1",
"chrUn_AABR07024067v1" => "AABR07024067.1",
"chrUn_AABR07024071v1" => "AABR07024071.1",
"chrUn_AABR07024080v1" => "AABR07024080.1",
"chrUn_AABR07024092v1" => "AABR07024092.1",
"chrUn_AABR07024100v1" => "AABR07024100.1",
"chrUn_AABR07024101v1" => "AABR07024101.1",
"chrUn_AABR07024102v1" => "AABR07024102.1",
"chrUn_AABR07024103v1" => "AABR07024103.1",
"chrUn_AABR07024104v1" => "AABR07024104.1",
"chrUn_AABR07024105v1" => "AABR07024105.1",
"chrUn_AABR07024106v1" => "AABR07024106.1",
"chrUn_AABR07024114v1" => "AABR07024114.1",
"chrUn_AABR07024115v1" => "AABR07024115.1",
"chrUn_AABR07024118v1" => "AABR07024118.1",
"chrUn_AABR07024119v1" => "AABR07024119.1",
"chrUn_AABR07024120v1" => "AABR07024120.1",
"chrUn_AABR07024121v1" => "AABR07024121.1",
"chrUn_AABR07024122v1" => "AABR07024122.1",
"chrUn_AABR07024123v1" => "AABR07024123.1",
"chrUn_AABR07024124v1" => "AABR07024124.1",
"chrUn_AABR07024125v1" => "AABR07024125.1",
"chrUn_AABR07024138v1" => "AABR07024138.1",
"chrUn_AABR07024145v1" => "AABR07024145.1",
"chrUn_AABR07024150v1" => "AABR07024150.1",
"chrUn_AABR07024159v1" => "AABR07024159.1",
"chrUn_AABR07024160v1" => "AABR07024160.1",
"chrUn_AABR07024165v1" => "AABR07024165.1",
"chrUn_AABR07024177v1" => "AABR07024177.1",
"chrUn_AABR07024178v1" => "AABR07024178.1",
"chrUn_AABR07024182v1" => "AABR07024182.1",
"chrUn_AABR07024187v1" => "AABR07024187.1",
"chrUn_AABR07024188v1" => "AABR07024188.1",
"chrUn_AABR07024189v1" => "AABR07024189.1",
"chrUn_AABR07024192v1" => "AABR07024192.1",
"chrUn_AABR07024193v1" => "AABR07024193.1",
"chrUn_AABR07024194v1" => "AABR07024194.1",
"chrUn_AABR07024195v1" => "AABR07024195.1",
"chrUn_AABR07024196v1" => "AABR07024196.1",
"chrUn_AABR07024203v1" => "AABR07024203.1",
"chrUn_AABR07024204v1" => "AABR07024204.1",
"chrUn_AABR07024205v1" => "AABR07024205.1",
"chrUn_AABR07024206v1" => "AABR07024206.1",
"chrUn_AABR07024221v1" => "AABR07024221.1",
"chrUn_AABR07024222v1" => "AABR07024222.1",
"chrUn_AABR07024223v1" => "AABR07024223.1",
"chrUn_AABR07024226v1" => "AABR07024226.1",
"chrUn_AABR07024227v1" => "AABR07024227.1",
"chrUn_AABR07024228v1" => "AABR07024228.1",
"chrUn_AABR07024229v1" => "AABR07024229.1",
"chrUn_AABR07024262v1" => "AABR07024262.1",
"chrUn_AABR07024263v1" => "AABR07024263.1",
"chrUn_AABR07024264v1" => "AABR07024264.1",
"chrUn_AABR07024265v1" => "AABR07024265.1",
"chrUn_AABR07024266v1" => "AABR07024266.1",
"chrUn_AABR07024267v1" => "AABR07024267.1",
"chrUn_AABR07024268v1" => "AABR07024268.1",
"chrUn_AABR07024269v1" => "AABR07024269.1",
"chrUn_AABR07024286v1" => "AABR07024286.1",
"chrUn_AABR07024289v1" => "AABR07024289.1",
"chrUn_AABR07024290v1" => "AABR07024290.1",
"chrUn_AABR07024291v1" => "AABR07024291.1",
"chrUn_AABR07024292v1" => "AABR07024292.1",
"chrUn_AABR07024293v1" => "AABR07024293.1",
"chrUn_AABR07024294v1" => "AABR07024294.1",
"chrUn_AABR07024304v1" => "AABR07024304.1",
"chrUn_AABR07024319v1" => "AABR07024319.1",
"chrUn_AABR07024320v1" => "AABR07024320.1",
"chrUn_AABR07024321v1" => "AABR07024321.1",
"chrUn_AABR07024322v1" => "AABR07024322.1",
"chrUn_AABR07024323v1" => "AABR07024323.1",
"chrUn_AABR07024331v1" => "AABR07024331.1",
"chrUn_AABR07024332v1" => "AABR07024332.1",
"chrUn_AABR07024349v1" => "AABR07024349.1",
"chrUn_AABR07024350v1" => "AABR07024350.1",
"chrUn_AABR07024351v1" => "AABR07024351.1",
"chrUn_AABR07024371v1" => "AABR07024371.1",
"chrUn_AABR07024374v1" => "AABR07024374.1",
"chrUn_AABR07024382v1" => "AABR07024382.1",
"chrUn_AABR07024383v1" => "AABR07024383.1",
"chrUn_AABR07024390v1" => "AABR07024390.1",
"chrUn_AABR07024393v1" => "AABR07024393.1",
"chrUn_AABR07024394v1" => "AABR07024394.1",
"chrUn_AABR07024395v1" => "AABR07024395.1",
"chrUn_AABR07024396v1" => "AABR07024396.1",
"chrUn_AABR07024397v1" => "AABR07024397.1",
"chrUn_AABR07024398v1" => "AABR07024398.1",
"chrUn_AABR07024399v1" => "AABR07024399.1",
"chrUn_AABR07024421v1" => "AABR07024421.1",
"chrUn_AABR07024427v1" => "AABR07024427.1",
"chrUn_AABR07024428v1" => "AABR07024428.1",
"chrUn_AABR07024432v1" => "AABR07024432.1",
"chrUn_AABR07024433v1" => "AABR07024433.1",
"chrX_AABR07045681v1_random" => "AABR07045681.1",
"chrX_AABR07045688v1_random" => "AABR07045688.1",
"chrX_AABR07045689v1_random" => "AABR07045689.1",
"chrX_AABR07045742v1_random" => "AABR07045742.1",
"chrX_AABR07045743v1_random" => "AABR07045743.1",
"chrX_AABR07045766v1_random" => "AABR07045766.1",
"chrX_AABR07045776v1_random" => "AABR07045776.1",
"chr2_AABR07045875v1_random" => "AABR07045875.1",
"chr2_AABR07045975v1_random" => "AABR07045975.1",
"chr2_AABR07046014v1_random" => "AABR07046014.1",
"chr7_AABR07046019v1_random" => "AABR07046019.1",
"chr7_AABR07046034v1_random" => "AABR07046034.1",
"chr7_AABR07046136v1_random" => "AABR07046136.1",
"chr7_AABR07046137v1_random" => "AABR07046137.1",
"chr1_AABR07046142v1_random" => "AABR07046142.1",
"chr1_AABR07046150v1_random" => "AABR07046150.1",
"chr1_AABR07046158v1_random" => "AABR07046158.1",
"chr1_AABR07046159v1_random" => "AABR07046159.1",
"chr1_AABR07046182v1_random" => "AABR07046182.1",
"chr1_AABR07046186v1_random" => "AABR07046186.1",
"chr1_AABR07046187v1_random" => "AABR07046187.1",
"chr1_AABR07046211v1_random" => "AABR07046211.1",
"chr1_AABR07046212v1_random" => "AABR07046212.1",
"chr1_AABR07046222v1_random" => "AABR07046222.1",
"chr1_AABR07046230v1_random" => "AABR07046230.1",
"chr1_AABR07046231v1_random" => "AABR07046231.1",
"chr3_AABR07046243v1_random" => "AABR07046243.1",
"chr3_AABR07046248v1_random" => "AABR07046248.1",
"chr3_AABR07046249v1_random" => "AABR07046249.1",
"chr3_AABR07046267v1_random" => "AABR07046267.1",
"chr3_AABR07046283v1_random" => "AABR07046283.1",
"chr3_AABR07046296v1_random" => "AABR07046296.1",
"chr3_AABR07046319v1_random" => "AABR07046319.1",
"chr4_AABR07046405v1_random" => "AABR07046405.1",
"chr5_AABR07046433v1_random" => "AABR07046433.1",
"chr5_AABR07046507v1_random" => "AABR07046507.1",
"chr15_AABR07046563v1_random" => "AABR07046563.1",
"chr8_AABR07050661v1_random" => "AABR07050661.1",
"chr8_AABR07050689v1_random" => "AABR07050689.1",
"chr8_AABR07050727v1_random" => "AABR07050727.1",
"chr13_AABR07050784v1_random" => "AABR07050784.1",
"chr11_AABR07050811v1_random" => "AABR07050811.1",
"chr11_AABR07050815v1_random" => "AABR07050815.1",
"chr11_AABR07050825v1_random" => "AABR07050825.1",
"chr10_AABR07050850v1_random" => "AABR07050850.1",
"chr10_AABR07050887v1_random" => "AABR07050887.1",
"chr10_AABR07050894v1_random" => "AABR07050894.1",
"chr17_AABR07050910v1_random" => "AABR07050910.1",
"chr17_AABR07050911v1_random" => "AABR07050911.1",
"chr17_AABR07050912v1_random" => "AABR07050912.1",
"chr17_AABR07050916v1_random" => "AABR07050916.1",
"chr16_AABR07050959v1_random" => "AABR07050959.1",
"chr16_AABR07050985v1_random" => "AABR07050985.1",
"chr16_AABR07050986v1_random" => "AABR07050986.1",
"chr16_AABR07050989v1_random" => "AABR07050989.1",
"chr12_AABR07051059v1_random" => "AABR07051059.1",
"chr12_AABR07051089v1_random" => "AABR07051089.1",
"chr12_AABR07051090v1_random" => "AABR07051090.1",
"chr18_AABR07051098v1_random" => "AABR07051098.1",
"chr18_AABR07051099v1_random" => "AABR07051099.1",
"chr18_AABR07051126v1_random" => "AABR07051126.1",
"chr9_AABR07051154v1_random" => "AABR07051154.1",
"chr9_AABR07051155v1_random" => "AABR07051155.1",
"chr6_AABR07055042v1_random" => "AABR07055042.1",
"chr20_AABR07055056v1_random" => "AABR07055056.1",
"chr20_AABR07055065v1_random" => "AABR07055065.1",
"chr1_KL567879v1_random" => "KL567879.1",
"chr1_KL567880v1_random" => "KL567880.1",
"chr1_KL567881v1_random" => "KL567881.1",
"chr1_KL567882v1_random" => "KL567882.1",
"chr1_KL567883v1_random" => "KL567883.1",
"chr1_KL567884v1_random" => "KL567884.1",
"chr1_KL567885v1_random" => "KL567885.1",
"chr1_KL567886v1_random" => "KL567886.1",
"chr1_KL567887v1_random" => "KL567887.1",
"chr1_KL567888v1_random" => "KL567888.1",
"chr1_KL567889v1_random" => "KL567889.1",
"chr1_KL567890v1_random" => "KL567890.1",
"chr1_KL567891v1_random" => "KL567891.1",
"chr1_KL567892v1_random" => "KL567892.1",
"chr1_KL567893v1_random" => "KL567893.1",
"chr1_KL567894v1_random" => "KL567894.1",
"chr1_KL567895v1_random" => "KL567895.1",
"chr2_KL567896v1_random" => "KL567896.1",
"chr2_KL567897v1_random" => "KL567897.1",
"chr2_KL567898v1_random" => "KL567898.1",
"chr2_KL567899v1_random" => "KL567899.1",
"chr2_KL567900v1_random" => "KL567900.1",
"chr2_KL567901v1_random" => "KL567901.1",
"chr2_KL567902v1_random" => "KL567902.1",
"chr2_KL567903v1_random" => "KL567903.1",
"chr2_KL567904v1_random" => "KL567904.1",
"chr2_KL567905v1_random" => "KL567905.1",
"chr2_KL567906v1_random" => "KL567906.1",
"chr2_KL567907v1_random" => "KL567907.1",
"chr2_KL567908v1_random" => "KL567908.1",
"chr2_KL567909v1_random" => "KL567909.1",
"chr2_KL567910v1_random" => "KL567910.1",
"chr2_KL567911v1_random" => "KL567911.1",
"chr2_KL567912v1_random" => "KL567912.1",
"chr2_KL567913v1_random" => "KL567913.1",
"chr2_KL567914v1_random" => "KL567914.1",
"chr2_KL567915v1_random" => "KL567915.1",
"chr3_KL567916v1_random" => "KL567916.1",
"chr3_KL567917v1_random" => "KL567917.1",
"chr3_KL567918v1_random" => "KL567918.1",
"chr3_KL567919v1_random" => "KL567919.1",
"chr3_KL567920v1_random" => "KL567920.1",
"chr3_KL567921v1_random" => "KL567921.1",
"chr3_KL567922v1_random" => "KL567922.1",
"chr3_KL567923v1_random" => "KL567923.1",
"chr3_KL567924v1_random" => "KL567924.1",
"chr3_KL567925v1_random" => "KL567925.1",
"chr3_KL567926v1_random" => "KL567926.1",
"chr3_KL567927v1_random" => "KL567927.1",
"chr3_KL567928v1_random" => "KL567928.1",
"chr3_KL567929v1_random" => "KL567929.1",
"chr3_KL567930v1_random" => "KL567930.1",
"chr3_KL567931v1_random" => "KL567931.1",
"chr3_KL567932v1_random" => "KL567932.1",
"chr4_KL567933v1_random" => "KL567933.1",
"chr4_KL567934v1_random" => "KL567934.1",
"chr4_KL567935v1_random" => "KL567935.1",
"chr4_KL567936v1_random" => "KL567936.1",
"chr4_KL567937v1_random" => "KL567937.1",
"chr4_KL567938v1_random" => "KL567938.1",
"chr4_KL567939v1_random" => "KL567939.1",
"chr4_KL567940v1_random" => "KL567940.1",
"chr4_KL567941v1_random" => "KL567941.1",
"chr4_KL567942v1_random" => "KL567942.1",
"chr4_KL567943v1_random" => "KL567943.1",
"chr4_KL567944v1_random" => "KL567944.1",
"chr4_KL567945v1_random" => "KL567945.1",
"chr4_KL567946v1_random" => "KL567946.1",
"chr4_KL567947v1_random" => "KL567947.1",
"chr5_KL567948v1_random" => "KL567948.1",
"chr5_KL567949v1_random" => "KL567949.1",
"chr5_KL567950v1_random" => "KL567950.1",
"chr5_KL567951v1_random" => "KL567951.1",
"chr5_KL567952v1_random" => "KL567952.1",
"chr5_KL567953v1_random" => "KL567953.1",
"chr5_KL567954v1_random" => "KL567954.1",
"chr5_KL567955v1_random" => "KL567955.1",
"chr5_KL567956v1_random" => "KL567956.1",
"chr5_KL567957v1_random" => "KL567957.1",
"chr5_KL567958v1_random" => "KL567958.1",
"chr5_KL567959v1_random" => "KL567959.1",
"chr5_KL567960v1_random" => "KL567960.1",
"chr5_KL567961v1_random" => "KL567961.1",
"chr5_KL567962v1_random" => "KL567962.1",
"chr5_KL567963v1_random" => "KL567963.1",
"chr5_KL567964v1_random" => "KL567964.1",
"chr6_KL567965v1_random" => "KL567965.1",
"chr6_KL567966v1_random" => "KL567966.1",
"chr6_KL567967v1_random" => "KL567967.1",
"chr6_KL567968v1_random" => "KL567968.1",
"chr6_KL567969v1_random" => "KL567969.1",
"chr6_KL567970v1_random" => "KL567970.1",
"chr6_KL567971v1_random" => "KL567971.1",
"chr6_KL567972v1_random" => "KL567972.1",
"chr6_KL567973v1_random" => "KL567973.1",
"chr6_KL567974v1_random" => "KL567974.1",
"chr7_KL567975v1_random" => "KL567975.1",
"chr7_KL567976v1_random" => "KL567976.1",
"chr7_KL567977v1_random" => "KL567977.1",
"chr7_KL567978v1_random" => "KL567978.1",
"chr7_KL567979v1_random" => "KL567979.1",
"chr7_KL567980v1_random" => "KL567980.1",
"chr7_KL567981v1_random" => "KL567981.1",
"chr7_KL567982v1_random" => "KL567982.1",
"chr7_KL567983v1_random" => "KL567983.1",
"chr7_KL567984v1_random" => "KL567984.1",
"chr7_KL567985v1_random" => "KL567985.1",
"chr7_KL567986v1_random" => "KL567986.1",
"chr7_KL567987v1_random" => "KL567987.1",
"chr7_KL567988v1_random" => "KL567988.1",
"chr7_KL567989v1_random" => "KL567989.1",
"chr7_KL567990v1_random" => "KL567990.1",
"chr7_KL567991v1_random" => "KL567991.1",
"chr7_KL567992v1_random" => "KL567992.1",
"chr7_KL567993v1_random" => "KL567993.1",
"chr7_KL567994v1_random" => "KL567994.1",
"chr8_KL567995v1_random" => "KL567995.1",
"chr8_KL567996v1_random" => "KL567996.1",
"chr8_KL567997v1_random" => "KL567997.1",
"chr8_KL567998v1_random" => "KL567998.1",
"chr8_KL567999v1_random" => "KL567999.1",
"chr8_KL568000v1_random" => "KL568000.1",
"chr8_KL568001v1_random" => "KL568001.1",
"chr8_KL568002v1_random" => "KL568002.1",
"chr9_KL568003v1_random" => "KL568003.1",
"chr9_KL568004v1_random" => "KL568004.1",
"chr9_KL568005v1_random" => "KL568005.1",
"chr9_KL568006v1_random" => "KL568006.1",
"chr9_KL568007v1_random" => "KL568007.1",
"chr10_KL568008v1_random" => "KL568008.1",
"chr10_KL568009v1_random" => "KL568009.1",
"chr10_KL568010v1_random" => "KL568010.1",
"chr10_KL568011v1_random" => "KL568011.1",
"chr10_KL568012v1_random" => "KL568012.1",
"chr10_KL568013v1_random" => "KL568013.1",
"chr10_KL568014v1_random" => "KL568014.1",
"chr10_KL568015v1_random" => "KL568015.1",
"chr10_KL568016v1_random" => "KL568016.1",
"chr10_KL568017v1_random" => "KL568017.1",
"chr10_KL568018v1_random" => "KL568018.1",
"chr11_KL568019v1_random" => "KL568019.1",
"chr11_KL568020v1_random" => "KL568020.1",
"chr11_KL568021v1_random" => "KL568021.1",
"chr11_KL568022v1_random" => "KL568022.1",
"chr11_KL568023v1_random" => "KL568023.1",
"chr11_KL568024v1_random" => "KL568024.1",
"chr11_KL568025v1_random" => "KL568025.1",
"chr11_KL568026v1_random" => "KL568026.1",
"chr11_KL568027v1_random" => "KL568027.1",
"chr11_KL568028v1_random" => "KL568028.1",
"chr11_KL568029v1_random" => "KL568029.1",
"chr11_KL568030v1_random" => "KL568030.1",
"chr11_KL568031v1_random" => "KL568031.1",
"chr12_KL568032v1_random" => "KL568032.1",
"chr12_KL568033v1_random" => "KL568033.1",
"chr12_KL568034v1_random" => "KL568034.1",
"chr12_KL568035v1_random" => "KL568035.1",
"chr12_KL568036v1_random" => "KL568036.1",
"chr12_KL568037v1_random" => "KL568037.1",
"chr12_KL568038v1_random" => "KL568038.1",
"chr12_KL568039v1_random" => "KL568039.1",
"chr12_KL568040v1_random" => "KL568040.1",
"chr13_KL568041v1_random" => "KL568041.1",
"chr13_KL568042v1_random" => "KL568042.1",
"chr13_KL568043v1_random" => "KL568043.1",
"chr13_KL568044v1_random" => "KL568044.1",
"chr13_KL568045v1_random" => "KL568045.1",
"chr13_KL568046v1_random" => "KL568046.1",
"chr13_KL568047v1_random" => "KL568047.1",
"chr13_KL568048v1_random" => "KL568048.1",
"chr13_KL568049v1_random" => "KL568049.1",
"chr13_KL568050v1_random" => "KL568050.1",
"chr13_KL568051v1_random" => "KL568051.1",
"chr14_KL568052v1_random" => "KL568052.1",
"chr14_KL568053v1_random" => "KL568053.1",
"chr14_KL568054v1_random" => "KL568054.1",
"chr14_KL568055v1_random" => "KL568055.1",
"chr14_KL568056v1_random" => "KL568056.1",
"chr14_KL568057v1_random" => "KL568057.1",
"chr14_KL568058v1_random" => "KL568058.1",
"chr14_KL568059v1_random" => "KL568059.1",
"chr14_KL568060v1_random" => "KL568060.1",
"chr14_KL568061v1_random" => "KL568061.1",
"chr15_KL568062v1_random" => "KL568062.1",
"chr15_KL568063v1_random" => "KL568063.1",
"chr15_KL568064v1_random" => "KL568064.1",
"chr15_KL568065v1_random" => "KL568065.1",
"chr15_KL568066v1_random" => "KL568066.1",
"chr15_KL568067v1_random" => "KL568067.1",
"chr15_KL568068v1_random" => "KL568068.1",
"chr15_KL568069v1_random" => "KL568069.1",
"chr15_KL568070v1_random" => "KL568070.1",
"chr15_KL568071v1_random" => "KL568071.1",
"chr15_KL568072v1_random" => "KL568072.1",
"chr15_KL568073v1_random" => "KL568073.1",
"chr15_KL568074v1_random" => "KL568074.1",
"chr16_KL568075v1_random" => "KL568075.1",
"chr16_KL568076v1_random" => "KL568076.1",
"chr16_KL568077v1_random" => "KL568077.1",
"chr16_KL568078v1_random" => "KL568078.1",
"chr16_KL568079v1_random" => "KL568079.1",
"chr16_KL568080v1_random" => "KL568080.1",
"chr16_KL568081v1_random" => "KL568081.1",
"chr16_KL568082v1_random" => "KL568082.1",
"chr17_KL568083v1_random" => "KL568083.1",
"chr17_KL568084v1_random" => "KL568084.1",
"chr17_KL568085v1_random" => "KL568085.1",
"chr17_KL568086v1_random" => "KL568086.1",
"chr17_KL568087v1_random" => "KL568087.1",
"chr17_KL568088v1_random" => "KL568088.1",
"chr17_KL568089v1_random" => "KL568089.1",
"chr17_KL568090v1_random" => "KL568090.1",
"chr17_KL568091v1_random" => "KL568091.1",
"chr17_KL568092v1_random" => "KL568092.1",
"chr18_KL568093v1_random" => "KL568093.1",
"chr18_KL568094v1_random" => "KL568094.1",
"chr18_KL568095v1_random" => "KL568095.1",
"chr18_KL568096v1_random" => "KL568096.1",
"chr18_KL568097v1_random" => "KL568097.1",
"chr18_KL568098v1_random" => "KL568098.1",
"chr18_KL568099v1_random" => "KL568099.1",
"chr19_KL568100v1_random" => "KL568100.1",
"chr19_KL568101v1_random" => "KL568101.1",
"chr19_KL568102v1_random" => "KL568102.1",
"chr20_KL568103v1_random" => "KL568103.1",
"chr20_KL568104v1_random" => "KL568104.1",
"chr20_KL568105v1_random" => "KL568105.1",
"chr20_KL568106v1_random" => "KL568106.1",
"chr20_KL568107v1_random" => "KL568107.1",
"chr20_KL568108v1_random" => "KL568108.1",
"chr20_KL568109v1_random" => "KL568109.1",
"chr20_KL568110v1_random" => "KL568110.1",
"chrX_KL568111v1_random" => "KL568111.1",
"chrX_KL568112v1_random" => "KL568112.1",
"chrX_KL568113v1_random" => "KL568113.1",
"chrX_KL568114v1_random" => "KL568114.1",
"chrX_KL568115v1_random" => "KL568115.1",
"chrX_KL568116v1_random" => "KL568116.1",
"chrX_KL568117v1_random" => "KL568117.1",
"chrX_KL568118v1_random" => "KL568118.1",
"chrX_KL568119v1_random" => "KL568119.1",
"chrX_KL568120v1_random" => "KL568120.1",
"chrX_KL568121v1_random" => "KL568121.1",
"chrX_KL568122v1_random" => "KL568122.1",
"chrX_KL568123v1_random" => "KL568123.1",
"chrX_KL568124v1_random" => "KL568124.1",
"chrX_KL568125v1_random" => "KL568125.1",
"chrX_KL568126v1_random" => "KL568126.1",
"chrX_KL568127v1_random" => "KL568127.1",
"chrX_KL568128v1_random" => "KL568128.1",
"chrX_KL568129v1_random" => "KL568129.1",
"chrX_KL568130v1_random" => "KL568130.1",
"chrX_KL568131v1_random" => "KL568131.1",
"chrX_KL568132v1_random" => "KL568132.1",
"chrX_KL568133v1_random" => "KL568133.1",
"chrX_KL568134v1_random" => "KL568134.1",
"chrX_KL568135v1_random" => "KL568135.1",
"chrX_KL568136v1_random" => "KL568136.1",
"chrX_KL568137v1_random" => "KL568137.1",
"chrX_KL568138v1_random" => "KL568138.1",
"chrY_KL568139v1_random" => "KL568139.1",
"chrY_KL568140v1_random" => "KL568140.1",
"chrY_KL568141v1_random" => "KL568141.1",
"chrY_KL568142v1_random" => "KL568142.1",
"chrY_KL568143v1_random" => "KL568143.1",
"chrY_KL568144v1_random" => "KL568144.1",
"chrY_KL568145v1_random" => "KL568145.1",
"chrY_KL568146v1_random" => "KL568146.1",
"chrY_KL568147v1_random" => "KL568147.1",
"chrY_KL568148v1_random" => "KL568148.1",
"chrY_KL568149v1_random" => "KL568149.1",
"chrY_KL568150v1_random" => "KL568150.1",
"chrY_KL568151v1_random" => "KL568151.1",
"chrY_KL568152v1_random" => "KL568152.1",
"chrY_KL568153v1_random" => "KL568153.1",
"chrY_KL568154v1_random" => "KL568154.1",
"chrY_KL568155v1_random" => "KL568155.1",
"chrY_KL568156v1_random" => "KL568156.1",
"chrY_KL568157v1_random" => "KL568157.1",
"chrY_KL568158v1_random" => "KL568158.1",
"chrY_KL568159v1_random" => "KL568159.1",
"chrY_KL568160v1_random" => "KL568160.1",
"chrY_KL568161v1_random" => "KL568161.1",
"chrY_KL568162v1_random" => "KL568162.1",
"chrY_KL568163v1_random" => "KL568163.1",
"chrY_KL568164v1_random" => "KL568164.1",
"chrY_KL568165v1_random" => "KL568165.1",
"chrY_KL568166v1_random" => "KL568166.1",
"chrUn_KL568167v1" => "KL568167.1",
"chrUn_KL568168v1" => "KL568168.1",
"chrUn_KL568169v1" => "KL568169.1",
"chrUn_KL568170v1" => "KL568170.1",
"chrUn_KL568171v1" => "KL568171.1",
"chrUn_KL568172v1" => "KL568172.1",
"chrUn_KL568173v1" => "KL568173.1",
"chrUn_KL568174v1" => "KL568174.1",
"chrUn_KL568175v1" => "KL568175.1",
"chrUn_KL568176v1" => "KL568176.1",
"chrUn_KL568177v1" => "KL568177.1",
"chrUn_KL568178v1" => "KL568178.1",
"chrUn_KL568179v1" => "KL568179.1",
"chrUn_KL568180v1" => "KL568180.1",
"chrUn_KL568181v1" => "KL568181.1",
"chrUn_KL568182v1" => "KL568182.1",
"chrUn_KL568183v1" => "KL568183.1",
"chrUn_KL568184v1" => "KL568184.1",
"chrUn_KL568185v1" => "KL568185.1",
"chrUn_KL568186v1" => "KL568186.1",
"chrUn_KL568187v1" => "KL568187.1",
"chrUn_KL568188v1" => "KL568188.1",
"chrUn_KL568189v1" => "KL568189.1",
"chrUn_KL568190v1" => "KL568190.1",
"chrUn_KL568191v1" => "KL568191.1",
"chrUn_KL568192v1" => "KL568192.1",
"chrUn_KL568193v1" => "KL568193.1",
"chrUn_KL568194v1" => "KL568194.1",
"chrUn_KL568195v1" => "KL568195.1",
"chrUn_KL568196v1" => "KL568196.1",
"chrUn_KL568197v1" => "KL568197.1",
"chrUn_KL568198v1" => "KL568198.1",
"chrUn_KL568199v1" => "KL568199.1",
"chrUn_KL568200v1" => "KL568200.1",
"chrUn_KL568201v1" => "KL568201.1",
"chrUn_KL568202v1" => "KL568202.1",
"chrUn_KL568203v1" => "KL568203.1",
"chrUn_KL568204v1" => "KL568204.1",
"chrUn_KL568205v1" => "KL568205.1",
"chrUn_KL568206v1" => "KL568206.1",
"chrUn_KL568207v1" => "KL568207.1",
"chrUn_KL568208v1" => "KL568208.1",
"chrUn_KL568209v1" => "KL568209.1",
"chrUn_KL568210v1" => "KL568210.1",
"chrUn_KL568211v1" => "KL568211.1",
"chrUn_KL568212v1" => "KL568212.1",
"chrUn_KL568213v1" => "KL568213.1",
"chrUn_KL568214v1" => "KL568214.1",
"chrUn_KL568215v1" => "KL568215.1",
"chrUn_KL568216v1" => "KL568216.1",
"chrUn_KL568217v1" => "KL568217.1",
"chrUn_KL568218v1" => "KL568218.1",
"chrUn_KL568219v1" => "KL568219.1",
"chrUn_KL568220v1" => "KL568220.1",
"chrUn_KL568221v1" => "KL568221.1",
"chrUn_KL568222v1" => "KL568222.1",
"chrUn_KL568223v1" => "KL568223.1",
"chrUn_KL568224v1" => "KL568224.1",
"chrUn_KL568225v1" => "KL568225.1",
"chrUn_KL568226v1" => "KL568226.1",
"chrUn_KL568227v1" => "KL568227.1",
"chrUn_KL568228v1" => "KL568228.1",
"chrUn_KL568229v1" => "KL568229.1",
"chrUn_KL568230v1" => "KL568230.1",
"chrUn_KL568231v1" => "KL568231.1",
"chrUn_KL568232v1" => "KL568232.1",
"chrUn_KL568233v1" => "KL568233.1",
"chrUn_KL568234v1" => "KL568234.1",
"chrUn_KL568235v1" => "KL568235.1",
"chrUn_KL568236v1" => "KL568236.1",
"chrUn_KL568237v1" => "KL568237.1",
"chrUn_KL568238v1" => "KL568238.1",
"chrUn_KL568239v1" => "KL568239.1",
"chrUn_KL568240v1" => "KL568240.1",
"chrUn_KL568241v1" => "KL568241.1",
"chrUn_KL568242v1" => "KL568242.1",
"chrUn_KL568243v1" => "KL568243.1",
"chrUn_KL568244v1" => "KL568244.1",
"chrUn_KL568245v1" => "KL568245.1",
"chrUn_KL568246v1" => "KL568246.1",
"chrUn_KL568247v1" => "KL568247.1",
"chrUn_KL568248v1" => "KL568248.1",
"chrUn_KL568249v1" => "KL568249.1",
"chrUn_KL568250v1" => "KL568250.1",
"chrUn_KL568251v1" => "KL568251.1",
"chrUn_KL568252v1" => "KL568252.1",
"chrUn_KL568253v1" => "KL568253.1",
"chrUn_KL568254v1" => "KL568254.1",
"chrUn_KL568255v1" => "KL568255.1",
"chrUn_KL568256v1" => "KL568256.1",
"chrUn_KL568257v1" => "KL568257.1",
"chrUn_KL568258v1" => "KL568258.1",
"chrUn_KL568259v1" => "KL568259.1",
"chrUn_KL568260v1" => "KL568260.1",
"chrUn_KL568261v1" => "KL568261.1",
"chrUn_KL568262v1" => "KL568262.1",
"chrUn_KL568263v1" => "KL568263.1",
"chrUn_KL568264v1" => "KL568264.1",
"chrUn_KL568265v1" => "KL568265.1",
"chrUn_KL568266v1" => "KL568266.1",
"chrUn_KL568267v1" => "KL568267.1",
"chrUn_KL568268v1" => "KL568268.1",
"chrUn_KL568269v1" => "KL568269.1",
"chrUn_KL568270v1" => "KL568270.1",
"chrUn_KL568271v1" => "KL568271.1",
"chrUn_KL568272v1" => "KL568272.1",
"chrUn_KL568273v1" => "KL568273.1",
"chrUn_KL568274v1" => "KL568274.1",
"chrUn_KL568275v1" => "KL568275.1",
"chrUn_KL568276v1" => "KL568276.1",
"chrUn_KL568277v1" => "KL568277.1",
"chrUn_KL568278v1" => "KL568278.1",
"chrUn_KL568279v1" => "KL568279.1",
"chrUn_KL568280v1" => "KL568280.1",
"chrUn_KL568281v1" => "KL568281.1",
"chrUn_KL568282v1" => "KL568282.1",
"chrUn_KL568283v1" => "KL568283.1",
"chrUn_KL568284v1" => "KL568284.1",
"chrUn_KL568285v1" => "KL568285.1",
"chrUn_KL568286v1" => "KL568286.1",
"chrUn_KL568287v1" => "KL568287.1",
"chrUn_KL568288v1" => "KL568288.1",
"chrUn_KL568289v1" => "KL568289.1",
"chrUn_KL568290v1" => "KL568290.1",
"chrUn_KL568291v1" => "KL568291.1",
"chrUn_KL568292v1" => "KL568292.1",
"chrUn_KL568293v1" => "KL568293.1",
"chrUn_KL568294v1" => "KL568294.1",
"chrUn_KL568295v1" => "KL568295.1",
"chrUn_KL568296v1" => "KL568296.1",
"chrUn_KL568297v1" => "KL568297.1",
"chrUn_KL568298v1" => "KL568298.1",
"chrUn_KL568299v1" => "KL568299.1",
"chrUn_KL568300v1" => "KL568300.1",
"chrUn_KL568301v1" => "KL568301.1",
"chrUn_KL568302v1" => "KL568302.1",
"chrUn_KL568303v1" => "KL568303.1",
"chrUn_KL568304v1" => "KL568304.1",
"chrUn_KL568305v1" => "KL568305.1",
"chrUn_KL568306v1" => "KL568306.1",
"chrUn_KL568307v1" => "KL568307.1",
"chrUn_KL568308v1" => "KL568308.1",
"chrUn_KL568309v1" => "KL568309.1",
"chrUn_KL568310v1" => "KL568310.1",
"chrUn_KL568311v1" => "KL568311.1",
"chrUn_KL568312v1" => "KL568312.1",
"chrUn_KL568313v1" => "KL568313.1",
"chrUn_KL568314v1" => "KL568314.1",
"chrUn_KL568315v1" => "KL568315.1",
"chrUn_KL568316v1" => "KL568316.1",
"chrUn_KL568317v1" => "KL568317.1",
"chrUn_KL568318v1" => "KL568318.1",
"chrUn_KL568319v1" => "KL568319.1",
"chrUn_KL568320v1" => "KL568320.1",
"chrUn_KL568321v1" => "KL568321.1",
"chrUn_KL568322v1" => "KL568322.1",
"chrUn_KL568323v1" => "KL568323.1",
"chrUn_KL568324v1" => "KL568324.1",
"chrUn_KL568325v1" => "KL568325.1",
"chrUn_KL568326v1" => "KL568326.1",
"chrUn_KL568327v1" => "KL568327.1",
"chrUn_KL568328v1" => "KL568328.1",
"chrUn_KL568329v1" => "KL568329.1",
"chrUn_KL568330v1" => "KL568330.1",
"chrUn_KL568331v1" => "KL568331.1",
"chrUn_KL568332v1" => "KL568332.1",
"chrUn_KL568333v1" => "KL568333.1",
"chrUn_KL568334v1" => "KL568334.1",
"chrUn_KL568335v1" => "KL568335.1",
"chrUn_KL568336v1" => "KL568336.1",
"chrUn_KL568337v1" => "KL568337.1",
"chrUn_KL568338v1" => "KL568338.1",
"chrUn_KL568339v1" => "KL568339.1",
"chrUn_KL568340v1" => "KL568340.1",
"chrUn_KL568341v1" => "KL568341.1",
"chrUn_KL568342v1" => "KL568342.1",
"chrUn_KL568343v1" => "KL568343.1",
"chrUn_KL568344v1" => "KL568344.1",
"chrUn_KL568345v1" => "KL568345.1",
"chrUn_KL568346v1" => "KL568346.1",
"chrUn_KL568347v1" => "KL568347.1",
"chrUn_KL568348v1" => "KL568348.1",
"chrUn_KL568349v1" => "KL568349.1",
"chrUn_KL568350v1" => "KL568350.1",
"chrUn_KL568351v1" => "KL568351.1",
"chrUn_KL568352v1" => "KL568352.1",
"chrUn_KL568353v1" => "KL568353.1",
"chrUn_KL568354v1" => "KL568354.1",
"chrUn_KL568355v1" => "KL568355.1",
"chrUn_KL568356v1" => "KL568356.1",
"chrUn_KL568357v1" => "KL568357.1",
"chrUn_KL568358v1" => "KL568358.1",
"chrUn_KL568359v1" => "KL568359.1",
"chrUn_KL568360v1" => "KL568360.1",
"chrUn_KL568361v1" => "KL568361.1",
"chrUn_KL568362v1" => "KL568362.1",
"chrUn_KL568363v1" => "KL568363.1",
"chrUn_KL568364v1" => "KL568364.1",
"chrUn_KL568365v1" => "KL568365.1",
"chrUn_KL568366v1" => "KL568366.1",
"chrUn_KL568367v1" => "KL568367.1",
"chrUn_KL568368v1" => "KL568368.1",
"chrUn_KL568369v1" => "KL568369.1",
"chrUn_KL568370v1" => "KL568370.1",
"chrUn_KL568371v1" => "KL568371.1",
"chrUn_KL568372v1" => "KL568372.1",
"chrUn_KL568373v1" => "KL568373.1",
"chrUn_KL568374v1" => "KL568374.1",
"chrUn_KL568375v1" => "KL568375.1",
"chrUn_KL568376v1" => "KL568376.1",
"chrUn_KL568377v1" => "KL568377.1",
"chrUn_KL568378v1" => "KL568378.1",
"chrUn_KL568379v1" => "KL568379.1",
"chrUn_KL568380v1" => "KL568380.1",
"chrUn_KL568381v1" => "KL568381.1",
"chrUn_KL568382v1" => "KL568382.1",
"chrUn_KL568383v1" => "KL568383.1",
"chrUn_KL568384v1" => "KL568384.1",
"chrUn_KL568385v1" => "KL568385.1",
"chrUn_KL568386v1" => "KL568386.1",
"chrUn_KL568387v1" => "KL568387.1",
"chrUn_KL568388v1" => "KL568388.1",
"chrUn_KL568389v1" => "KL568389.1",
"chrUn_KL568390v1" => "KL568390.1",
"chrUn_KL568391v1" => "KL568391.1",
"chrUn_KL568392v1" => "KL568392.1",
"chrUn_KL568393v1" => "KL568393.1",
"chrUn_KL568394v1" => "KL568394.1",
"chrUn_KL568395v1" => "KL568395.1",
"chrUn_KL568396v1" => "KL568396.1",
"chrUn_KL568397v1" => "KL568397.1",
"chrUn_KL568398v1" => "KL568398.1",
"chrUn_KL568399v1" => "KL568399.1",
"chrUn_KL568400v1" => "KL568400.1",
"chrUn_KL568401v1" => "KL568401.1",
"chrUn_KL568402v1" => "KL568402.1",
"chrUn_KL568403v1" => "KL568403.1",
"chrUn_KL568404v1" => "KL568404.1",
"chrUn_KL568405v1" => "KL568405.1",
"chrUn_KL568406v1" => "KL568406.1",
"chrUn_KL568407v1" => "KL568407.1",
"chrUn_KL568408v1" => "KL568408.1",
"chrUn_KL568409v1" => "KL568409.1",
"chrUn_KL568410v1" => "KL568410.1",
"chrUn_KL568411v1" => "KL568411.1",
"chrUn_KL568412v1" => "KL568412.1",
"chrUn_KL568413v1" => "KL568413.1",
"chrUn_KL568414v1" => "KL568414.1",
"chrUn_KL568415v1" => "KL568415.1",
"chrUn_KL568416v1" => "KL568416.1",
"chrUn_KL568417v1" => "KL568417.1",
"chrUn_KL568418v1" => "KL568418.1",
"chrUn_KL568419v1" => "KL568419.1",
"chrUn_KL568420v1" => "KL568420.1",
"chrUn_KL568421v1" => "KL568421.1",
"chrUn_KL568422v1" => "KL568422.1",
"chrUn_KL568423v1" => "KL568423.1",
"chrUn_KL568424v1" => "KL568424.1",
"chrUn_KL568425v1" => "KL568425.1",
"chrUn_KL568426v1" => "KL568426.1",
"chrUn_KL568427v1" => "KL568427.1",
"chrUn_KL568428v1" => "KL568428.1",
"chrUn_KL568429v1" => "KL568429.1",
"chrUn_KL568430v1" => "KL568430.1",
"chrUn_KL568431v1" => "KL568431.1",
"chrUn_KL568432v1" => "KL568432.1",
"chrUn_KL568433v1" => "KL568433.1",
"chrUn_KL568434v1" => "KL568434.1",
"chrUn_KL568435v1" => "KL568435.1",
"chrUn_KL568436v1" => "KL568436.1",
"chrUn_KL568437v1" => "KL568437.1",
"chrUn_KL568438v1" => "KL568438.1",
"chrUn_KL568439v1" => "KL568439.1",
"chrUn_KL568440v1" => "KL568440.1",
"chrUn_KL568441v1" => "KL568441.1",
"chrUn_KL568442v1" => "KL568442.1",
"chrUn_KL568443v1" => "KL568443.1",
"chrUn_KL568444v1" => "KL568444.1",
"chrUn_KL568445v1" => "KL568445.1",
"chrUn_KL568446v1" => "KL568446.1",
"chrUn_KL568447v1" => "KL568447.1",
"chrUn_KL568448v1" => "KL568448.1",
"chrUn_KL568449v1" => "KL568449.1",
"chrUn_KL568450v1" => "KL568450.1",
"chrUn_KL568451v1" => "KL568451.1",
"chrUn_KL568452v1" => "KL568452.1",
"chrUn_KL568453v1" => "KL568453.1",
"chrUn_KL568454v1" => "KL568454.1",
"chrUn_KL568455v1" => "KL568455.1",
"chrUn_KL568456v1" => "KL568456.1",
"chrUn_KL568457v1" => "KL568457.1",
"chrUn_KL568458v1" => "KL568458.1",
"chrUn_KL568459v1" => "KL568459.1",
"chrUn_KL568460v1" => "KL568460.1",
"chrUn_KL568461v1" => "KL568461.1",
"chrUn_KL568462v1" => "KL568462.1",
"chrUn_KL568463v1" => "KL568463.1",
"chrUn_KL568464v1" => "KL568464.1",
"chrUn_KL568465v1" => "KL568465.1",
"chrUn_KL568466v1" => "KL568466.1",
"chrUn_KL568467v1" => "KL568467.1",
"chrUn_KL568468v1" => "KL568468.1",
"chrUn_KL568469v1" => "KL568469.1",
"chrUn_KL568470v1" => "KL568470.1",
"chrUn_KL568471v1" => "KL568471.1",
"chrUn_KL568472v1" => "KL568472.1",
"chrUn_KL568473v1" => "KL568473.1",
"chrUn_KL568474v1" => "KL568474.1",
"chrUn_KL568475v1" => "KL568475.1",
"chrUn_KL568476v1" => "KL568476.1",
"chrUn_KL568477v1" => "KL568477.1",
"chrUn_KL568478v1" => "KL568478.1",
"chrUn_KL568479v1" => "KL568479.1",
"chrUn_KL568480v1" => "KL568480.1",
"chrUn_KL568481v1" => "KL568481.1",
"chrUn_KL568482v1" => "KL568482.1",
"chrUn_KL568483v1" => "KL568483.1",
"chrUn_KL568484v1" => "KL568484.1",
"chrUn_KL568485v1" => "KL568485.1",
"chrUn_KL568486v1" => "KL568486.1",
"chrUn_KL568487v1" => "KL568487.1",
"chrUn_KL568488v1" => "KL568488.1",
"chrUn_KL568489v1" => "KL568489.1",
"chrUn_KL568490v1" => "KL568490.1",
"chrUn_KL568491v1" => "KL568491.1",
"chrUn_KL568492v1" => "KL568492.1",
"chrUn_KL568493v1" => "KL568493.1",
"chrUn_KL568494v1" => "KL568494.1",
"chrUn_KL568495v1" => "KL568495.1",
"chrUn_KL568496v1" => "KL568496.1",
"chrUn_KL568497v1" => "KL568497.1",
"chrUn_KL568498v1" => "KL568498.1",
"chrUn_KL568499v1" => "KL568499.1",
"chrUn_KL568500v1" => "KL568500.1",
"chrUn_KL568501v1" => "KL568501.1",
"chrUn_KL568502v1" => "KL568502.1",
"chrUn_KL568503v1" => "KL568503.1",
"chrUn_KL568504v1" => "KL568504.1",
"chrUn_KL568505v1" => "KL568505.1",
"chrUn_KL568506v1" => "KL568506.1",
"chrUn_KL568507v1" => "KL568507.1",
"chrUn_KL568508v1" => "KL568508.1",
"chrUn_KL568509v1" => "KL568509.1",
"chrUn_KL568510v1" => "KL568510.1",
"chrUn_KL568511v1" => "KL568511.1",
"chrUn_KL568512v1" => "KL568512.1",
"chrUn_KL568513v1" => "KL568513.1",
"chrUn_KL568514v1" => "KL568514.1",
"chrUn_KL568515v1" => "KL568515.1",
"chrUn_KL568516v1" => "KL568516.1",
"chrUn_KL568517v1" => "KL568517.1",
"chrUn_KL568518v1" => "KL568518.1",
"chrM" => "MT",
"chrX" => "X",
"chrY" => "Y",
};

our $u2e_mappings = {
    134 => $u2e_mapping_mouse,
    155 => $u2e_mapping_rat,
};

our $e2u_mappings = {
    134 => {reverse %$u2e_mapping_mouse},
    155 => {reverse %$u2e_mapping_rat},
};

sub load_mapping_from_mlss {
    my ($mlss) = @_;

    return if $mlss->{'_chromosome_mapping_loaded'};

    my $alt_syn_tag = $mlss->get_value_for_tag('alt_synonyms', '{}');
    my $alt_synonyms = eval $alt_syn_tag;
    foreach my $genome_db (@{$mlss->species_set->genome_dbs}) {
        my $genome_db_id = $genome_db->dbID;
        $e2u_mappings->{$genome_db_id} = {} unless exists $e2u_mappings->{$genome_db_id};
        $u2e_mappings->{$genome_db_id} = {} unless exists $u2e_mappings->{$genome_db_id};
        next unless $alt_synonyms->{$genome_db_id};
        foreach my $dnafrag_name (keys %{$alt_synonyms->{$genome_db_id}}) {
            my $alt_name = $alt_synonyms->{$genome_db_id}->{$dnafrag_name};
            $e2u_mappings->{$genome_db_id}->{ $dnafrag_name } = $alt_name;
            $u2e_mappings->{$genome_db_id}->{ $alt_name } = $dnafrag_name;
        }
    }
    $mlss->{'_chromosome_mapping_loaded'} = 1;
}

1;
