/*
 * Decompiled with CFR 0.152.
 */
package apollo.util;

public class QuickSort {
    public static void sort(double[] dArray, Object[] objectArray) {
        QuickSort.doubleSort(dArray, 0, dArray.length - 1, objectArray);
    }

    public static void sort(double[] dArray, Object[] objectArray, int n) {
        QuickSort.doubleSort(dArray, 0, n - 1, objectArray);
    }

    public static void sort(float[] fArray, Object[] objectArray) {
        QuickSort.sort(fArray, 0, fArray.length - 1, objectArray);
    }

    public static void sort(long[] lArray, Object[] objectArray) {
        QuickSort.longSort(lArray, 0, lArray.length - 1, objectArray);
    }

    public static void sort(String[] stringArray, Object[] objectArray) {
        QuickSort.stringSort(stringArray, 0, stringArray.length - 1, objectArray);
    }

    public static void sort(int[] nArray, Object[] objectArray) {
        QuickSort.intSort(nArray, 0, nArray.length - 1, objectArray);
    }

    public static void reverse(Object[] objectArray) {
        int n = objectArray.length;
        if (n > 0) {
            int n2 = n % 2 > 0 ? (n - 1) / 2 : n / 2;
            --n;
            for (int i = 0; i < n2; ++i) {
                Object object = objectArray[i];
                objectArray[i] = objectArray[n - i];
                objectArray[n - i] = object;
            }
        }
    }

    public static void stringSort(String[] stringArray, int n, int n2, Object[] objectArray) {
        if (n < n2) {
            int n3 = QuickSort.stringPartition(stringArray, n, n2, objectArray);
            QuickSort.stringSort(stringArray, n, n3, objectArray);
            QuickSort.stringSort(stringArray, n3 + 1, n2, objectArray);
        }
    }

    public static void intSort(int[] nArray, int n, int n2, Object[] objectArray) {
        if (n < n2) {
            int n3 = QuickSort.intPartition(nArray, n, n2, objectArray);
            QuickSort.intSort(nArray, n, n3, objectArray);
            QuickSort.intSort(nArray, n3 + 1, n2, objectArray);
        }
    }

    public static void longSort(long[] lArray, int n, int n2, Object[] objectArray) {
        if (n < n2) {
            int n3 = QuickSort.longPartition(lArray, n, n2, objectArray);
            QuickSort.longSort(lArray, n, n3, objectArray);
            QuickSort.longSort(lArray, n3 + 1, n2, objectArray);
        }
    }

    public static void sort(float[] fArray, int n, int n2, Object[] objectArray) {
        if (n < n2) {
            int n3 = QuickSort.partition(fArray, n, n2, objectArray);
            QuickSort.sort(fArray, n, n3, objectArray);
            QuickSort.sort(fArray, n3 + 1, n2, objectArray);
        }
    }

    public static void doubleSort(double[] dArray, int n, int n2, Object[] objectArray) {
        if (n < n2) {
            int n3 = QuickSort.doublePartition(dArray, n, n2, objectArray);
            QuickSort.doubleSort(dArray, n, n3, objectArray);
            QuickSort.doubleSort(dArray, n3 + 1, n2, objectArray);
        }
    }

    private static int doublePartition(double[] dArray, int n, int n2, Object[] objectArray) {
        double d = dArray[n];
        int n3 = n - 1;
        int n4 = n2 + 1;
        while (true) {
            if (dArray[--n4] > d) {
                continue;
            }
            while (dArray[++n3] < d) {
            }
            if (n3 >= n4) break;
            double d2 = dArray[n3];
            dArray[n3] = dArray[n4];
            dArray[n4] = d2;
            Object object = objectArray[n3];
            objectArray[n3] = objectArray[n4];
            objectArray[n4] = object;
        }
        return n4;
    }

    private static int partition(float[] fArray, int n, int n2, Object[] objectArray) {
        float f = fArray[n];
        int n3 = n - 1;
        int n4 = n2 + 1;
        while (true) {
            if (fArray[--n4] > f) {
                continue;
            }
            while (fArray[++n3] < f) {
            }
            if (n3 >= n4) break;
            float f2 = fArray[n3];
            fArray[n3] = fArray[n4];
            fArray[n4] = f2;
            Object object = objectArray[n3];
            objectArray[n3] = objectArray[n4];
            objectArray[n4] = object;
        }
        return n4;
    }

    private static int longPartition(long[] lArray, int n, int n2, Object[] objectArray) {
        float f = lArray[n];
        int n3 = n - 1;
        int n4 = n2 + 1;
        while (true) {
            if ((float)lArray[--n4] > f) {
                continue;
            }
            while ((float)lArray[++n3] < f) {
            }
            if (n3 >= n4) break;
            long l = lArray[n3];
            lArray[n3] = lArray[n4];
            lArray[n4] = l;
            Object object = objectArray[n3];
            objectArray[n3] = objectArray[n4];
            objectArray[n4] = object;
        }
        return n4;
    }

    private static int intPartition(int[] nArray, int n, int n2, Object[] objectArray) {
        int n3 = nArray[n];
        int n4 = n - 1;
        int n5 = n2 + 1;
        while (true) {
            if (nArray[--n5] > n3) {
                continue;
            }
            while (nArray[++n4] < n3) {
            }
            if (n4 >= n5) break;
            int n6 = nArray[n4];
            nArray[n4] = nArray[n5];
            nArray[n5] = n6;
            Object object = objectArray[n4];
            objectArray[n4] = objectArray[n5];
            objectArray[n5] = object;
        }
        return n5;
    }

    private static int stringPartition(String[] stringArray, int n, int n2, Object[] objectArray) {
        String string = stringArray[n];
        int n3 = n - 1;
        int n4 = n2 + 1;
        while (true) {
            if (stringArray[--n4].compareTo(string) < 0) {
                continue;
            }
            while (stringArray[++n3].compareTo(string) > 0) {
            }
            if (n3 >= n4) break;
            String string2 = stringArray[n3];
            stringArray[n3] = stringArray[n4];
            stringArray[n4] = string2;
            Object object = objectArray[n3];
            objectArray[n3] = objectArray[n4];
            objectArray[n4] = object;
        }
        return n4;
    }
}

