/*
 * Decompiled with CFR 0.152.
 */
package apollo.seq.io;

import apollo.datamodel.FeaturePair;
import apollo.datamodel.SeqFeature;
import apollo.io.FileParse;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class GFFFile
extends FileParse {
    int noSeqs;
    int maxLength = 0;
    public Vector<SeqFeature> seqs = new Vector();
    long start;
    long end;

    public GFFFile(String string, String string2) throws IOException {
        super(string, string2);
        System.err.println("Reading Ensembl-style GFF file " + string + "....");
        this.start = System.currentTimeMillis();
        this.readLines();
        this.end = System.currentTimeMillis();
        this.start = System.currentTimeMillis();
        this.parse();
    }

    public void parse() {
        for (int i = 0; i < this.lineArray.size(); ++i) {
            StringTokenizer stringTokenizer;
            String string = (String)this.lineArray.elementAt(i);
            if (string.indexOf("#") != -1 || (stringTokenizer = new StringTokenizer(string, "\t")).countTokens() < 8) continue;
            try {
                String string2;
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                int n = Integer.parseInt(stringTokenizer.nextToken());
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                double d = 0.0;
                try {
                    d = Double.valueOf(stringTokenizer.nextToken());
                }
                catch (Exception exception) {
                    System.err.println("Error parsing score : " + exception);
                }
                String string6 = stringTokenizer.nextToken();
                String string7 = stringTokenizer.nextToken();
                String string8 = string5;
                SeqFeature seqFeature = new SeqFeature(n, n2, string8);
                if (string6.equals("-")) {
                    seqFeature.setStrand(-1);
                } else {
                    seqFeature.setStrand(1);
                }
                seqFeature.setFeatureType(string4);
                seqFeature.setName(string3);
                seqFeature.setId(string3);
                if (stringTokenizer.hasMoreTokens() && string5.equals("similarity")) {
                    try {
                        string2 = stringTokenizer.nextToken("");
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
                        String string9 = stringTokenizer2.nextToken();
                        int n3 = Integer.parseInt(stringTokenizer2.nextToken());
                        int n4 = Integer.parseInt(stringTokenizer2.nextToken());
                        int n5 = 0;
                        SeqFeature seqFeature2 = null;
                        if (n3 < n4) {
                            n5 = 1;
                            seqFeature2 = new SeqFeature(n3, n4, string9, n5);
                        } else {
                            n5 = -1;
                            seqFeature2 = new SeqFeature(n4, n3, string9, n5);
                        }
                        seqFeature2.setName(string9);
                        seqFeature2.setId(string9);
                        seqFeature.setId(string9);
                        FeaturePair featurePair = new FeaturePair(seqFeature, seqFeature2);
                        this.seqs.addElement(featurePair);
                    }
                    catch (Exception exception) {
                        System.err.println("Can't add line - " + string + " " + exception);
                    }
                    continue;
                }
                if (stringTokenizer.hasMoreTokens() && string5.equals("exon")) {
                    string2 = stringTokenizer.nextToken("\t");
                    seqFeature.setName(string2);
                    seqFeature.setId(string2);
                    this.seqs.addElement(seqFeature);
                    continue;
                }
                if (string5.equals("intron") || string5.equals("sequence") || string5.equals("coding_exon")) continue;
                this.seqs.addElement(seqFeature);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("NumberFormatException " + numberFormatException);
                System.err.println("ERROR: parsing line " + string);
            }
        }
        this.noSeqs = this.seqs.size();
    }
}

