/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

public class Range {
    protected int low = -1;
    protected int high = -1;
    protected byte strand = 0;
    protected String name = null;
    protected String type = null;

    public Range() {
    }

    public Range(int n, int n2) {
        this(null, n, n2);
    }

    public Range(String string, int n, int n2) {
        this.setName(string);
        this.setStrand(n <= n2 ? 1 : -1);
        this.setStart(n);
        this.setEnd(n2);
    }

    public boolean isIdentical(Range range) {
        if (this == range) {
            return true;
        }
        return range.getFeatureType().equals(this.getFeatureType()) && this.sameRange(range) && range.getName().equals(this.getName());
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasName() {
        return this.name != null && !this.name.equals("");
    }

    public String getFeatureType() {
        return this.type;
    }

    public void setFeatureType(String string) {
        if (string == null) {
            throw new NullPointerException("Range.setFeatureType: can't accept feature type of null. Use SeqFeature.NO_TYPE or 'SeqFeature.NO_TYPE' instead.");
        }
        if (!string.equals("")) {
            this.type = string;
        }
    }

    public boolean hasFeatureType() {
        return this.getFeatureType() != null;
    }

    public int getStrand() {
        return this.strand;
    }

    public boolean isForwardStrand() {
        return this.getStrand() == 1;
    }

    public void setStrand(int n) {
        this.strand = (byte)n;
    }

    public void setStart(int n) {
        if (this.getStrand() == -1) {
            this.high = n;
        } else {
            this.low = n;
        }
    }

    public int getStart() {
        return this.getStrand() == -1 ? this.high : this.low;
    }

    public void setEnd(int n) {
        if (this.getStrand() == -1) {
            this.low = n;
        } else {
            this.high = n;
        }
    }

    public int getEnd() {
        return this.getStrand() == -1 ? this.low : this.high;
    }

    public int getLow() {
        return this.low;
    }

    public void setLow(int n) {
        this.low = n;
    }

    public int getHigh() {
        return this.high;
    }

    public void setHigh(int n) {
        this.high = n;
    }

    public String getStartAsString() {
        return String.valueOf(new Integer(this.getStart()));
    }

    public String getEndAsString() {
        return String.valueOf(new Integer(this.getEnd()));
    }

    public int getLeftOverlap(Range range) {
        return this.getLow() - range.getLow();
    }

    public int getRightOverlap(Range range) {
        return range.getHigh() - this.getHigh();
    }

    public boolean isExactOverlap(Range range) {
        return this.getLeftOverlap(range) == 0 && this.getRightOverlap(range) == 0 && this.getStrand() == range.getStrand();
    }

    public boolean contains(Range range) {
        return this.overlaps(range) && this.getLeftOverlap(range) <= 0 && this.getRightOverlap(range) <= 0 && this.getStrand() == range.getStrand();
    }

    public boolean contains(int n) {
        return n >= this.getLow() && n <= this.getHigh();
    }

    public boolean overlaps(Range range) {
        return this.getLow() <= range.getHigh() && this.getHigh() >= range.getLow() && this.getStrand() == range.getStrand();
    }

    public boolean sameRange(Range range) {
        return this.getStart() == range.getStart() && this.getEnd() == range.getEnd();
    }

    public int length() {
        return this.getHigh() - this.getLow() + 1;
    }

    public boolean canHaveChildren() {
        return false;
    }

    public boolean rangeIsUnassigned() {
        return this.low == -1 && this.high == -1;
    }

    public void convertFromBaseOrientedToInterbase() {
        --this.low;
    }

    public void convertFromInterbaseToBaseOriented() {
        ++this.low;
    }

    public String toString() {
        return "Range[name=" + this.name + ",type=" + this.type + ",low=" + this.low + ",high=" + this.high + ",strand=" + this.strand + "]";
    }
}

