require_dependency 'issue'

# imitated from Eric Davis' code & wisdom

module IssuePatch
  def self.included(base) # :nodoc:
    base.extend(InstanceMethods)

    base.send(:include, InstanceMethods)

    base.class_eval do
      unloadable # Send unloadable so it will not be unloaded in development
    end
 
  end
  
  module ClassMethods

  end


  module InstanceMethods

    def resolve_flag
      redirect_to :action => 'show', :id => @issue
    end


    def get_annotation_stats
      annotation_stats = Hash.new{ |hash,key| hash[key] = Hash.new(0) }
      biotypecount = Hash.new(0)
      chromosomes = Array.new(0)

      #get all chromosomes
      h_chroms = Issue.find(:all, :select => "Tchrom",
                            :conditions => ["category_id=1"], :group => 'Tchrom')

      h_chroms.each do |chrom|
        #store chromosome name
        chromosomes.push(chrom.Tchrom)
        #count biotypes on chromosome
        h_issues = Issue.find_by_sql(['select count(*) as counter, cv.value as biotype from issues i, custom_values cv where i.id=cv.customized_id and cv.customized_type="Issue" and i.category_id=1 and i.active=1 and cv.custom_field_id=8 and i.Tchrom=? group by cv.value order by biotype', chrom.Tchrom])
        h_issues.each do |h|
          annotation_stats[chrom.Tchrom.to_s][h.biotype] = h.counter
        end
      end

      chromosomes = chromosomes.sort{|a, b| 
        if(!((a =~ /\d+/).nil?))
          if(!((b =~ /\d+/).nil?))
            a.to_i <=> b.to_i
          else
            -1
          end
        else
          if(!((b =~ /\d+/).nil?))
            1
          else
            a <=> b
          end
        end
      }
      #get different biotypes
      h_biotypes = Issue.find_by_sql(['select count(*) as counter, cv.value as biotype from issues i, custom_values cv where i.id=cv.customized_id and cv.customized_type="Issue" and i.category_id=1 and i.active=1 and cv.custom_field_id=8 group by cv.value order by cv.value'])
      h_biotypes.each do |c|
        biotypecount[c.biotype] = c.counter
      end

      return[annotation_stats, biotypecount, chromosomes]
    end

  end

end

# Add module to Issue
Issue.send(:include, IssuePatch)
