
=head1 NAME

gencode_tracking_system / export_data

=head1 DESCRIPTION

Helper script for the GENCODE tracking system
to export specific data sets with sequence.


=head1 CONTACT

Felix Kokocinski, fsk@sanger.ac.uk

=head1 COPYRIGHT

Copyright Felix Kokocinski, 2008-2010, 
supported by Wellcome Trust Sanger Institute (UK) 
and National Human Genome Research Institute (USA).

You may distribute this module under the same terms as perl itself, 
citing the original source.

=cut

#TODO: needs work!

use strict;
use warnings;
#use Getopt::Long;
use gencode_tracking_system::core;
use gencode_tracking_system::config;
use Text::Wrap;
$Text::Wrap::columns = 50;

#my $current_gene_id;
#my $current_transcript_id;
#my $current_feature_id;
#my $current_gene_description;
#my $das_source;

#read ids from file
my $file = "/nfs/acari/fsk/1_cvs/gencode/tracking_system/perl/congo_overlapping_non_codings.moreids";
my $get_seq = 1;
my $user_name = "trackingsystem";

#connect to loutre
my $hdbhost     = "otterlive";
my $hdbport     = 3301;
my $hdbname     = "loutre_human";
my $hdbuser     = "ottro";
my $hdbpass;
my $h_db        = connect_ensembl($hdbhost, $hdbport, $hdbname, $hdbuser, $hdbpass);
my $h_ta        = $h_db->get_TranscriptAdaptor();
my $h_ga        = $h_db->get_GeneAdaptor();
if($h_db && $VERBOSE){ print "Conected to loutre\n" }

#connect to tracking system db
my $tracking_dbh = connect_db($DBHOST, $DBPORT, $DBNAME, $DBUSER, $DBPASS)
  or die "cant connect to to database $DBNAME @ $DBHOST.\n";
if($tracking_dbh && $VERBOSE){ print "Conected to $DBNAME @ $DBHOST.\n" }

#connect to ensembl db
my $ens_db = connect_ensembl($ENS_HOST, $ENS_PORT, $ENS_NAME, $ENS_USER, $ENS_PASS);
my $ens_ta = $ens_db->get_TranscriptAdaptor();
my $ens_ga = $ens_db->get_GeneAdaptor();
if($ens_db && $VERBOSE){ print "Conected to ensembl\n" }

#Havana category
my $havana_category_id = get_category_id( $OTTER_DAS_SERVER{'havana'}->{'category'}, $tracking_dbh );
#system user
my $user_id = get_user_id( $user_name, $tracking_dbh );

my $flag_name = "overlapping_cds";

print "Looking for flag $flag_name... ";
#get specific unresolved flags (from flags table)
my $flags = get_flag($tracking_dbh, undef, $flag_name, undef, undef, 'no');

if(!scalar @$flags){
  print "Nottin found\n";
  exit 0;
}
else{
  print " Found ".(scalar @$flags)." flags.\n";
}

#find all issues with the flag
foreach my $flag (@$flags){
  my $object = get_data_by_id($tracking_dbh, "transcript", $flag->{'issue_id'});
  if($object){
    my $header = ">".$object->{'name'}."|NCBI36:".$object->{'chromosome'}.":".$object->{'start'}.":".
      $object->{'end'}.":".$object->{'strand'};
    my $transcript = $h_ta->fetch_by_stable_id($object->{'name'});
    my $gen_seq = wrap('', '', $transcript->seq->seq);
    if($header && $gen_seq){
      print $header."\n".$gen_seq."\n";
    }
  }
  last; #########
}


__END__

      %object = (
		 'id'          => $dbid,
		 'name'        => $name,
		 'description' => $description,
		 'created'     => $created_on,
		 'updated'     => $updated_on,
		 'chromosome'  => $chrom,
		 'start'       => $start,
		 'end'         => $end,
		 'strand'      => $strand,
		);
