=head1 NAME

gencode_tracking_system:::sources::fetch_from_db

=head1 DESCRIPTION

Example script for the GENCODE tracking system.

Connects to a (mysql) database, constructs and stores entries to tracking system.

=head1 CONTACT

Felix Kokocinski, fsk@sanger.ac.uk

=head1 COPYRIGHT

Copyright Felix Kokocinski, 2008-2010, 
supported by Wellcome Trust Sanger Institute (UK) 
and National Human Genome Research Institute (USA).

Released under GPL v2.

=cut

package gencode_tracking_system::sources::fetch_from_db;

use strict;
use warnings;
use gencode_tracking_system::core;
use gencode_tracking_system::config;
use base 'Exporter';

our @EXPORT = qw( run_update );

my ($tracking_dbh, $prepare_hash, $user_id, $category_id, $das_source);
my $g_features    = 0;
my $t_features    = 0;

sub run_update {
  ($tracking_dbh, $prepare_hash, $user_id, $category_id, $das_source) = @_;

  #connect to database specified in config, use method from the core module
  my $dbhost = $OTHER_SERVERS{$das_source}->{'dbhost'};
  my $dbport = $OTHER_SERVERS{$das_source}->{'dbport'};
  my $dbname = $OTHER_SERVERS{$das_source}->{'dbname'};
  my $dbuser = $OTHER_SERVERS{$das_source}->{'dbuser'};
  my $dbpass = $OTHER_SERVERS{$das_source}->{'dbpass'};

  my $database = connect_db($dbhost, $dbport, $dbname, $dbuser, $dbpass);

  #example queries to fetch genes and transcripts
  my $sth_1 = $database->prepare("SELECT chromosome, start, end, strand, status, type, id, name FROM gene_table where category=?");
  my $sth_2 = $database->prepare("SELECT chromosome, start, end, strand, status, type, id, name FROM transcript_table where gene_id=?");
  my $category = "protein_coding_genes";

  $sth_1->execute($category);

  #go through result set and store genes
  while (my ($gene_chrom, $gene_start, $gene_end, $gene_strand, $gene_status, $gene_type,
	     $gene_id, $gene_name) = fetchrow_array()){

    #build structure for gene
    my %gene;
    $gene{'seqid'}        = $gene_chrom;
    $gene{'biotype'}      = $gene_type;
    $gene{'status'}       = $gene_status;
    $gene{'type'}         = "gene";
    $gene{'start'}        = $gene_start;
    $gene{'end'}          = $gene_end;
    $gene{'strand'}       = $gene_strand;
    $gene{'id'}           = $gene_id;
    $gene{'description'}  = $gene_name;

    #show gene
    if($VERBOSE){
      print STDERR "GENE:\n";
      print_element(\%gene);
    }
    #store gene
    my $current_gene_id = store_features($tracking_dbh, $prepare_hash, \%gene, 'gene',
				      0, 0, $user_id, $category_id);
    $g_features++;

    #get all transcripts of this gene
    $sth_2->execute($gene_id);

    #go through result set and store transcripts
    while (my ($transcript_chrom, $transcript_start, $transcript_end, $transcript_strand,
	       $transcript_status, $transcript_type, $transcript_id, $transcript_name) = fetchrow_array()){

      #build structure for transcript
      my %transcript;
      $transcript{'seqid'}        = $transcript_chrom;
      $transcript{'biotype'}      = $transcript_type;
      $transcript{'status'}       = $transcript_status;
      $transcript{'type'}         = "transcript";
      $transcript{'start'}        = $transcript_start;
      $transcript{'end'}          = $transcript_end;
      $transcript{'strand'}       = $transcript_strand;
      $transcript{'id'}           = $transcript_id;
      $transcript{'description'}  = $transcript_name;

      #show transcript
      if($VERBOSE){
	print STDERR "TRANSCRIPT:\n";
	print_element(\%transcript);
      }
      #store transcript
      my $current_transcript_id = store_features($tracking_dbh, $prepare_hash, \%transcript, 'transcript',
						 $current_gene_id, 0, $user_id, $category_id);
      $t_features++;
    }
  }

  print STDERR "Found $g_features gene features and $t_features transcript features.\n" if($VERBOSE);
}


1;

