class WelcomeController < ApplicationController

  def welcome_addons
    #AnnoTrack: load additional values

    @projectname = Setting.app_title

    #get issue description
    @category_description = {}
    raw = ActiveRecord::Base.connection.select_all("select name as name, description as descr  
                         from issue_categories 
                         where name !='TrackT';")
    raw ||=[]
    raw.each do |r|
      @category_description[ r['name'].to_s ] = r['descr'].to_s
    end

    #count different issue categories
    @category_count = Hash.new()
    issue_categories = TmpValue.find(:all, :conditions => ['field_group = ?', "issue_category"])
    issue_categories.each do |issue_category|
      if((issue_category.field_value) and (issue_category.field_value.to_i > 0))
	@category_count[issue_category.field_name] = issue_category.field_value
      end
    end

    #count unresolved flags
    @open_flag_count = 0
    open_flag = TmpValue.find_by_field_name("unresolved_flags")
    if(!open_flag.nil?)
      @open_flag_count = open_flag.field_value
    end

    #count resolved flags
    @resolved_flag_count = 0
    resolved_flags = TmpValue.find_by_field_name("resolved_flags")
    if(!resolved_flags.nil?)
      @resolved_flag_count = resolved_flags.field_value
    end

    #count flag categories
    @flag_details = Hash.new()
    flag_categories = TmpValue.find(:all, :conditions => ['field_group = ?', "flags"])
    flag_categories.each do |flag_category|
       if((flag_category.field_value) and (flag_category.field_value.to_i > 0))
	 @flag_details[flag_category.field_name] = flag_category.field_value
       end
    end

    #get urgent queries
    @urgent_queries = Hash.new()
    queries = TmpValue.find(:all, :conditions => ['field_group = ?', "queries"])
    if(!queries.nil?)
      queries.each do |query|
        @urgent_queries[query.field_name.to_s] = query.field_value.to_s
      end
    end

  end
end
