=head1 NAME

gencode_tracking_system:::sources::tab_file

=head1 DESCRIPTION

Helper script for the GENCODE tracking system, to be run nightly.

Read tabl-delimited file, store in internal tracking system db

 example:
   AK094771	21	36399049	36403858	Missing, one EST support


=head1 CONTACT

Felix Kokocinski, fsk@sanger.ac.uk

=head1 COPYRIGHT

Copyright Felix Kokocinski, 2008-2010, 
supported by Wellcome Trust Sanger Institute (UK) 
and National Human Genome Research Institute (USA).

Released under GPL v2.

=cut

package gencode_tracking_system::sources::tab_file;

use strict;
use warnings;
use gencode_tracking_system::core;
use gencode_tracking_system::config;
use base 'Exporter';

our @EXPORT = qw( run_update );

my ($tracking_dbh, $prepare_hash, $user_id, $category_id, $das_source);
my $features    = 0;
my $gene_status = 'new';

sub run_update {
  ($tracking_dbh, $prepare_hash, $user_id, $category_id, $das_source) = @_;

  #TODO: load dynamically
  my $gene_type   = 'bidirectional regions';

  my $file        = $OTHER_SERVERS{$das_source}->{'file'};
  print STDERR "Using file $file\n";

  my ($current_gene_id, $current_transcript_id);

  #open data file
  open(IN, "<$file") or die "cant open file $file!\n";

  #go through file, read and store data as genes & transcripts
  while (my $line = <IN>){
    chomp $line;
    my ($accession, $chrom, $start, $end, $remarks) = split("\t", $line);

    my %transcript;
    $current_transcript_id = 0;

    #build structure for transcript
    $transcript{'chrom'}        = $chrom;
    $transcript{'biotype'}      = $gene_type;
    $transcript{'status'}       = $gene_status;
    $transcript{'type'}         = "transcript";
    $transcript{'start'}        = $start;
    $transcript{'end'}          = $end;
    $transcript{'strand'}       = '+';
    $transcript{'id'}           = $accession;
    $transcript{'description'}  = $remarks;

    #clone gene from transcript
    my %gene = %transcript;

    #store gene
    if($VERBOSE){
      print STDERR "GENE:\n";
      print_element(\%gene);
    }
    $gene{'type'} = "gene";
    $current_gene_id = store_features($tracking_dbh, $prepare_hash, \%gene, 'gene',
				      0, 0, $user_id, $category_id);

    #store transcript
    if($VERBOSE){
      print STDERR "TRANSCRIPT:\n";
      print_element(\%transcript);
    }
    $current_transcript_id = store_features($tracking_dbh, $prepare_hash, \%transcript, 'transcript',
					    $current_gene_id, 0, $user_id, $category_id);

    $features++;
  }

  print STDERR "Have ".$features." features.\n" if($VERBOSE);
}


1;

