class FlagsController < ApplicationController
  layout 'base'
  require 'csv'

  before_filter :retrieve_flags, :only => [ :retrieve_csv ]

  # get stats about flags and how they were resolved
  def flag_stats
     if(!defined?(@resulthash))
       @resulthash = Flag.get_stats
     end
     @resolved_flag_count = @resulthash['resolved']
     @total_flag_hash = @resulthash['total']
     @resolved_flag_hash = @resulthash['hash']
     @expander = 'none'
     if( defined?(params[:expand]) and params[:expand]=="1" )
       # logger.debug(">>>>is defined")
       @expander = 'block'
     end
  end

  def general_stats
  end

  # get general stats about the core annotation
  def annotation_stats
    if(!defined?(@annotationstats))
      @annotationstats, @biotypecount, @chromsomes = Issue.get_annotation_stats
    end
  end

  # list flags
  def index
    @flags = Flag.find(:all)
    @flag_num = @flags.size
    @flags = []

    respond_to do |format|
      format.html # index.html.erb
      format.xml  { render :xml => @flags }
    end
  end


  # list flags by transcript
  def show
    @flag = Flag.find(params[:id])

    respond_to do |format|
      format.html # show.html.erb
      format.xml  { render :xml => @flag }
    end
  end

  # show VERIFY flags
  def show_tecs
    @state = "all"
    @tecs = Array.new()
    flagname = "verify"
    fields = Array.new()
    fields = ['id','flag_name','issue_name','issue_id','issue_version','first_name','last_name','sel_remark','created_date','done']
    raw = NIL
    if(defined?(params[:done]) and !params[:done].nil?)
      if(params[:done] == 1)
        @state = "1"
      else
        @state = "0"
      end
      raw = Flag.find_by_sql(["select t.id as id, f.flag_name as flag_name, t.issue_name as issue_name, t.issue_id as issue_id, 
                               t.issue_version as issue_version, u.firstname as first_name, u.lastname as last_name,
                               t.sel_remark as sel_remark, f.created_date as created_date, t.done as done 
                               from flags f left join tecs t on f.id=t.flag_id left join users u on t.user=u.id 
                               where t.id IS NOT NULL and f.flag_name = ? and done = ? order by id", flagname, @state])
    else
      raw = Flag.find_by_sql(["select t.id as id, f.flag_name as flag_name, t.issue_name as issue_name, t.issue_id as issue_id, 
                               t.issue_version as issue_version, u.firstname as first_name, u.lastname as last_name,
                               t.sel_remark as sel_remark, f.created_date as created_date, t.done as done 
                               from flags f left join tecs t on f.id=t.flag_id left join users u on t.user=u.id 
                               where t.id IS NOT NULL and f.flag_name = ? order by id", flagname])
    end
    raw.each do |row|
       feats = Array.new()
       fields.each do |ele|
          feats.push( row[ ele ].to_s )
       end
       @tecs.push( feats )
    end
    raw = NIL

  end

  # update flags
  def update_flag
    @flag = Flag.find(params[:id])
    issue = Issue.find(@flag.issue_id)
    if params[:commit].to_s == "Cancel"
      redirect_to :controller => "issues", :action => "show", :id => issue.id
    else
      project = issue.project
      # @allowed_statuses = issue.new_statuses_allowed_to(User.current)
      # @edit_allowed = User.current.allowed_to?(:change_issue_flags, project)
      # if (@edit_allowed || !@allowed_statuses.empty?)

      rightto = Group.right_to?("resolve_flags")
      if(rightto)
	#check reason value
	if(params[:reason1].to_s.empty?)
	  flash[:error] = 'Missing solution!'
	  redirect_to :back
	else
	  reason = params[:reason1].to_s
	  if(reason == 'other_please_specify')
	    if(params[:reason2].to_s.empty?)
	      flash[:error] = 'Missing solution!'
	      redirect_to :back
              return
	    else
	      reason = params[:reason2].to_s
	      #some checking
              if(((reason =~ /^annotated_/) == nil) and ((reason =~ /^rejected_/) == nil))
                flash[:error] = 'Invalid solution!'
                redirect_to :back
                return
              end
	    end
	  end
          #store reason
	  @flag.reason = reason
          #store new active flags
          new_active_flags = []
          if(!issue.active_flags.to_s.empty?)
            issue.active_flags.split(/, /).each do |af|
              if(af != @flag.flag_name)
                new_active_flags.push(af)
              end
            end
            issue.active_flags = new_active_flags.join(", ")
          end
          issue.save
	  @flag.save
	  # @flag.update_attributes(params[:flag])
	  #store resolve data & save as change in history
	  resolve
	end
      else
	flash[:error] = 'NOT ALLOWED!'
	redirect_to :controller => "issues", :action => "show", :id => issue.id
      end
    end
  end

  # resolve flags
  def resolve
    issue = Issue.find(@flag.issue_id)
    project = issue.project
    
    # @allowed_statuses = issue.new_statuses_allowed_to(User.current)
    # @edit_allowed = User.current.allowed_to?(:change_issue_flags, project)
    # if (@edit_allowed || !@allowed_statuses.empty?)
      
    rightto = Group.right_to?("resolve_flags")
    if(rightto)
      if @flag.update_attribute(:checked_date, Date.today)
        #write history
        journal = issue.init_journal(User.current)
        journal.notes = "Resolved flag \"" + @flag.flag_name + "\" (" + @flag.created_date.to_s + ")"
        journal.save
        flash[:notice] = 'Flag was successfully updated.'
      else
        flash[:error] = 'Flag could not be updated.'
      end
    else
      flash[:error] = 'NOT ALLOWED!'
    end
    
    redirect_to :controller => "issues", :action => "show", :id => issue.id
  end

  # not in use
  def new
    @flag = Flag.new

    respond_to do |format|
      format.html # new.html.erb
      format.xml  { render :xml => @flag }
    end
    
  end

  # create new VERIFY flag
  def new_tec
    @group = Group.group.name
    @rights = Group.group.rights
    @rightto = Group.right_to?("create_tecflags")

    @flag = Flag.new

    respond_to do |format|
      format.html # new.html.erb
      format.xml  { render :xml => @flag }
    end
    
  end


  # get params to edit a flag
  def edit
    @flag = Flag.find(params[:id])
    @sol = params[:sol]
    if @sol.nil?
      @sol = ''
    end

    @selected_options = nil
    if(!@flag.reason.nil?)
      @selected_options = @flag.reason
    end

    @allow_new = 1

    #special case: cDNAs
    if(@flag.flag_name == "missing_cdna" and @sol.to_s == "reject")
      @allow_new = 0
      raw = Flag.find_by_sql(["SELECT reason, note FROM flags 
                               WHERE flag_name=? AND issue_id=? ORDER BY note",
                              @flag.flag_name, -1])
      @current_voc = Hash.new
      raw.each do |flag|
        @current_voc[flag['note'].to_s] = flag['reason'].to_s
      end

    else

      raw = Flag.find_by_sql(["SELECT DISTINCT reason FROM flags 
                               WHERE reason IS NOT NULL AND reason LIKE ? ORDER BY reason", @sol.to_s + "%"])
      @current_voc = Array.new

      if raw.empty?
        @current_voc = ""
      else
        raw.each do |flag|
          @current_voc.push(flag['reason'].to_s)
        end
      end
      @current_voc.push("other_please_specify")
    end

  end

  # create new flag
  def create
    @flag = Flag.new(params[:flag])
    
    issue = Issue.find(@flag.issue_id)
    project = issue.project

    # @allowed_statuses = issue.new_statuses_allowed_to(User.current)
    # @edit_allowed = User.current.allowed_to?(:change_issue_flags, project)
    # if (@edit_allowed || !@allowed_statuses.empty?) && params[:flag]

    rightto = Group.right_to?("create_flags", '', @flag.flag_name)
    if(rightto)
    
      respond_to do |format|
        if @flag.save
          flash[:notice] = 'Flag was successfully created.'
          #write history
          #issue = Issue.find(@flag.issue_id)
          journal = issue.init_journal(User.current)
          journal.notes = "Created flag \"" + @flag.flag_name + "\""
          journal.save
          format.html { redirect_to :controller => "issues", :action => "show", :id => issue.id }
          format.xml  { render :xml => @flag, :status => :created, :location => @flag }
        else
          format.html { render :action => "new" }
          format.xml  { render :xml => @flag.errors, :status => :unprocessable_entity }
        end
      end
    else
      flash[:error] = "You have no rights to create flags for " + issue.id.to_s
      @flag.destroy
      redirect_to :controller => "issues", :action => "show", :id => issue.id
    end
  end

  # create multiple flags from list
  def batch_create

    flagids = params[:ids]
    flagname = params[:flag_name]
    cdate = params[:created_date]
    id_array = flagids.split("\r\n")
    savedflags = 0

    id_array.each do |issue_id|
      if(issue_id.empty?)
        next
      end
      issue = Issue.find_by_subject(issue_id)
      if(issue)
        #logger.debug("Creating flag for #{issue_id}\n")

	@flag = Flag.new(:issue_id => issue.id, :flag_name => flagname, :created_date => cdate)
	project = issue.project

        rightto = Group.right_to?("create_flags", '', @flag.flag_name)
        if(rightto)
	  if @flag.save
	    savedflags = savedflags + 1
	    journal = issue.init_journal(User.current)
            notes = "Created flag \"" + @flag.flag_name + "\""
	    journal.notes = notes
	    journal.save
	  end
	else
	  flash[:error] = "You have no rights to create flags"
	  @flag.destroy
	end
      else
        flash[:notice] = "Could not find entry with id " + issue_id + "."
      end
    end

    if(savedflags > 0)
      flash[:notice] = "Saved flags for " + savedflags.to_s + " issues."
    end
    redirect_to :controller => "flags", :action => "set_flags"

  end


  def new_reason_org
    new_reason = params[:new_reason]
    if(new_reason.defined?)

    end
  end

  # create new VERIFY flag
  def create_tec

    flagname = params[:flag_name]
    cdate = params[:created_date]
    iid = params[:issue_id]
    remark = params[:sel_remark]
    if(flagname && cdate && iid && remark)
      issue = Issue.find_by_id(params[:issue_id])
      if(issue)
	#get version
	versionfield = issue.custom_values.find_by_custom_field_id(CustomField.find_by_name('transcriptversion').id)
        if(versionfield)
	  transcript_version = versionfield.value
        else
	  transcript_version = 0
        end
	@flag = Flag.new(:issue_id => issue.id, :flag_name => flagname, :created_date => cdate)

        rightto = Group.right_to?("create_tecflags")

        if(rightto)
	  if @flag.save
	    #save to TEC table
	    tec = Tec.new(:issue_id => issue.id, :issue_version => transcript_version,
			  :issue_name => issue.subject, :flag_id => @flag.id, 
			  :user => User.current.id, :sel_remark => remark)
	    tec.save
	    #save to tec-features table
	    save_tec_features(tec, issue)
	    #save to history
	    journal = issue.init_journal(User.current)
	    journal.notes = "Created VERIFY flag \"" + @flag.flag_name + "\""
	    journal.save
	    flash[:notice] = "Created VERIFY flag for " + issue.subject + " (" + flagname + ", " + remark + ")"
	  end
	else
	  flash[:error] = "You have no rights to create VERIFY flags"
	  @flag.destroy
	end
      end
    else
      flash[:error] = "There are missing parameters."
    end

    redirect_to :controller => "issues", :action => "show", :id => iid

  end

  # save sub-parts of VERIFY flag
  def save_tec_features(tec, issue)

    #for every subfeature
    issue.subfeatures.each do |sf|
      next if((sf.subfeature_type =~ /intron/))
      tf = TecFeature.new(:tec_id => tec.id, :ftype => sf.subfeature_type,
			  :chromosome => sf.subfeature_chr, :start => sf.subfeature_start, :end => sf.subfeature_end,
			  :strand => sf.subfeature_strand, :sequence => "")
      tf.save
      #sequence gets filled inexternally with perl cron script
    end

  end

  # delete flags
  def destroy
    rightto = Group.right_to?("delete_flags")
    if(rightto)
      @flag = Flag.find(params[:id])
      @flag.destroy
    end
    
    respond_to do |format|
      format.html { redirect_to(flags_url) }
      format.xml  { head :ok }
    end
  end


  #filter specific flags
  #coordinates of havana transcripts that have been flagged, the id and the flag_name
  def list
    #get chromosome names
    @chromosomes = []
    raw = Flag.find_by_sql(["SELECT DISTINCT i.Tchrom as ichr
                             FROM issues i 
                             WHERE i.active=1
                             ORDER BY ichr"])
    raw.each do |chr|
      @chromosomes.push(chr['ichr'].to_s)
    end

    #get flag names
    @flagnames = []
    raw = Flag.find_by_sql(["SELECT DISTINCT f.flag_name as fname
                             FROM flags f"])
    @flagnames.push('*')
    raw.each do |flag|
      @flagnames.push(flag['fname'].to_s)
    end
  end


  #produce csv/txt file with flags and flagged issues
  def retrieve_csv
    if @flag_num == 0
      flash[:error] = "There are no flags of this type."
      redirect_to :back
    else
      ic = Iconv.new(l(:general_csv_encoding), 'UTF-8')    
      decimal_separator = l(:general_csv_decimal_separator)
      export = StringIO.new
      export << '#Flag export from AnnoTrack, ' + Date.today.to_s + "\n"
      CSV::Writer.generate(export, "\t") do |csv|
        # header fields
        export << "ID\t" + l(:field_issue) +
          "\t" + l(:field_Tchrom) +
          "\t" + l(:field_Tstart) +
          "\t" + l(:field_Tend) +
          "\t" + l(:field_Tstrand) +
          "\t" + l(:field_flag) + 
          "\t" + l(:label_flag_created) + "\n"
        @retrieve_flags.each do |flag|
          export << flag
          export << "\n"
        end

      end
      export.rewind
      send_data( export.read,
                 :type => 'text/csv; charset=iso-8859-1; header=present',
                 :filename => 'exported_flags.txt',
                 :disposition =>'attachment',
                 :encoding => 'iso-8859-1' )
    end

  end


protected

  # sql to pull out flags and flagged issues
  def retrieve_flags

    @retrieve_flags = []
    if(params["flagname"]["flagname"] =~ /\*/)
      raw = Flag.find_by_sql(["SELECT i.id as iid, i.subject as iname, i.Tchrom as ichr, i.Tstart as ista, i.Tend as iend,
                               i.Tstrand as istr, f.flag_name as fname,  f.created_date as cdate
                             FROM issues i, flags f 
                             WHERE i.active=1 AND i.id=f.issue_id AND f.checked_date IS NULL 
                             AND i.Tchrom=?",
                              params["chromosome"]["chromosome"]
                             ])
    else
      raw = Flag.find_by_sql(["SELECT i.id as iid, i.subject as iname, i.Tchrom as ichr, i.Tstart as ista, i.Tend as iend,
                               i.Tstrand as istr, f.flag_name as fname,  f.created_date as cdate
                             FROM issues i, flags f 
                             WHERE i.active=1 AND i.id=f.issue_id AND f.checked_date IS NULL 
                             AND i.Tchrom=? AND f.flag_name=?",
                              params["chromosome"]["chromosome"], params["flagname"]["flagname"]
                             ])
    end
    raw.each do |flags|
      flagline = flags['iid'].to_s + "\t" + flags['iname'] + "\t" + flags['ichr'] + "\t" + 
         flags['ista'].to_s + "\t" + flags['iend'].to_s + "\t" + flags['istr'] + "\t" + flags['fname'] + "\t" + flags['cdate']
      @retrieve_flags.push(flagline)
    end
    @flag_num = @retrieve_flags.size
  end

end
