#!/usr/local/ensembl/bin/perl -w

# Helper script for the GENCODE tracking system, to be run nightly.
#
# Connect to the external DAS servers,
# fetch data, store in internal tracking system db
# and recalculate dependant fields in db

package gencode_tracking_system::sources::ucsc_exoniphy;

use strict;
use gencode_tracking_system::core;
use gencode_tracking_system::config;
use base 'Exporter';

our @EXPORT = qw( run_update );

sub run_update {
  my ($response, $chrom, $tracking_dbh, $prepare_hash, $user_id, $category_id, $previous_genes) = @_;

  #connect to external das server
  my $gene_type   = "ucsc_exoniphy_exon";
  my $gene_status = 'new';
  my %new_features = ();

  my ($current_transcript_id, $current_gene_id);

  #get general project instead:
  $current_gene_id = get_project_for_category($prepare_hash, $tracking_dbh, $category_id);
  die "Can't find general project for category $category_id!\n" unless $current_gene_id;

  # go through loci
  while (my ($url, $features) = each %$response) {

    if(ref $features eq "ARRAY"){
      print "Received ".scalar @$features." features.\n" if $VERBOSE;

    FEATURES:
      foreach my $feature (@$features) {

	#remove duplicates from overlapping regions
	if(defined $previous_genes and exists $previous_genes->{$feature->{'feature_id'}}){
	  next FEATURES;
	}
	$new_features{$feature->{'feature_id'}} = 1;

	my $strand       = "0";
	my $phase        = "-";

	my %transcript;

	#build structure for transcript
	$transcript{'chrom'}        = $chrom;
	$transcript{'biotype'}      = $gene_type;
	$transcript{'status'}       = $gene_status;
	$transcript{'type'}         = "transcript";
	$transcript{'start'}        = $feature->{'start'};
	$transcript{'end'}          = $feature->{'end'};
	$transcript{'strand'}       = $strand;
	$transcript{'id'}           = $feature->{'feature_id'};
	$transcript{'description'}  = $feature->{'feature_id'};


	#store transcript
	if($VERBOSE){
	  print "TRANSCRIPT:\n";
	  print_element(\%transcript);
	}
	$current_transcript_id = store_features($tracking_dbh, $prepare_hash, \%transcript,
						'transcript', $current_gene_id, 0, 
						$user_id, $category_id);

      }
      @$features = ();
    }
  }

  return \%new_features;
}


1;


__END__

update projects set name="UCSC_Exonify", description="Conserved_Exons", Gchrom=0, Gstart=0, Gend=0, identifier="UCSC_Exonify" where id=587;
delete p from projects p, issues i where i.project_id=p.id and i.category_id=10 and p.id!=587;
update issues set project_id=587 where category_id=10;
