#!/usr/local/ensembl/bin/perl -w

# Helper script for the GENCODE tracking system, to be run nightly.
#
# Connect to the external DAS servers,
# fetch data, store in internal tracking system db
# and recalculate dependant fields in db

package gencode_tracking_system::sources::mit_rfc_csf;

use strict;
use gencode_tracking_system::core;
use gencode_tracking_system::config;
use base 'Exporter';

our @EXPORT    = qw( run_update );

sub run_update {
  my ($response, $chrom, $tracking_dbh, $prepare_hash, $user_id, $category_id, $previous_genes) = @_;

  my $gene_type   = "mit_rfc_csf_exon";
  my $gene_status = undef;
  my $id_prefix   = "MIT_sigs";
  my %new_features = ();
  my ($current_transcript_id, $current_gene_id);

  # go through loci
  while (my ($url, $features) = each %$response) {

    if(ref $features eq "ARRAY"){
      print "Received ".scalar @$features." features.\n" if $VERBOSE;

    FEATURES:
      foreach my $feature (@$features) {

	#remove duplicates from overlapping regions
	if(defined $previous_genes and exists $previous_genes->{$id_prefix."_".$feature->{'feature_id'}}){
	  next FEATURES;
	}
	$new_features{$id_prefix."_".$feature->{'feature_id'}} = 1;

	my @notes;

	my $ott_id = "HAVANA-TRANSCR-IDS: ".$feature->{'feature_id'};
	push(@notes, $ott_id);

	my %notes  = ();
	my $i      = 0;
	while(defined($feature->{'note'}->[$i])){
	  my $morenotes = $feature->{'note'}->[$i];
	  my ($morenotes_type, $morenotes_value) = split('\|', $morenotes);
	  #$morenotes_value =~ s/\&\#39\;/\'/g;
	  $notes{$morenotes_type} = $morenotes_value;
	  $i++;
	  if($morenotes_type ne 'LASTMOD'){
	    push(@notes, "SCORE: ".$morenotes_type." = ".$morenotes_value);
	  }
	}
	my $timestamp_updated = $notes{'LASTMOD'};
	my $timestamp_created = $notes{'LASTMOD'};
#	if(defined($notes{'CREATED'})){
#	  $timestamp_created = $notes{'CREATED'};
#	}

	my %transcript;

	#build structure for transcript
	$transcript{'chrom'}        = $chrom;
	$transcript{'biotype'}      = $gene_type;
	$transcript{'status'}       = $gene_status;
	$transcript{'type'}         = "transcript";
	$transcript{'start'}        = $feature->{'start'};
	$transcript{'end'}          = $feature->{'end'};
	$transcript{'strand'}       = $feature->{'orientation'};
	$transcript{'id'}           = $id_prefix."_".$feature->{'feature_id'};
	$transcript{'description'}  = join("\n", @notes);
	$transcript{'created_on'}   = $timestamp_created;
	$transcript{'updated_on'}   = $timestamp_updated;

	#clone gene from transcript
	my %gene = %transcript;
	$gene{'description'}  = "";

	#store gene
	if($VERBOSE){
	  print "GENE:\n";
	  print_element(\%gene);
	}
	$gene{'type'} = "gene";
	$current_gene_id = store_features($tracking_dbh, $prepare_hash, \%gene, 'gene', 0, 0, 
        				  $user_id, $category_id);

	#store transcript
	if($VERBOSE){
	  print "TRANSCRIPT:\n";
	  print_element(\%transcript);
	}
	$current_transcript_id = store_features($tracking_dbh, $prepare_hash, \%transcript,
						'transcript', $current_gene_id, 0, 
						$user_id, $category_id);

      }
      @$features = ();
    }
  }

  return \%new_features;
}


1;
