# Extension for AnnoTrack using RedMine
# (C) Felix Kokocinski, WTSI, 2008-2010
#
# Additional content for the projects controller & views


####### controller functions ##########



####### view functions ##########

def show_projects_description

  content = ""
  if @project.name.match("Tracking")

    if User.current.allowed_to?(:view_issues, @project)
        content = content + "<div class=\"box\">" +   
        "<h3 class=\"icon22 icon22-tracker\">Issue tracking</h3>" + 
        "<ul>"
        for tracker in @trackers
	      content = content + "<li>" + link_to(tracker.name, :controller => 'issues', :action => 'index', :project_id => @project, 
                                                :set_filter => 1, 
                                                "tracker_id" => tracker.id) + ":"
	      oi = @open_issues_by_tracker[tracker]  || 0
              ti = @total_issues_by_tracker[tracker] || 0
              content = content + " " + oi.to_s + " " + lwr(:label_open_issues, oi.to_s) + " " + l(:label_on) + " " + ti.to_s + "</li>"
        end
        content = content + "</ul><p>" + 
        link_to("View all issues", :controller => 'issues', :action => 'index', :project_id => @project, :set_filter => 1) +
        "</p><p>" + link_to("Add new issues", :controller => 'issues', :action => 'new', :project_id => @project, :set_filter => 1) +
        "</p></div>"
    end

  else

	for custom_value in @custom_values
	  if !custom_value.value.empty?
	    content = content + "<li>" + custom_value.custom_field.name + ": " + h(show_value(custom_value)) + "</li>"
          end
	end
	content = content + "</ul><p>&nbsp;</p>"

	if(@issue_count<100)

	  if User.current.allowed_to?(:view_issues, @project)
	    content = content + "<div class=\"box\">" +   
              "<h3 class=\"icon22 icon22-tracker\">" + l(:label_issue_tracking) + "</h3><ul>"
	    for tracker in @trackers
	      content = content + "<li>" + link_to(tracker.name, :controller => 'issues', :action => 'index', :project_id => @project, 
                                                :set_filter => 1, 
                                                "tracker_id" => tracker.id) + ":"
	      oi = @open_issues_by_tracker[tracker]  || 0
              ti = @total_issues_by_tracker[tracker] || 0
              content = content + " " + oi.to_s + " " + lwr(:label_open_issues, oi.to_s) + " " + l(:label_on) + " " + ti.to_s + "</li>"
	    end
	    content = content + "</ul><p>" + 
                link_to(l(:label_issue_view_all), :controller => 'issues', :action => 'index', :project_id => @project, :set_filter => 1) +
                "</p></div>"

            if @issues.empty?
              content = content + "<p class=\"nodata\">" + l(:label_no_data) + "</p>"
            else
              content = content + "<b>" + l(:label_issue_plural_all) + "</b>&nbsp;&nbsp;&nbsp;" +
                render(:partial => 'issues/list', :locals => {:issues => @issues})
            end

          end

       else
	  content = content + '<div class="box"><p>'
          content = content + link_to(l(:label_issue_view_all), :controller => 'issues', :action => 'index', :project_id => @project, :set_filter => 1) +
              "</p></div>"
       end

  end

 return content
end


#get additional annotation on demand
#uses Ensembl, replace with other source if desired
def ensembl_gene_annotation
  content = ""

  #use gene name?
  #if @project.name.match("Tracking")
  #content = content + "<div>" + "Annotation" + "<br /> </div>"

  return content
end
