
=head1 NAME

gencode_tracking_system / remove_duplicated_history

=head1 DESCRIPTION

Helper script for the GENCODE tracking system.
clean up the issues history:
remove cases where there are more history entries than flags

=head1 CONTACT

Felix Kokocinski, fsk@sanger.ac.uk

=head1 COPYRIGHT

Copyright Felix Kokocinski, 2008-2010, 
supported by Wellcome Trust Sanger Institute (UK) 
and National Human Genome Research Institute (USA).

You may distribute this module under the same terms as perl itself, 
citing the original source.

=cut

use strict;
use warnings;
use gencode_tracking_system::core;
use gencode_tracking_system::config;

my ($sql, $sth0, $sth1, $sth2, $sth3);

my $tracking_dbh = connect_db($DBHOST, $DBPORT, $DBNAME, $DBUSER, $DBPASS)
  or die "cant connect to to database $DBNAME @ $DBHOST.\n";
print "Conected to $DBNAME @ $DBHOST.\n";

$sql = 'select count(*), issue_id '.
       'from flags where flag_name=? and issue_id>0 group by issue_id';
$sth1 = $tracking_dbh->prepare($sql);

#$sql = 'delete j, jd from journals j, journal_details jd where j.id=jd.journal_id and jd.prop_key="priority_id";';

$sql  = "select id from journals ".
        "where journalized_type='Issue' and journalized_id = ? and notes = ?;";
$sth2 = $tracking_dbh->prepare($sql);

$sql  = "delete from journals where id = ? and journalized_id = ?;";
$sth3 = $tracking_dbh->prepare($sql);

my $flag_name = undef;;
my $rm_counter = 0;

if($flag_name){
  check_flag_history($flag_name);
}
else{
  $sql  = 'select distinct flag_name from flags;';
  $sth0 = $tracking_dbh->prepare($sql);
  $sth0->execute();
  while(my ($flag_name) = $sth0->fetchrow_array()){
    next if($flag_name eq "missing_cdna");
    print "Checking flag $flag_name.\n";

    check_flag_history($flag_name);

  }
}

$sth0->finish;
$sth1->finish;
$sth2->finish;
$sth3->finish;


sub check_flag_history {
  my ($flag_name) = @_;

  $rm_counter = 0;
  $sth1->execute($flag_name);
  while(my ($targetcount, $issue_id) = $sth1->fetchrow_array){
    my $currentcount = 1;
    print "$issue_id / $targetcount\n";
    $sth2->execute($issue_id, 'Created flag "'.$flag_name.'"');
    while(my ($j_id) = $sth2->fetchrow_array){
      if($currentcount > $targetcount){
	print ">REMOVE HIST: $j_id\n";
	if($WRITE){
	  $sth3->execute($j_id, $issue_id);
	}
	$rm_counter++;
      }
      $currentcount++
    }
  }

  print "\nRemoved $rm_counter journal entries for $flag_name.\n";

}


