
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `attachments`
--

DROP TABLE IF EXISTS `attachments`;
CREATE TABLE `attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `container_id` int(11) NOT NULL DEFAULT '0',
  `container_type` varchar(30) NOT NULL DEFAULT '',
  `filename` varchar(255) NOT NULL DEFAULT '',
  `disk_filename` varchar(255) NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT '0',
  `content_type` varchar(255) DEFAULT '',
  `digest` varchar(40) NOT NULL DEFAULT '',
  `downloads` int(11) NOT NULL DEFAULT '0',
  `author_id` int(11) NOT NULL DEFAULT '0',
  `created_on` datetime DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;

--
-- Table structure for table `auth_sources`
--

DROP TABLE IF EXISTS `auth_sources`;
CREATE TABLE `auth_sources` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL DEFAULT '',
  `name` varchar(60) NOT NULL DEFAULT '',
  `host` varchar(60) DEFAULT NULL,
  `port` int(11) DEFAULT NULL,
  `account` varchar(255) DEFAULT NULL,
  `account_password` varchar(60) DEFAULT NULL,
  `base_dn` varchar(255) DEFAULT NULL,
  `attr_login` varchar(30) DEFAULT NULL,
  `attr_firstname` varchar(30) DEFAULT NULL,
  `attr_lastname` varchar(30) DEFAULT NULL,
  `attr_mail` varchar(30) DEFAULT NULL,
  `onthefly_register` tinyint(1) NOT NULL DEFAULT '0',
  `tls` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `boards`
--

DROP TABLE IF EXISTS `boards`;
CREATE TABLE `boards` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` varchar(255) DEFAULT NULL,
  `position` int(11) DEFAULT '1',
  `topics_count` int(11) NOT NULL DEFAULT '0',
  `messages_count` int(11) NOT NULL DEFAULT '0',
  `last_message_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `boards_project_id` (`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `changes`
--

DROP TABLE IF EXISTS `changes`;
CREATE TABLE `changes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `changeset_id` int(11) NOT NULL,
  `action` varchar(1) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `from_path` varchar(255) DEFAULT NULL,
  `from_revision` varchar(255) DEFAULT NULL,
  `revision` varchar(255) DEFAULT NULL,
  `branch` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `changesets_changeset_id` (`changeset_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `changesets`
--

DROP TABLE IF EXISTS `changesets`;
CREATE TABLE `changesets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `repository_id` int(11) NOT NULL,
  `revision` varchar(255) NOT NULL,
  `committer` varchar(255) DEFAULT NULL,
  `committed_on` datetime NOT NULL,
  `comments` text,
  `commit_date` date DEFAULT NULL,
  `scmid` varchar(255) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `changesets_repos_rev` (`repository_id`,`revision`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `changesets_issues`
--

DROP TABLE IF EXISTS `changesets_issues`;
CREATE TABLE `changesets_issues` (
  `changeset_id` int(11) NOT NULL,
  `issue_id` int(11) NOT NULL,
  UNIQUE KEY `changesets_issues_ids` (`changeset_id`,`issue_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `comments`
--

DROP TABLE IF EXISTS `comments`;
CREATE TABLE `comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `commented_type` varchar(30) NOT NULL DEFAULT '',
  `commented_id` int(11) NOT NULL DEFAULT '0',
  `author_id` int(11) NOT NULL DEFAULT '0',
  `comments` text,
  `created_on` datetime NOT NULL,
  `updated_on` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `custom_fields`
--

DROP TABLE IF EXISTS `custom_fields`;
CREATE TABLE `custom_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL DEFAULT '',
  `name` varchar(30) NOT NULL DEFAULT '',
  `field_format` varchar(30) NOT NULL DEFAULT '',
  `possible_values` text,
  `regexp` varchar(255) DEFAULT '',
  `min_length` int(11) NOT NULL DEFAULT '0',
  `max_length` int(11) NOT NULL DEFAULT '0',
  `is_required` tinyint(1) NOT NULL DEFAULT '0',
  `is_for_all` tinyint(1) NOT NULL DEFAULT '0',
  `is_filter` tinyint(1) NOT NULL DEFAULT '0',
  `position` int(11) DEFAULT '1',
  `searchable` tinyint(1) DEFAULT '0',
  `default_value` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;

--
-- Table structure for table `custom_fields_projects`
--

DROP TABLE IF EXISTS `custom_fields_projects`;
CREATE TABLE `custom_fields_projects` (
  `custom_field_id` int(11) NOT NULL DEFAULT '0',
  `project_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `custom_fields_trackers`
--

DROP TABLE IF EXISTS `custom_fields_trackers`;
CREATE TABLE `custom_fields_trackers` (
  `custom_field_id` int(11) NOT NULL DEFAULT '0',
  `tracker_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `custom_values`
--

DROP TABLE IF EXISTS `custom_values`;
CREATE TABLE `custom_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customized_type` varchar(30) NOT NULL DEFAULT '',
  `customized_id` int(11) NOT NULL DEFAULT '0',
  `custom_field_id` int(11) NOT NULL DEFAULT '0',
  `value` text,
  PRIMARY KEY (`id`),
  KEY `custom_values_customized` (`customized_type`,`customized_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2334780 DEFAULT CHARSET=latin1;

--
-- Table structure for table `documents`
--

DROP TABLE IF EXISTS `documents`;
CREATE TABLE `documents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(60) NOT NULL DEFAULT '',
  `description` text,
  `created_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `documents_project_id` (`project_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

--
-- Table structure for table `enabled_modules`
--

DROP TABLE IF EXISTS `enabled_modules`;
CREATE TABLE `enabled_modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `enabled_modules_project_id` (`project_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1488535 DEFAULT CHARSET=latin1;

--
-- Table structure for table `enumerations`
--

DROP TABLE IF EXISTS `enumerations`;
CREATE TABLE `enumerations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `opt` varchar(4) NOT NULL DEFAULT '',
  `name` varchar(30) NOT NULL DEFAULT '',
  `position` int(11) DEFAULT '1',
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=latin1;

--
-- Table structure for table `flags`
--

DROP TABLE IF EXISTS `flags`;
CREATE TABLE `flags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `issue_id` int(11) NOT NULL DEFAULT '0',
  `flag_name` varchar(30) NOT NULL DEFAULT '',
  `flag_issue_id` int(11) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `checked_date` date DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  `reason` varchar(100) DEFAULT NULL,
  `seen` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=849135 DEFAULT CHARSET=latin1;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
CREATE TABLE `groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(40) DEFAULT NULL,
  `rights` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

--
-- Table structure for table `id_conversions`
--

DROP TABLE IF EXISTS `id_conversions`;
CREATE TABLE `id_conversions` (
  `source_id` varchar(255) DEFAULT NULL,
  `target_id` varchar(255) DEFAULT NULL,
  UNIQUE KEY `source_id` (`source_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `issue_categories`
--

DROP TABLE IF EXISTS `issue_categories`;
CREATE TABLE `issue_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(30) NOT NULL DEFAULT '',
  `assigned_to_id` int(11) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `issue_categories_project_id` (`project_id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=latin1;

--
-- Table structure for table `issue_relations`
--

DROP TABLE IF EXISTS `issue_relations`;
CREATE TABLE `issue_relations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `issue_from_id` int(11) NOT NULL,
  `issue_to_id` int(11) NOT NULL,
  `relation_type` varchar(255) NOT NULL DEFAULT '',
  `delay` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `relation` (`issue_from_id`,`issue_to_id`,`relation_type`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `issue_statuses`
--

DROP TABLE IF EXISTS `issue_statuses`;
CREATE TABLE `issue_statuses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `is_closed` tinyint(1) NOT NULL DEFAULT '0',
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `position` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

--
-- Table structure for table `issues`
--

DROP TABLE IF EXISTS `issues`;
CREATE TABLE `issues` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tracker_id` int(11) NOT NULL DEFAULT '0',
  `project_id` int(11) NOT NULL DEFAULT '0',
  `subject` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `due_date` date DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `status_id` int(11) NOT NULL DEFAULT '0',
  `assigned_to_id` int(11) DEFAULT NULL,
  `priority_id` int(11) NOT NULL DEFAULT '0',
  `fixed_version_id` int(11) DEFAULT NULL,
  `author_id` int(11) NOT NULL DEFAULT '0',
  `lock_version` int(11) NOT NULL DEFAULT '0',
  `created_on` datetime DEFAULT NULL,
  `updated_on` datetime DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `done_ratio` int(11) NOT NULL DEFAULT '0',
  `estimated_hours` float DEFAULT NULL,
  `Tchrom` varchar(255) DEFAULT NULL,
  `Tstart` int(11) DEFAULT NULL,
  `Tend` int(11) DEFAULT NULL,
  `Tstrand` varchar(1) DEFAULT NULL,
  `seen` tinyint(1) DEFAULT NULL,
  `active` tinyint(1) DEFAULT '1',
  `active_flags` varchar(255) DEFAULT NULL,
  `lastuser` varchar(128) DEFAULT NULL,
  `firstuser` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `issues_project_id` (`project_id`),
  KEY `category_id` (`category_id`),
  KEY `position` (`Tchrom`,`Tstart`,`Tend`,`Tstrand`),
  KEY `subject` (`subject`),
  KEY `status_id` (`status_id`),
  KEY `tracker_id` (`tracker_id`),
  KEY `priority_id` (`priority_id`)
) ENGINE=InnoDB AUTO_INCREMENT=790759 DEFAULT CHARSET=latin1;

--
-- Table structure for table `journal_details`
--

DROP TABLE IF EXISTS `journal_details`;
CREATE TABLE `journal_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `journal_id` int(11) NOT NULL DEFAULT '0',
  `property` varchar(30) NOT NULL DEFAULT '',
  `prop_key` varchar(30) NOT NULL DEFAULT '',
  `old_value` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `journal_details_journal_id` (`journal_id`)
) ENGINE=InnoDB AUTO_INCREMENT=49481 DEFAULT CHARSET=latin1;

--
-- Table structure for table `journals`
--

DROP TABLE IF EXISTS `journals`;
CREATE TABLE `journals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `journalized_id` int(11) NOT NULL DEFAULT '0',
  `journalized_type` varchar(30) NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `notes` text,
  `created_on` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `journals_journalized_id` (`journalized_id`,`journalized_type`)
) ENGINE=InnoDB AUTO_INCREMENT=1721247 DEFAULT CHARSET=latin1;

--
-- Table structure for table `members`
--

DROP TABLE IF EXISTS `members`;
CREATE TABLE `members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `project_id` int(11) NOT NULL DEFAULT '0',
  `role_id` int(11) NOT NULL DEFAULT '0',
  `created_on` datetime DEFAULT NULL,
  `mail_notification` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `role_id` (`role_id`),
  KEY `user_id` (`user_id`),
  KEY `project_id` (`project_id`)
) ENGINE=InnoDB AUTO_INCREMENT=992343 DEFAULT CHARSET=latin1;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
CREATE TABLE `messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `board_id` int(11) NOT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `subject` varchar(255) NOT NULL DEFAULT '',
  `content` text,
  `author_id` int(11) DEFAULT NULL,
  `replies_count` int(11) NOT NULL DEFAULT '0',
  `last_reply_id` int(11) DEFAULT NULL,
  `created_on` datetime NOT NULL,
  `updated_on` datetime NOT NULL,
  `locked` tinyint(1) DEFAULT '0',
  `sticky` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `messages_board_id` (`board_id`),
  KEY `messages_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `news`
--

DROP TABLE IF EXISTS `news`;
CREATE TABLE `news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) DEFAULT NULL,
  `title` varchar(60) NOT NULL DEFAULT '',
  `summary` varchar(255) DEFAULT '',
  `description` text,
  `author_id` int(11) NOT NULL DEFAULT '0',
  `created_on` datetime DEFAULT NULL,
  `comments_count` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `news_project_id` (`project_id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;

--
-- Table structure for table `plugin_schema_info`
--

DROP TABLE IF EXISTS `plugin_schema_info`;
CREATE TABLE `plugin_schema_info` (
  `plugin_name` varchar(255) DEFAULT NULL,
  `version` int(11) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
CREATE TABLE `projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text,
  `homepage` varchar(255) DEFAULT NULL,
  `is_public` tinyint(1) NOT NULL DEFAULT '1',
  `parent_id` int(11) DEFAULT NULL,
  `projects_count` int(11) DEFAULT '0',
  `created_on` datetime DEFAULT NULL,
  `updated_on` datetime DEFAULT NULL,
  `identifier` varchar(30) DEFAULT NULL,
  `status_id` int(11) DEFAULT '1',
  `status` int(11) NOT NULL DEFAULT '1',
  `Gchrom` varchar(255) DEFAULT NULL,
  `Gstart` int(11) DEFAULT NULL,
  `Gend` int(11) DEFAULT NULL,
  `Gstrand` varchar(1) DEFAULT NULL,
  `seen` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `is_public` (`is_public`),
  KEY `identifier` (`identifier`),
  KEY `parent_id` (`parent_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=447058 DEFAULT CHARSET=latin1;

--
-- Table structure for table `projects_trackers`
--

DROP TABLE IF EXISTS `projects_trackers`;
CREATE TABLE `projects_trackers` (
  `project_id` int(11) NOT NULL DEFAULT '0',
  `tracker_id` int(11) NOT NULL DEFAULT '0',
  KEY `projects_trackers_project_id` (`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `queries`
--

DROP TABLE IF EXISTS `queries`;
CREATE TABLE `queries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `filters` text,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `is_public` tinyint(1) NOT NULL DEFAULT '0',
  `column_names` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=latin1;

--
-- Table structure for table `repositories`
--

DROP TABLE IF EXISTS `repositories`;
CREATE TABLE `repositories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL DEFAULT '0',
  `url` varchar(255) NOT NULL DEFAULT '',
  `login` varchar(60) DEFAULT '',
  `password` varchar(60) DEFAULT '',
  `root_url` varchar(255) DEFAULT '',
  `type` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
CREATE TABLE `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `position` int(11) DEFAULT '1',
  `assignable` tinyint(1) DEFAULT '1',
  `builtin` int(11) NOT NULL DEFAULT '0',
  `permissions` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

--
-- Table structure for table `schema_migrations`
--

DROP TABLE IF EXISTS `schema_migrations`;
CREATE TABLE `schema_migrations` (
  `version` varchar(255) NOT NULL,
  UNIQUE KEY `unique_schema_migrations` (`version`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
CREATE TABLE `sessions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` varchar(255) NOT NULL,
  `data` text,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `index_sessions_on_session_id` (`session_id`),
  KEY `index_sessions_on_updated_at` (`updated_at`)
) ENGINE=InnoDB AUTO_INCREMENT=1134292 DEFAULT CHARSET=latin1;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `value` text,
  `updated_on` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=latin1;

--
-- Table structure for table `subfeatures`
--

DROP TABLE IF EXISTS `subfeatures`;
CREATE TABLE `subfeatures` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `issue_id` int(11) NOT NULL DEFAULT '0',
  `subfeature_type` varchar(255) NOT NULL DEFAULT '',
  `subfeature_start` int(11) NOT NULL DEFAULT '0',
  `subfeature_end` int(11) NOT NULL DEFAULT '0',
  `subfeature_chr` varchar(255) NOT NULL DEFAULT '',
  `subfeature_strand` varchar(255) NOT NULL DEFAULT '',
  `subfeature_phase` tinyint(4) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  `updated_on` datetime DEFAULT NULL,
  `seen` tinyint(1) DEFAULT NULL,
  `active` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `issue_id` (`issue_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4279221 DEFAULT CHARSET=latin1;

--
-- Table structure for table `tec_features`
--

DROP TABLE IF EXISTS `tec_features`;
CREATE TABLE `tec_features` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `tec_id` int(11) DEFAULT NULL,
  `ftype` varchar(255) DEFAULT NULL,
  `chromosome` varchar(3) DEFAULT NULL,
  `start` int(11) DEFAULT NULL,
  `end` int(11) DEFAULT NULL,
  `strand` varchar(1) DEFAULT NULL,
  `sequence` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5064 DEFAULT CHARSET=latin1;

--
-- Table structure for table `tecs`
--

DROP TABLE IF EXISTS `tecs`;
CREATE TABLE `tecs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `issue_id` int(11) NOT NULL,
  `issue_version` tinyint(4) DEFAULT '0',
  `issue_name` varchar(255) DEFAULT NULL,
  `flag_id` int(11) NOT NULL,
  `sel_remark` varchar(255) DEFAULT NULL,
  `user` tinyint(4) DEFAULT NULL,
  `result` varchar(255) DEFAULT NULL,
  `done` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1622 DEFAULT CHARSET=latin1;

--
-- Table structure for table `time_entries`
--

DROP TABLE IF EXISTS `time_entries`;
CREATE TABLE `time_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `issue_id` int(11) DEFAULT NULL,
  `hours` float NOT NULL,
  `comments` varchar(255) DEFAULT NULL,
  `activity_id` int(11) NOT NULL,
  `spent_on` date NOT NULL,
  `tyear` int(11) NOT NULL,
  `tmonth` int(11) NOT NULL,
  `tweek` int(11) NOT NULL,
  `created_on` datetime NOT NULL,
  `updated_on` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time_entries_project_id` (`project_id`),
  KEY `time_entries_issue_id` (`issue_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `tmp_values`
--

DROP TABLE IF EXISTS `tmp_values`;
CREATE TABLE `tmp_values` (
  `field_name` varchar(255) NOT NULL,
  `field_value` varchar(255) DEFAULT NULL,
  `field_group` varchar(255) DEFAULT NULL,
  `priority` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `tokens`
--

DROP TABLE IF EXISTS `tokens`;
CREATE TABLE `tokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `action` varchar(30) NOT NULL DEFAULT '',
  `value` varchar(40) NOT NULL DEFAULT '',
  `created_on` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=latin1;

--
-- Table structure for table `trackers`
--

DROP TABLE IF EXISTS `trackers`;
CREATE TABLE `trackers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `is_in_chlog` tinyint(1) NOT NULL DEFAULT '0',
  `position` int(11) DEFAULT '1',
  `is_in_roadmap` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

--
-- Table structure for table `user_preferences`
--

DROP TABLE IF EXISTS `user_preferences`;
CREATE TABLE `user_preferences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `others` text,
  `hide_mail` tinyint(1) DEFAULT '0',
  `time_zone` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=latin1;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(30) NOT NULL DEFAULT '',
  `hashed_password` varchar(40) NOT NULL DEFAULT '',
  `firstname` varchar(30) NOT NULL DEFAULT '',
  `lastname` varchar(30) NOT NULL DEFAULT '',
  `mail` varchar(60) NOT NULL DEFAULT '',
  `mail_notification` tinyint(1) NOT NULL DEFAULT '1',
  `admin` tinyint(1) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '1',
  `last_login_on` datetime DEFAULT NULL,
  `language` varchar(5) DEFAULT '',
  `auth_source_id` int(11) DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  `updated_on` datetime DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `group_id` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=latin1;

--
-- Table structure for table `versions`
--

DROP TABLE IF EXISTS `versions`;
CREATE TABLE `versions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) DEFAULT '',
  `description` varchar(255) DEFAULT '',
  `effective_date` date DEFAULT NULL,
  `created_on` datetime DEFAULT NULL,
  `updated_on` datetime DEFAULT NULL,
  `wiki_page_title` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `versions_project_id` (`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `watchers`
--

DROP TABLE IF EXISTS `watchers`;
CREATE TABLE `watchers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `watchable_type` varchar(255) NOT NULL DEFAULT '',
  `watchable_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

--
-- Table structure for table `wiki_content_versions`
--

DROP TABLE IF EXISTS `wiki_content_versions`;
CREATE TABLE `wiki_content_versions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wiki_content_id` int(11) NOT NULL,
  `page_id` int(11) NOT NULL,
  `author_id` int(11) DEFAULT NULL,
  `data` blob,
  `compression` varchar(6) DEFAULT '',
  `comments` varchar(255) DEFAULT '',
  `updated_on` datetime NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `wiki_content_versions_wcid` (`wiki_content_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

--
-- Table structure for table `wiki_contents`
--

DROP TABLE IF EXISTS `wiki_contents`;
CREATE TABLE `wiki_contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_id` int(11) NOT NULL,
  `author_id` int(11) DEFAULT NULL,
  `text` text,
  `comments` varchar(255) DEFAULT '',
  `updated_on` datetime NOT NULL,
  `version` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `wiki_contents_page_id` (`page_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
-- Table structure for table `wiki_pages`
--

DROP TABLE IF EXISTS `wiki_pages`;
CREATE TABLE `wiki_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wiki_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `created_on` datetime NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT '0',
  `parent_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wiki_pages_wiki_id_title` (`wiki_id`,`title`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

--
-- Table structure for table `wiki_redirects`
--

DROP TABLE IF EXISTS `wiki_redirects`;
CREATE TABLE `wiki_redirects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wiki_id` int(11) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `redirects_to` varchar(255) DEFAULT NULL,
  `created_on` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `wiki_redirects_wiki_id_title` (`wiki_id`,`title`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `wikis`
--

DROP TABLE IF EXISTS `wikis`;
CREATE TABLE `wikis` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL,
  `start_page` varchar(255) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `wikis_project_id` (`project_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
-- Table structure for table `workflows`
--

DROP TABLE IF EXISTS `workflows`;
CREATE TABLE `workflows` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tracker_id` int(11) NOT NULL DEFAULT '0',
  `old_status_id` int(11) NOT NULL DEFAULT '0',
  `new_status_id` int(11) NOT NULL DEFAULT '0',
  `role_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `wkfs_role_tracker_old_status` (`role_id`,`tracker_id`,`old_status_id`)
) ENGINE=InnoDB AUTO_INCREMENT=342 DEFAULT CHARSET=latin1;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- MySQL dump 10.9
--
-- Host: web-mii-shap    Database: gencode_tracking
-- ------------------------------------------------------
-- Server version	5.1.39-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Dumping data for table `documents`
--


/*!40000 ALTER TABLE `documents` DISABLE KEYS */;
LOCK TABLES `documents` WRITE;
INSERT INTO `documents` VALUES (1,227933,1,'About this system','This system was developed by Felix Kokocinski at the Wellcome Trust Sanger Institute with additional funding from the NIH to *track all loci and transcripts* annotated as part of the \"GENCODE project\":http://www.sanger.ac.uk/gencode/ which is a subproject of \"ENCODE\":http://genome.gov/10005107.\r\n\r\nhttp://annotrack.sanger.ac.uk/ is the entry point for the GENCODE installation of the tracking system.\r\n\r\nThis includes manual annotations from HAVANA and gene models from various gene prediction programs from other groups. Predictions will be analysed manually and selected cases will be experimentally verified. \r\nDuring this process the genes and transcripts will go though different stages, the result of the project will be a set of evidence-based genes and transcripts considered to be the \"Golden Set\" for the human genome.\r\n\r\nAs a researcher in human genomics you might be interested to check for known errors or additional information for the genes you are interested in.\r\nAs a researcher in other area of genomics or as a bioinformatician you might be interested to set up this system adjusted for your own needs.\r\n\r\nAnnoTrack, the program you are looking at, is based on a bug-tracking and project management system called \"Redmine\":http://www.redmine.org. The different projects, that were \"bug-tracked\" in Redmine, are now loci/genes and what originally were tickets of these projects are now transcripts of these genes. Additionally, the level of subfeatures stores information about exons, etc. Different types of flags replace the concept of tickets.\r\n\r\n\r\nThe idea is to enable annotators to have a list of features listed in the system that they should be aware of when working on a selected genomic region. Different statuses and flags highlight disagreements between different annotation sources. The annotator can then resolve these issues. A history of changes will be stored with every feature. The other partners will also be able to see the relationship between their own data and the data from other groups.\r\n\r\n\r\n\r\nThe system also serves as an overview over the annotation progress and as one starting point for the data analysis.\r\n\r\nAnnoTrack can easily be adjusted to other genome annotation projects.\r\n\r\nAnnoTrack is NOT a genome browser, please use \"Ensembl\":http://www.ensembl.org for this purpose. We have provided links from the listed transcripts to the major genome browsers where possible.\r\n\r\n','2008-07-25 15:16:24'),(2,227933,1,'How to use the system','The main entry point into the system is the \"list of transcripts\":/human/issues and the predefined query list, e.g. \"higher priority transcripts\":/human/issues?query_id=1. Once logged in you can create and store your own queries for easy access.\r\n\r\nIf you get lost, you can come back to the home page or the full list of genes or transcripts at any time by using the links in the top left corner of the web page.\r\n\r\nh2. 1. \"Home page\":/human and general things\r\n\r\nScreenshot: \"homepage\":/human/docs/show_image/A_homepage\r\n\r\nOn the start page you will find links to *important entry points* into the system and *news* about the development of this system. There are also a list of open flags (pointers to disagreeing annotation) that link to a transcript listing filtered to the chosen flag and a list of all categories in the database (transcripts or other annotated objects) that link to a transcript listing filtered to the chosen category.\r\n\r\nYou can change your *password* using the \"my account\":/human/my/account in the top right corner or directly \"here\":/human/my/password (when logged in).\r\nPlease remember to \"*sign out*\":/human/logout when you are finished.\r\n\r\n\r\nh2. 2. \"List of transcripts\":/human/issues\r\n\r\nScreenshots: \"transcript list\":/human/docs/show_image/B_transcript_list_1, \"transcript list with filter\":/human/docs/show_image/C_transcript_list_2\r\n\r\nThere are more than 600 000 entries on the transcript level in the database, finding the ones of interest to you is the most essential step. Most of the time you will look for core annotation in a specific genomic region or at specific types of external annotation highlighted by flags (e.g. where a computational method found a novel potentially coding region). You can use *filters* to get only the features you are interested in displayed on the transcript page by:\r\nUsing the _add filter_ menu on the right side, you can choose the field to use as a filter. These include the category (where the annotation came from), the genomic location (chromosome, start, end and strand), assigned flags (eg. contains \"missing_ccds\") and the current priority level. You can add multiple filters to show only Havana transcripts from 21 10000000 - 20000000 for example.\r\nAfter defining or changing a filter, press _Apply_ to fetch the the updated list of features. _Disable Filter_ will load the entire default list.\r\n\r\nYou can *sort* the list of transcripts by clicking on the column header, clicking on it again will reverse the sort order.\r\n\r\nTo show data for a specific *locus*, you can click on the name in the \"Gene\" column.\r\nTo show all data for a selected *transcript*, you can either click on the id in the #-column, or click on its name, which is shown as the second value in the _Transcript-ID_ column (after the \"-\" if there is one).\r\n\r\n\r\nh2. 3. Gene data page\r\n\r\nScreenshot: \"gene example\":/human/docs/show_image/D_gene_example\r\n\r\nFor HAVANA genes the page for the different loci currently shows the OTT-ID at the top, a direct link to the gene in VEGA and the description. It then lists all other data stored: genomic location, type, status, etc. All transcripts belonging to this gene are listed below. To get to the transcript level click on _Transcript tracking_ links or go to the _Transcripts_ tab. This will take you to a transcript listing similar to the main transcript listing (2.) - but only transcripts of the selected genes will be show. Filters and sort operations will only be applied to this subset.\r\n\r\n\r\nh2. 4. Transcript data page\r\n\r\nScreenshots: \"transcript example part 1\":/human/docs/show_image/E_transcript_example_1, \"transcript_example 2\":/human/docs/show_image/F_transcript_example_2\r\n\r\nThis is the main annotation (& most informative) page, showing all the facts about a single transcript or transcript-like feature in the database.\r\n\r\nA. At the top, the *ID* is displayed\r\n\r\nB. Then all *basic information* is listed (chromosome, start end end location, strand, category, status, dates).\r\n\r\nB. Next the *description* is given, taken from the source database (loutre for HAVANA transcripts).\r\n\r\nC. After that *web links* leading directly to the location in different genome browsers are given.\r\n\r\nD. The *\"Flags\"* part displays important information concerning the integration of the transcript into a combined annotation. See next topic.\r\n\r\nE. *Features* lists exon/intron/UTR elements and their genomic coordinates.\r\n\r\nF. If possible a *Gene Model* is showing these features visually (pulled dynamically from the Ensembl or Vega website).\r\n\r\nG. *Related issues* lists other cases in the same region that require attention to allow a quicker locus/region-centric annotation.\r\n\r\n\r\nh2. 5. Flags\r\n\r\nIf disagreements are found between different sources of annotation or entries need reviewing for other reasons it will be noted in the form of flags. They are with the date when this was first discovered. Annotators can also add flags themselves if they see a problem with the transcript. To do this click on \"add flag\" and choose a category. If you need additional categories, please let me know.\r\nOur goal is to *resolve* all flags by inspecting the problem and updating our annotation if necessary. Please use the same words for the same decisions, so that we can develop a standard ontology for this. You can resolve the problem by:\r\n A. clicking on the green \"checked\" symbol and by choosing your decision from the appearing text field as \"annotated_\". This means accepting the problem and updating the HAVANA annotation\r\n B. clicking on the red \"denied\" symbol and by choosing your decision from the appearing text field as \"rejected_\". This means you disbelieve the other annotation and don\'t change the HAVANA data.\r\nIf you cannot find a suitable solution at all, select \"other\" and specify a new term in the text field below (using \"annotated_\" or \"rejected_\" as the start of the single word)\r\n\r\nScreenshot: \"resolve flag\":/human/docs/show_image/H_resolve_flag\r\n\r\nIf you would like to store additional information about this particular case, please you the \"History\" at the bottom of the page. Here you can add additional information by clicking the small yellow pencil on the right side of the new history entry.\r\n\r\nA special type of flags are the _verify flags_, indicating  that a transcript/locus is selected for verification in the experimental pipeline. To add a verify flag, click on \"[mark for exp.ver]\", enter a short comment and select the type of verification to be done. You have to be logged in with the rights of \"annotator\" or \"partner\". After you hit the submit button the new _verify flag_ will be displayed with the date and your name. There will also be an entry in the \"History\" at the bottom of the page where you can add additional information if desired.\r\n\r\nScreenshot: \"show _verify_ flags\":/human/docs/show_image/J_verify_flag_listing\r\n\r\nList of \"flag categories\":/human/documents/show/4\r\n\r\nh2. 6. Stats\r\n\r\nThe system is also used to generate annotation statistics for reporting. These can be queried from the database directly, but some main summaries displayed by the web site are shown here:\r\n\r\nScreenshots (for quick access) / links:\r\n* \"show how flags have been resolved\":/human/docs/show_image/I_flag_statistics / \"link\":/human/flags/flag_stats\r\n* \"show genome annotation stats\":/human/docs/show_image/K_core_annotation_stats / \"link\":/human/flags/annotation_stats\r\n* \"show list of verify flags\":/human/docs/show_image/J_verify_flag_listing / \"link\":/human/flags/show_tecs\r\n\r\n\r\nmore technical details about the system can also be found \"here\":/human/documents/show/7.\r\n ','2008-07-25 15:33:28'),(4,227933,1,'Flag Categories','h3. A description of the flags used in AnnoTrack to highlight problematic or interesting features.\r\n\r\n*bidirectional*\r\nRegions with suspected bi-directional promotors (primate-specific).\r\nSupplied by Laura Elnitski (NIGRI).\r\n\r\n*check_status*\r\nHavana transcripts which status need to be re-checked.\r\nSupplied by Adam Frankish (HAVANA).\r\n\r\n*congo_nc*\r\nSubset of CONGO conserved exon predictions that overlap exons of non-coding HAVANA transcripts\r\nSupplied by Mike Lin (MIT).\r\n\r\n*ens_pseudogene_ovrlp*\r\nAn Ensembl pseudogene is overlapping a Havana (protein-coding) gene\r\n\r\n*flagged_pseudogene*\r\nPseudogene loci predicted by MIT & Yale, but not by HAVANA\r\nSupplied by Philip Cayting (MIT)\r\n\r\n*hgnc_update*\r\nChanged or withdrawn HGNC names.\r\nSupplied by Michael Lush et al. (HGNC, EBI)\r\n\r\n*low_complexity*\r\nTranscripts that show a very low sequence complexity, oftentimes with very short or repetitive translations. \r\nSupplied by Bronwen Aken (WTSI).\r\n\r\n*manual_selection*\r\nIndividually selected loci that require annotation because they are missing or re-annotation for various reasons.\r\n\r\n*missing_ccds*\r\nTranscripts that are part of the \"official CCDS set\":http://www.ncbi.nlm.nih.gov/CCDS/CcdsBrowse.cgi but are either not marked accordingly or are missing from the HAVANA annotation. \r\nSupplied by CCDS & Bronwen Aken (WTSI).\r\n\r\n*missing_cdna*\r\nLocations where HAVANA seems to be missing a transcript (splice variant) that ENSEMBL predicted. The cDNA evidence that was used to support Ensembl\'s prediction is reported.\r\nSupplied by Bronwen Aken (WTSI).\r\n\r\n*missing_exon*\r\nProtein-coding exons that were predicted by ENSEMBL, but seem to be missing from HAVANA. ie. These exons do not overlap a coding exon in HAVANA. The ranks of these exons was provided.\r\nSupplied by Bronwen Aken (WTSI).\r\n\r\n*missing_hgnc*\r\nHGNC names that appear in ENSEMBL, but not in HAVANA.\r\nSupplied by Bronwen Aken (WTSI).\r\n\r\n*missing_intron*\r\nIntrons that were predicted by ENSEMBL, but seem to be missing from HAVANA. Could indicate splice variants. \r\nSupplied by Bronwen Aken (WTSI).\r\n\r\n*novel_locus*\r\nFeatures in loci that are currently not covered by any HAVANA annotation.\r\nSupplied by Adam Siepel (UCSC).\r\n\r\n*novel_retro*\r\nRetroFinder pseudogenes that do not overlap with HAVANA annotation.\r\nSupplied by Robert Baertsch & Mark Diekhans (UCSC).\r\n\r\n*novel_RNASeq_loc*\r\nExons and ioci identified y RNA-Seq data that do not overlap with HAVANA annotation.\r\nSupplied by Bronwen Aken (WTSI).\r\n\r\n*overlapping_cds*\r\nHAVANA loci that have overlaps which each other in the coding region. Ensembl currently does not allow coding genes to overlap, so these cases causes incorrect gene merging in the HAVANA-Ensembl merge process.\r\nSupplied by Bronwen Aken (WTSI).\r\n\r\n*review_ccds*\r\nCCDS entry that might need withdrawal\r\nSupplied by Bronwen Aken (WTSI).\r\n\r\n*selected_targets*\r\nCandidate genes/transcripts for an experimental pipeline.\r\n\r\n*splice_x*\r\nSplice site analysis by Mark Diekhans et al. flaggind various types of dubious splice sites.\r\nFull description: http://hgwdev.cse.ucsc.edu/~markd/gencode/spliceSites/2009-11-16/gencodeV3c/\r\n\r\n*translation_missing*\r\nProtein-coding Havana transcripts with problems in the translation.\r\n\r\n*wrong_biotype*\r\nHavana transcripts which type need to be re-checked.','2008-12-05 11:28:43'),(5,227933,1,'Current status of HAVANA',' \r\nUsing a recent freeze (GENCODE 3c), the following numbers were generated (M.Schuster, EBI):\r\n* 97% of SwissProt proteins covered, 72% with a perfect alignment\r\n* 99% of RefSeq proteins covered, 91% with perfect alignment\r\n','2009-05-11 13:16:08'),(6,227933,2,'Download Page','\"Here\":/human/documents/show/1 is a general introduction to this tracking system. \"This\":/human/documents/show/2 is a user documentation.\r\n\r\n\r\n*Availability:*\r\nThe code developed for the AnnoTrack system is open-source and available below.\r\nThe Ruby/Rails code is build on top of the project management system \"Redmine\":http://www.redmine.org which is available under the GNU General Public License v2 (\"GPL\":http://www.gnu.org/licenses/old-licenses/gpl-2.0.html). We therefor distribute the AnnoTrack package under the same licence.\r\n\r\nThe gene-annotation data contained in the GENCODE installation of AnnoTrack is freely available as well, but underlies the general rules of \"ENCODE data\":http://www.genome.gov/ENCODE/#3.\r\n\r\n*Components*:\r\n\r\n* *Ruby/Rails Code* (modified Redmine code)\r\n\r\n* *mySQL Database Schema* (modified Redmine schema)\r\n\r\n* *Perl API & Scripts* (AnnoTrack-specific framework)\r\n\r\n*Downloads*:\r\n\r\n* Version 3.1:\r\nftp://ftp.sanger.ac.uk/pub/gencode/annotrack/annotrack.v3.1.tgz\r\n\r\n\r\n*Set-up:*\r\n\r\n* \"Here\":/human/documents/show/7 are notes for the set-up process of the system.\r\n\r\n\r\n*Contact:*\r\n* Felix Kokocinski: fsk@sanger.ac.uk\r\n\r\n*Citation:*\r\n* A description of the system has been published in \"BMC Genomics\":http://www.biomedcentral.com/1471-2164/11/538/abstract\r\n  If you found AnnoTrack useful for your research, please cite\r\n  _AnnoTrack - a tracking system for genome annotation_\r\n  _Felix Kokocinski, Jennifer Harrow and Tim Hubbard_\r\n  _BMC Genomics 2010, 11:538_\r\n\r\n','2009-06-25 16:59:02'),(7,227933,2,'Source Code and Instructions','*Related topics:*\r\n\"A general introduction\":/human/documents/show/1 to this tracking system. \r\n\"A user documentation\":/human/documents/show/2.\r\n\"The download page\":/human/documents/show/6.\r\n\r\nh2. Setting up a new system & adjusting it to your needs\r\n\r\nThe system is flexible enough to be of use for other groups and projects performing genome annotation in a collaborative effort and is therefor provided here. These are notes on how to start a new annotation project with AnnoTrack.\r\n\r\nGeneral _Redmine_ installation notes for troubleshooting are \"here\":http://www.redmine.org/wiki/redmine/RedmineInstall, but all the sourcecode required for AnnoTrack is available here.\r\n\r\nMost of the AnnoTrack code is written as a plugin for the Redmine system (rails/vendor/plugins/redmine_annotrack), but since there are some other changes required, which override Redmine\'s default code, you will need the complete package from this site.\r\n\r\n*General notes*\r\n* you will need \r\n** a database server (e.g. \"mysql 5\":http://dev.mysql.com/downloads/)\r\n** ruby on rails installation\r\n source and help on the \"official rails page\":http://rubyonrails.org/download\r\n documention for running on \"MaxOSX\":http://developer.apple.com/tools/developonrailsleopard.html (usually pre-installed)\r\n** a web server (e.g. Apache) when running in production mode, for testing, the Webbrick server supplied with Rails is fine.\r\n* get the AnnoTrack *source code and database* from \"this page\":/human/documents/show/6\r\n  unpack _tar xzvf annotrack.version.tgz_\r\n\r\n*Database*\r\n* create your database\r\n  _mysql -u<user> -p<password> -h<host> -P<port> -e\"create database annotrack\"_\r\n  _mysql -u<user> -p<password> -h<host> -P<port> -Dannotrack < annotrack/database.sql_\r\n\r\n*Rails server*\r\n* we have frozen the additional external Rails modules used by the application (gems) into the AnnoTrack rails code (rails/vendor/rails/) so you don\'t necessarily need to install all of them separately.\r\n* set your environment variables GEM_PATH and RAILS_ENV in your shell or in the file annotrack/rails/config/environment.rb\r\n* adjust the database configurations file in annotrack/rails/config/database.yml with your settings (production and development if desired)\r\nadditional environments can be created (e.g. for multiple organisms) by adding an entry (e.g. \"production_housemouse\") and a file in environments (e.g. environments/production_housemouse.rb)\r\n* start the server e.g. on port 6223 from the rails directory: _ruby scripts/server -edevelopment -p6223_ (to use the development setup)\r\n* log in as administrator (\"admin\"/\"admin\") to set up some initial values.\r\nThe admin interface from Redmine is at \"http://localhost:6223/admin\":/human/admin, modifications can be made on the \"Settings\" page:\r\n A. Settings:  \"Application title\", \"Welcome text\", \"Host name\"\r\n B. AnnoTrack settings: \"Menu links\", \"Browsers links\", \"other settings\"\r\n\r\n* we have stored a gene with two transcript with two flags for demonstration\r\n* you can create a new gene-level entry manually at \"http://localhost:6223/projects/add\":/human/projects/add for testing\r\n\r\n\r\n*Perl API/scripts*\r\n* You can adjust the settings for your system in the central config.pm file. \r\n* We use the scripts/cron_jobs.pl file the run automatic updates of the core annotation, to update the stats given on the fron page (issue and flag counts), please adjust this to your needs\r\nSome Perl programming knowledge is required to adjust / write parsers to handle the specific data you will be using.\r\n* The following additional perl modules (most of which are part of a standard installation) are required to use the AnnoTrack perl API:\r\n** Bio::Das::Lite\r\n** MIME::Lite\r\n** DBI\r\n** Getopt::Long\r\n** UNIVERSAL::require\r\n** Bio::EnsEMBL::DBSQL::DBAdaptor (when accessing Ensembl-style databases)\r\n* most probably you will have to adjust the source-specific scripts used for data loading and analysis stored in annotrack/perl/modules/annotrack\r\n* further hints:\r\n** New genes/transcripts, categories and flags would usually be created by script access. There are functions for all this functionality which is documented \"here\":/human/docs/core\r\n** \"This\":/human/documents/show/8 is a basic *source adaptor* reading data from a tab-delimited file to demonstrate how the modules work.\r\n** \"This\":/human/documents/show/10 is an example *source adaptor* to demonstrate a module reading from a database with DBI.\r\n** \"Here\":/humank/docs/core is the *Perl-doc* of the AnnoTrack core module.\r\n\r\n*Further adjustments:*\r\n** to customize the system for your own set-up there are a number of files you can modify:\r\n*** rails/app/views/layouts/base.rhtml: Start page layout\r\n*** rails/vendor/plugins/redmine_annotrack/lang/en.yml: Names and paths to browsers and project-related links\r\n** we are using a Lucene-based search engine for AnnoTrack, there is a switch option between this and the Redmine-internal search enginge on the Administration/Settings/Annotrack page\r\n\r\n*Upgrading*\r\n\r\nGeneral notes on upgrading existing Redmine installations are \"here\":http://www.redmine.org/wiki/redmine/RedmineUpgrade\r\nThere will usually be an upgraded AnnoTrack version made available here after a major Redmine upgrade.\r\n\r\nSome \"*Screenshots*\":/human/docs/screenshots of the application\r\n\r\n\r\n\r\n\r\n','2009-09-07 11:05:18'),(8,227933,2,'Source module layout: Tab-delimited file','This is a basic script to demonstrate the functionality of different source adaptors.\r\nThis module reads data from a tab-separated file and stores it into the tracking system.\r\n\r\n<pre>\r\npackage gencode_tracking_system::sources::tab_file;\r\n\r\nuse strict;\r\nuse warnings;\r\nuse gencode_tracking_system::core;\r\nuse gencode_tracking_system::config;\r\nuse base \'Exporter\';\r\n\r\nour @EXPORT = qw( run_update );\r\n\r\nmy ($tracking_dbh, $prepare_hash, $user_id, $category_id, $das_source);\r\nmy $features    = 0;\r\nmy $gene_status = \'new\';\r\nmy $gene_type   = \'missing mRNAs\';\r\n\r\nsub run_update {\r\n  ($tracking_dbh, $prepare_hash, $user_id, $category_id, $das_source) = @_;\r\n\r\n  my $file        = $OTHER_DAS_SERVERS{$das_source}->{\'file\'};\r\n  print STDERR \"Using file $file\\n\";\r\n\r\n  my ($current_gene_id, $current_transcript_id);\r\n\r\n  #open data file\r\n  open(IN, \"<$file\") or die \"cant open file $file!\\n\";\r\n\r\n  #go through file, read and store data as genes & transcripts\r\n  while (my $line = <IN>){\r\n\r\n    #read tab-del line\r\n    chomp $line;\r\n    my ($accession, $chrom, $start, $end, $strand, $remarks) = split(\"\\t\", $line);\r\n\r\n    #build structure for transcript\r\n    my %transcript;\r\n    $transcript{\'seqid\'}        = $chrom;\r\n    $transcript{\'biotype\'}      = $gene_type;\r\n    $transcript{\'status\'}       = $gene_status;\r\n    $transcript{\'type\'}         = \"transcript\";\r\n    $transcript{\'start\'}        = $start;\r\n    $transcript{\'end\'}          = $end;\r\n    $transcript{\'strand\'}       = $strand;\r\n    $transcript{\'id\'}           = $accession;\r\n    $transcript{\'description\'}  = $remarks;\r\n\r\n    #clone gene from transcript\r\n    my %gene = %transcript;\r\n\r\n    #store gene\r\n    $gene{\'type\'} = \"gene\";\r\n    $current_gene_id = store_features($tracking_dbh, $prepare_hash, \\%gene, \'gene\',\r\n				      0, 0, $user_id, $category_id);\r\n\r\n    #store transcript\r\n    $current_transcript_id = store_features($tracking_dbh, $prepare_hash, \\%transcript, \'transcript\',\r\n					    $current_gene_id, 0, $user_id, $category_id);\r\n\r\n    $features++;\r\n  }\r\n\r\n  print STDERR \"Have \".$features.\" features.\\n\" if($VERBOSE);\r\n}\r\n\r\n\r\n1;\r\n</pre>\r\n','2009-12-18 14:37:09'),(10,227933,2,'Source module layout: Database access','This is a basic script to demonstrate the functionality of different source adaptors.\r\nThis module reads gene and transcript objects from a database and stores them into the tracking system.\r\n\r\n<pre>\r\npackage gencode_tracking_system::sources::fetch_from_db;\r\n\r\nuse strict;\r\nuse warnings;\r\nuse gencode_tracking_system::core;\r\nuse gencode_tracking_system::config;\r\nuse base \'Exporter\';\r\n\r\nour @EXPORT = qw( run_update );\r\n\r\nmy ($tracking_dbh, $prepare_hash, $user_id, $category_id, $das_source);\r\nmy $g_features    = 0;\r\nmy $t_features    = 0;\r\n\r\nsub run_update {\r\n  ($tracking_dbh, $prepare_hash, $user_id, $category_id, $das_source) = @_;\r\n\r\n  #connect to database specified in config, use method from the core module\r\n  my $dbhost = $OTHER_SERVERS{$das_source}->{\'dbhost\'};\r\n  my $dbport = $OTHER_SERVERS{$das_source}->{\'dbport\'};\r\n  my $dbname = $OTHER_SERVERS{$das_source}->{\'dbname\'};\r\n  my $dbuser = $OTHER_SERVERS{$das_source}->{\'dbuser\'};\r\n  my $dbpass = $OTHER_SERVERS{$das_source}->{\'dbpass\'};\r\n\r\n  my $database = connect_db($dbhost, $dbport, $dbname, $dbuser, $dbpass);\r\n\r\n  #example queries to fetch genes and transcripts\r\n  my $sth_1 = $database->prepare(\"SELECT chromosome, start, end, strand, status, type, id, name FROM gene_table where category=?\");\r\n  my $sth_2 = $database->prepare(\"SELECT chromosome, start, end, strand, status, type, id, name FROM transcript_table where gene_id=?\");\r\n  my $category = \"protein_coding_genes\";\r\n\r\n  $sth_1->execute($category);\r\n\r\n  #go through result set and store genes\r\n  while (my ($gene_chrom, $gene_start, $gene_end, $gene_strand, $gene_status, $gene_type,\r\n	     $gene_id, $gene_name) = fetchrow_array()){\r\n\r\n    #build structure for gene\r\n    my %gene;\r\n    $gene{\'seqid\'}        = $gene_chrom;\r\n    $gene{\'biotype\'}      = $gene_type;\r\n    $gene{\'status\'}       = $gene_status;\r\n    $gene{\'type\'}         = \"gene\";\r\n    $gene{\'start\'}        = $gene_start;\r\n    $gene{\'end\'}          = $gene_end;\r\n    $gene{\'strand\'}       = $gene_strand;\r\n    $gene{\'id\'}           = $gene_id;\r\n    $gene{\'description\'}  = $gene_name;\r\n\r\n    #show gene\r\n    if($VERBOSE){\r\n      print STDERR \"GENE:\\n\";\r\n      print_element(\\%gene);\r\n    }\r\n    #store gene\r\n    my $current_gene_id = store_features($tracking_dbh, $prepare_hash, \\%gene, \'gene\',\r\n				      0, 0, $user_id, $category_id);\r\n    $g_features++;\r\n\r\n    #get all transcripts of this gene\r\n    $sth_2->execute($gene_id);\r\n\r\n    #go through result set and store transcripts\r\n    while (my ($transcript_chrom, $transcript_start, $transcript_end, $transcript_strand,\r\n	       $transcript_status, $transcript_type, $transcript_id, $transcript_name) = fetchrow_array()){\r\n\r\n      #build structure for transcript\r\n      my %transcript;\r\n      $transcript{\'seqid\'}        = $transcript_chrom;\r\n      $transcript{\'biotype\'}      = $transcript_type;\r\n      $transcript{\'status\'}       = $transcript_status;\r\n      $transcript{\'type\'}         = \"transcript\";\r\n      $transcript{\'start\'}        = $transcript_start;\r\n      $transcript{\'end\'}          = $transcript_end;\r\n      $transcript{\'strand\'}       = $transcript_strand;\r\n      $transcript{\'id\'}           = $transcript_id;\r\n      $transcript{\'description\'}  = $transcript_name;\r\n\r\n      #show transcript\r\n      if($VERBOSE){\r\n	print STDERR \"TRANSCRIPT:\\n\";\r\n	print_element(\\%transcript);\r\n      }\r\n      #store transcript\r\n      my $current_transcript_id = store_features($tracking_dbh, $prepare_hash, \\%transcript, \'transcript\',\r\n						 $current_gene_id, 0, $user_id, $category_id);\r\n      $t_features++;\r\n    }\r\n  }\r\n\r\n  print STDERR \"Found $g_features gene features and $t_features transcript features.\\n\" if($VERBOSE);\r\n}\r\n\r\n1;\r\n</pre>\r\n','2010-05-25 16:19:17');
UNLOCK TABLES;
/*!40000 ALTER TABLE `documents` ENABLE KEYS */;

--
-- Dumping data for table `workflows`
--


/*!40000 ALTER TABLE `workflows` DISABLE KEYS */;
LOCK TABLES `workflows` WRITE;
INSERT INTO `workflows` VALUES (222,1,6,1,3),(223,1,6,4,3),(224,1,7,2,3),(225,1,7,4,3),(226,1,7,7,3),(227,1,7,5,3),(228,1,1,2,3),(229,1,1,4,3),(230,1,1,7,3),(231,1,1,5,3),(232,1,1,6,3),(233,1,2,2,3),(234,1,2,4,3),(235,1,2,5,3),(236,1,2,6,3),(237,1,4,2,3),(238,1,4,4,3),(239,1,4,7,3),(240,1,4,5,3),(241,1,4,6,3),(242,1,5,4,3),(243,1,6,1,5),(244,1,6,4,5),(245,1,7,2,5),(246,1,7,4,5),(247,1,7,7,5),(248,1,7,5,5),(249,1,1,2,5),(250,1,1,4,5),(251,1,1,7,5),(252,1,1,5,5),(253,1,1,6,5),(254,1,2,2,5),(255,1,2,4,5),(256,1,2,5,5),(257,1,2,6,5),(258,1,4,2,5),(259,1,4,4,5),(260,1,4,7,5),(261,1,4,5,5),(262,1,4,6,5),(263,1,5,4,5),(264,1,1,2,6),(265,1,1,4,6),(266,1,1,7,6),(267,1,1,5,6),(268,1,1,6,6),(269,1,2,2,6),(270,1,2,4,6),(271,1,2,5,6),(272,1,2,6,6),(273,1,4,2,6),(274,1,4,4,6),(275,1,4,7,6),(276,1,4,5,6),(277,1,4,6,6),(278,1,5,4,6),(279,1,6,1,6),(280,1,6,4,6),(281,1,7,2,6),(282,1,7,4,6),(283,1,7,7,6),(284,1,7,5,6),(285,2,1,2,3),(286,2,1,4,3),(287,2,1,6,3),(288,2,1,8,3),(289,2,2,2,3),(290,2,2,4,3),(291,2,2,6,3),(292,2,2,8,3),(293,2,4,2,3),(294,2,4,4,3),(295,2,4,6,3),(296,2,4,8,3),(297,2,1,2,6),(298,2,1,4,6),(299,2,2,2,6),(300,2,2,4,6),(301,2,4,2,6),(302,2,4,4,6),(303,4,1,2,3),(304,4,1,4,3),(305,4,1,6,3),(306,4,1,8,3),(307,4,2,2,3),(308,4,2,4,3),(309,4,2,6,3),(310,4,2,8,3),(311,4,4,2,3),(312,4,4,4,3),(313,4,4,6,3),(314,4,4,8,3),(315,4,1,2,6),(316,4,1,4,6),(317,4,2,2,6),(318,4,2,4,6),(319,4,4,2,6),(320,4,4,4,6),(321,1,1,2,7),(322,1,1,4,7),(323,1,1,7,7),(324,1,1,5,7),(325,1,1,6,7),(326,1,2,2,7),(327,1,2,4,7),(328,1,2,5,7),(329,1,2,6,7),(330,1,4,2,7),(331,1,4,4,7),(332,1,4,7,7),(333,1,4,5,7),(334,1,4,6,7),(335,1,5,4,7),(336,1,6,1,7),(337,1,6,4,7),(338,1,7,2,7),(339,1,7,4,7),(340,1,7,7,7),(341,1,7,5,7);
UNLOCK TABLES;
/*!40000 ALTER TABLE `workflows` ENABLE KEYS */;

--
-- Dumping data for table `settings`
--


/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
LOCK TABLES `settings` WRITE;
INSERT INTO `settings` VALUES (1,'feeds_limit','15','2009-01-15 13:40:51'),(2,'host_name','annotrack.sanger.ac.uk','2010-06-22 12:18:30'),(3,'attachment_max_size','2120','2009-01-15 13:40:51'),(4,'per_page_options','50, 100, 500','2010-04-20 13:19:39'),(5,'app_title','AnnoTrack','2009-08-21 16:13:09'),(6,'ui_theme','alternate','2009-01-15 13:40:51'),(7,'text_formatting','textile','2009-01-15 13:40:51'),(8,'default_projects_public','1','2009-01-15 13:40:51'),(9,'welcome_text','p=. !http://www.sanger.ac.uk/PostGenomics/encode/gfx/ENCODE_logo.gif!\r\n\r\n\r\nh5.  Welcome to AnnoTrack\r\n the Tracking System of\r\n  the \"GENCODE\":http://www.sanger.ac.uk/PostGenomics/encode/ project\r\n\r\np. This system is used to track and aid in the progress of the *annotation of the entire human genome* by \"HAVANA\":http://vega.sanger.ac.uk/Homo_sapiens/Info/Index and \"GENCODE\":http://www.sanger.ac.uk/gencode. As a researcher in genomics you can *monitor and report on problems of the annotation*. \r\n\r\nExample *entry points*: a \"flagged transcript\":http://annotrack.sanger.ac.uk/human/issues/show/739825 from the manual annotation, or a \"list of all transcripts\":http://annotrack.sanger.ac.uk/human/issues?query_id=7 flagged with \"missing CCDS\".','2010-10-27 14:51:35'),(10,'time_format','%I:%M %p','2009-01-15 13:40:51'),(11,'date_format','%d.%m.%Y','2009-01-15 13:40:51'),(12,'activity_days_default','1000','2009-01-15 13:40:51'),(13,'wiki_compression','0','2009-01-15 13:40:51'),(14,'default_language','en','2009-01-15 13:40:51'),(15,'protocol','http','2009-01-15 13:40:51'),(16,'user_format','firstname_lastname','2009-01-15 13:40:51'),(17,'notified_events','--- []\n\n','2008-11-24 16:52:01'),(18,'bcc_recipients','0','2008-11-24 16:52:01'),(19,'emails_footer','--\r\nThis message was sent by the AnnoTrack tracking system (http://www.sanger.ac.uk/annotrack).\r\nFor questions please contact gencode@sanger.ac.uk','2010-03-04 11:50:20'),(20,'mail_from','GenTrack@Sanger.ac.uk','2009-04-20 19:44:13'),(21,'issue_list_default_columns','--- \n- project\n- status\n- priority\n- subject\n- category\n- Tchrom\n- Tstart\n- Tend\n- Tstrand\n- active_flags\n- cf_8\n','2009-04-29 17:53:57'),(22,'display_subprojects_issues','1','2008-10-29 13:52:21'),(23,'cross_project_issue_relations','1','2008-10-29 13:52:21'),(24,'issues_export_limit','500','2008-10-29 13:52:21'),(25,'lost_password','1','2008-11-07 16:34:32'),(26,'autologin','0','2008-11-07 16:34:32'),(27,'login_required','0','2008-11-07 16:34:32'),(28,'self_registration','0','2008-11-07 16:34:32'),(29,'commit_fix_status_id','0','2008-09-15 12:46:59'),(30,'commit_ref_keywords','refs,references,IssueID','2008-09-15 12:46:59'),(31,'sys_api_enabled','0','2008-09-15 12:46:59'),(32,'repositories_encodings','','2008-09-15 12:46:59'),(33,'commit_fix_done_ratio','100','2008-09-15 12:46:59'),(34,'commit_fix_keywords','fixes,closes','2008-09-15 12:46:59'),(35,'autofetch_changesets','0','2008-09-15 12:46:59'),(36,'gravatar_enabled','0','2009-04-16 17:28:13'),(37,'diff_max_lines_displayed','1500','2009-04-16 17:28:13'),(38,'plain_text_mail','1','2009-04-20 19:43:08'),(39,'help_doc_id','2','2009-10-22 14:46:11'),(40,'source_doc_id','7','2009-10-22 14:46:11'),(41,'company_name','Sanger','2009-10-22 14:46:11'),(42,'company_url','http://www.sanger.ac.uk','2009-10-22 14:46:11'),(43,'core_annotation','HAVANA','2010-01-06 14:45:10'),(49,'browser_ensembl_transcript','1','2010-01-06 16:40:38'),(51,'browser_ucsc','1','2010-01-06 16:41:58'),(52,'browser_ncbi','1','2010-01-06 16:50:57'),(53,'browser_congo','1','2010-01-07 13:31:45'),(54,'browser_zfin','0','2010-01-07 13:32:46'),(55,'browser_vega_region','1','2010-01-07 13:28:33'),(56,'browser_ensembl_region','1','2010-01-07 13:28:33'),(57,'browser_vega_transcript','1','2010-01-06 16:52:52'),(59,'organism','Homo_sapiens','2010-01-06 16:53:56'),(60,'browseradd_vega','0','2010-01-06 17:04:13'),(61,'browseradd_ensembl','0','2010-01-07 13:32:47'),(62,'stats_doc_id','5','2010-01-07 15:46:57'),(63,'redminesearch','0','2010-01-18 16:44:02'),(64,'enabled_scm','--- []\n\n','2010-04-20 13:18:29'),(65,'commit_logs_encoding','UTF-8','2010-04-20 13:18:29');
UNLOCK TABLES;
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;

--
-- Dumping data for table `schema_migrations`
--


/*!40000 ALTER TABLE `schema_migrations` DISABLE KEYS */;
LOCK TABLES `schema_migrations` WRITE;
INSERT INTO `schema_migrations` VALUES ('1'),('10'),('100'),('101'),('11'),('114'),('12'),('13'),('14'),('15'),('16'),('17'),('18'),('19'),('2'),('20'),('21'),('22'),('23'),('24'),('25'),('26'),('27'),('28'),('29'),('3'),('30'),('31'),('32'),('33'),('34'),('35'),('36'),('37'),('38'),('39'),('4'),('40'),('41'),('42'),('43'),('44'),('45'),('46'),('47'),('48'),('49'),('5'),('50'),('51'),('52'),('53'),('54'),('55'),('56'),('57'),('58'),('59'),('6'),('60'),('61'),('62'),('63'),('64'),('65'),('66'),('67'),('68'),('69'),('7'),('70'),('71'),('72'),('73'),('74'),('75'),('76'),('77'),('78'),('79'),('8'),('80'),('81'),('82'),('83'),('84'),('85'),('86'),('87'),('88'),('89'),('9'),('90'),('91'),('92'),('93'),('94'),('95'),('96'),('97'),('98'),('99');
UNLOCK TABLES;
/*!40000 ALTER TABLE `schema_migrations` ENABLE KEYS */;

--
-- Dumping data for table `roles`
--


/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
LOCK TABLES `roles` WRITE;
INSERT INTO `roles` VALUES (1,'Non member',1,1,1,'--- \n- :view_documents\n- :view_files\n- :add_issue_notes\n- :edit_own_issue_notes\n- :change_issue_flags\n- :change_issue_tecflags\n- :save_queries\n- :view_wiki_pages\n- :edit_wiki_pages\n'),(2,'Anonymous',2,1,2,'--- \n- :view_documents\n- :view_files\n- :view_wiki_pages\n'),(3,'Manager',3,1,0,'--- \n- :edit_project\n- :select_project_modules\n- :manage_members\n- :manage_versions\n- :manage_boards\n- :add_messages\n- :edit_messages\n- :delete_messages\n- :manage_documents\n- :view_documents\n- :manage_files\n- :view_files\n- :manage_categories\n- :add_issues\n- :edit_issues\n- :manage_issue_relations\n- :add_issue_notes\n- :edit_issue_notes\n- :edit_own_issue_notes\n- :move_issues\n- :delete_issues\n- :change_issue_flags\n- :change_issue_tecflags\n- :create_flag_type\n- :manage_public_queries\n- :save_queries\n- :manage_news\n- :comment_news\n- :manage_repository\n- :browse_repository\n- :view_changesets\n- :log_time\n- :view_time_entries\n- :edit_time_entries\n- :edit_own_time_entries\n- :manage_wiki\n- :rename_wiki_pages\n- :delete_wiki_pages\n- :view_wiki_pages\n- :view_wiki_edits\n- :edit_wiki_pages\n'),(5,'Annotator',4,1,0,'--- \n- :view_documents\n- :view_files\n- :add_issue_notes\n- :edit_own_issue_notes\n- :change_issue_flags\n- :change_issue_tecflags\n- :save_queries\n- :view_wiki_pages\n- :view_wiki_edits\n- :edit_wiki_pages\n'),(6,'Member',5,0,0,'--- \n- :view_documents\n- :view_files\n- :add_issue_notes\n- :edit_own_issue_notes\n- :change_issue_flags\n- :change_issue_tecflags\n- :save_queries\n- :view_wiki_pages\n- :view_wiki_edits\n- :edit_wiki_pages\n'),(7,'Partner',6,0,0,'--- \n- :view_documents\n- :view_files\n- :add_issue_notes\n- :edit_own_issue_notes\n- :change_issue_flags\n- :change_issue_tecflags\n- :view_wiki_pages\n- :view_wiki_edits\n- :edit_wiki_pages\n');
UNLOCK TABLES;
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;

--
-- Dumping data for table `issue_statuses`
--


/*!40000 ALTER TABLE `issue_statuses` DISABLE KEYS */;
LOCK TABLES `issue_statuses` WRITE;
INSERT INTO `issue_statuses` VALUES (1,'New',0,1,1),(2,'Updated',0,0,2),(4,'Feedback',0,0,3),(5,'Accepted',1,0,5),(6,'Rejected',1,0,6),(7,'Exper_Verified',0,0,4),(8,'Solved',1,0,7),(9,'Removed',1,0,8);
UNLOCK TABLES;
/*!40000 ALTER TABLE `issue_statuses` ENABLE KEYS */;

--
-- Dumping data for table `custom_fields`
--


/*!40000 ALTER TABLE `custom_fields` DISABLE KEYS */;
LOCK TABLES `custom_fields` WRITE;
INSERT INTO `custom_fields` VALUES (4,'ProjectCustomField','Genetype','string','--- []\n\n','',0,0,1,0,0,1,1,''),(5,'ProjectCustomField','Genestatus','string','--- []\n\n','',0,0,0,0,0,2,1,''),(8,'IssueCustomField','Transcripttype','string','--- []\n\n','',0,0,1,1,1,1,1,''),(9,'IssueCustomField','Transcriptstatus','string','--- []\n\n','',0,0,0,1,1,2,1,''),(10,'UserCustomField','Institution','string','--- []\n\n','',0,0,1,0,0,1,1,'WTSI Havana'),(11,'IssueCustomField','Transcriptversion','int','--- []\n\n','',1,3,0,1,0,3,0,'1'),(12,'ProjectCustomField','Geneversion','int','--- []\n\n','',1,3,0,0,0,3,0,'1');
UNLOCK TABLES;
/*!40000 ALTER TABLE `custom_fields` ENABLE KEYS */;

--
-- Dumping data for table `custom_fields_trackers`
--


/*!40000 ALTER TABLE `custom_fields_trackers` DISABLE KEYS */;
LOCK TABLES `custom_fields_trackers` WRITE;
INSERT INTO `custom_fields_trackers` VALUES (8,2),(9,2),(11,2);
UNLOCK TABLES;
/*!40000 ALTER TABLE `custom_fields_trackers` ENABLE KEYS */;

--
-- Dumping data for table `groups`
--


/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
LOCK TABLES `groups` WRITE;
INSERT INTO `groups` VALUES (1,'annotator','create_flags, create_tecflags, resolve_flags'),(2,'partner','create_tecflags, create_flags_re-annotate'),(3,'anonymous','');
UNLOCK TABLES;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;

--
-- Dumping data for table `trackers`
--


/*!40000 ALTER TABLE `trackers` DISABLE KEYS */;
LOCK TABLES `trackers` WRITE;
INSERT INTO `trackers` VALUES (1,'Transcripts',1,1,1),(2,'Features',0,2,1),(4,'Bugs',0,3,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE `trackers` ENABLE KEYS */;

--
-- Dumping data for table `enumerations`
--


/*!40000 ALTER TABLE `enumerations` DISABLE KEYS */;
LOCK TABLES `enumerations` WRITE;
INSERT INTO `enumerations` VALUES (1,'DCAT','User documentation',1,0),(2,'DCAT','Technical documentation',2,0),(3,'IPRI','Low',1,0),(4,'IPRI','Normal',2,1),(5,'IPRI','High',3,0),(6,'IPRI','Urgent',4,0),(7,'IPRI','Immediate',5,0),(8,'ACTI','Design',1,0),(9,'ACTI','Development',2,0),(10,'CHRO','1',1,0),(11,'CHRO','2',2,0),(12,'CHRO','3',3,0),(13,'CHRO','4',4,0),(14,'CHRO','5',5,0),(15,'CHRO','6',6,0),(16,'CHRO','7',7,0),(17,'CHRO','8',8,0),(18,'CHRO','9',9,0),(19,'CHRO','10',10,0),(20,'CHRO','11',11,0),(21,'CHRO','12',12,0),(22,'CHRO','13',13,0),(23,'CHRO','14',14,0),(24,'CHRO','15',15,0),(25,'CHRO','16',16,0),(26,'CHRO','17',17,0),(27,'CHRO','18',18,0),(28,'CHRO','19',19,0),(29,'CHRO','20',20,0),(30,'CHRO','21',21,0),(31,'CHRO','22',22,0),(32,'CHRO','X',23,0),(33,'CHRO','Y',24,0),(34,'CHRO','HSCHR6_MHC_COX',25,0),(35,'CHRO','HSCHR6_MHC_SSTO',26,0);
UNLOCK TABLES;
/*!40000 ALTER TABLE `enumerations` ENABLE KEYS */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

#additional AnnoTrack set-up statements

INSERT INTO `tmp_values` VALUES("default_count", 0, "general", NULL);
INSERT INTO `tmp_values` VALUES("resolved_flags", 0, "general", NULL);
INSERT INTO `tmp_values` VALUES("unresolved_flags", 0, "general", NULL);
INSERT INTO `tmp_values` VALUES('chromosome 1','issues?query_id=1&sort_key=Tstart&sort_order=asc','queries', NULL);
INSERT INTO `tmp_values` VALUES('Default','1','issue_category', NULL);
INSERT INTO `tmp_values` VALUES('novel_locus','1','flags', "high");
INSERT INTO `members` VALUES(1,1,1,6,now(),0),(2,1,2,3,now(),0);
INSERT INTO `users` VALUES (1,'admin','d033e22ae348aeb5660fc2140aec35850c4da997','System','Admin','your@emailadress.com',0,1,1,now(),'en',NULL,now(),now(),'User',1),(2,'','','','Anonymous','',0,0,0,NULL,'',NULL,now(),now(),'AnonymousUser',1);
INSERT INTO `news` VALUES (1,1,'News items','You can add your own news here.','You can add your own news here.',1,now(),0);
INSERT INTO `projects` VALUES (1,'AnnoTrack - Tracking System','Things related to this system','',1,NULL,0,now(),now(),'tracking-system',1,1,'-1',-1,-1,'-',NULL),(2,'test_gene_1','test_gene_1','',1,NULL,0,now(),now(),'test-gene-1',1,1,'1',10000,15230,'+',NULL);
INSERT INTO `projects_trackers` VALUES (1,1),(2,1);
INSERT INTO `queries` VALUES (1,NULL,'chrom_1','--- \nTchrom: \n  :values: \n  - \"1\"\n  :operator: \"=\"\nstatus_id: \n  :values: \n  - \"1\"\n  :operator: o\n',1,1,NULL);
INSERT INTO `issues` VALUES (1,1,2,'test_transcript_1','test_transcript_1',NULL,1,1,NULL,4,NULL,23,0,now(),now(),now(),0,NULL,'1',1010,15230,'+',NULL,1,"novel_locus",1,NULL),(2,1,2,'test-B','another transcripts',NULL,1,2,NULL,4,NULL,1,0,now(),now(),now(),0,NULL,'1',1010,15230,'+',NULL,1,NULL,1,NULL);
INSERT INTO `issue_categories` VALUES (1,-1,'HAVANA',NULL,'Manual annotation'),(26,1,'Default',NULL,'Core annotation');
INSERT INTO `custom_values` VALUES (1,'User',1,10,'WTSI Havana'),(2,'Project',1,4,'protein_coding'),(3,'Project',1,5,''),(4,'Project',1,12,'1');
NSERT INTO `flags` VALUES (1,-1,"novel_locus",NULL,now(),NULL,NULL,NULL,NULL);
INSERT INTO `flags` VALUES (2,1,"novel_locus",NULL,now(),NULL,"test flag",NULL,NULL);
INSERT INTO  `enabled_modules` VALUES(1,1,'news'),(2,1,'documents'),(3,1,'files'),(4,1,'wiki'),(5,1,'boards'),(6,2,'issue_tracking');
INSERT INTO `journals` VALUES (1,1,'Issue',1,'Created flag \"novel_locus\"',now());
UPDATE `documents` SET project_id=1;

