# wrapper script to be called as cron-job
# includes system-specific locations of the perl libraries
# Please fill in your system settings
#
# fsk@sanger.ac.uk, April 2010

use strict;
use warnings;

#write access
my $write = '-write';
#or read-only access
#my write = '';

my @libs;
my $cmd;

#path to your annotrack directory
my $annotrack_path = "/full-path/tracking_system/";

########### perl libraries ################

#location of AnnoTrack perl modules
$libs[0] = $annotrack_path.'perl/modules';

#Ensembl API modules
$libs[1] = '/full-path/ensembl/modules';
#Bio-Perl modules
$libs[2] = '/full-path/BioPerl-1.6.0';

#general perl modules
$libs[3] = '/full-path/modules';

#Otter modules for HAVANA db access
# $libs[4] = '/full-path/ensembl-otter/modules';
# $libs[5] = '/full-path/ensembl-variation/modules';

########## commands #####################

##update main annotation source
$cmd = $annotrack_path."perl/scripts/update.pl -core $write";
exec_cmd($cmd);

##re-set priorities and active flags
$cmd = $annotrack_path."perl/scripts/set_priorities.pl $write";
exec_cmd($cmd);

#set related issues
$cmd = $annotrack_path."perl/scripts/set_relations.pl $write";
exec_cmd($cmd);

############################################

sub exec_cmd{
  my ($cmd) = shift;

  my $command = "nice perl ";
  foreach my $lib (@libs){
    $command .= "-I $lib ";
  }

  $command .= $cmd;
  #print $command."\n\n";
  print system($command);
}

############################################


