#!/usr/local/ensembl/bin/perl -w

# Example script for the GENCODE tracking system
#
# Connect to a DAS server,
# fetch data, store in internal tracking system db


package gencode_tracking_system::sources::das_example;

use strict;
use gencode_tracking_system::core;
use gencode_tracking_system::config;
use base 'Exporter';

our @EXPORT    = qw( run_update );

sub run_update {
  my ($response, $chrom, $tracking_dbh, $prepare_hash, $user_id, $category_id, $previous_genes) = @_;

  my $gene_type   = "novel_exons";
  my $gene_status = 'new';
  my %new_features = ();
  my $updated      = 0;
  my ($current_transcript_id, $current_gene_id);

  #use general project instead of individual gene/transcript pairs:
  $current_gene_id = get_project_for_category($prepare_hash, $tracking_dbh, $category_id);
  die "Can't find general project for category $category_id!\n" unless $current_gene_id;

  # go through loci from DAS response
  while (my ($url, $features) = each %$response) {

    #DAS response is an array ref
    if(ref $features eq "ARRAY"){
      print "Received ".scalar @$features." features.\n" if $VERBOSE;

    FEATURES:
      foreach my $feature (@$features) {

	my %transcript;
	my $phase = "0";

	#optional: get information encoded in DAS "notes" field
	my %notes = ();
	my $i     = 0;
	while(defined($feature->{'note'}->[$i])){
	  my $morenotes = $feature->{'note'}->[$i];
	  my ($morenotes_type, $morenotes_value) = split('\|', $morenotes);
	  $morenotes_value =~ s/\&\#39\;/\'/g;
	  $notes{$morenotes_type} = $morenotes_value;
	  $i++;
	}
	#use timestamps for updates
	my $timestamp_updated = $notes{'LASTMOD'};
	my $timestamp_created;
	if(exists($notes{'CREATED'})){
	  $timestamp_created = $notes{'CREATED'};
	}
	else{
	  $timestamp_created = $timestamp_updated;
	}

	#remove duplicates from overlapping regions using the passed in hash ref
	if(defined $previous_genes and exists $previous_genes->{$feature->{'feature_id'}}){
	  next FEATURES;
	}
	$new_features{$feature->{'feature_id'}} = 1;

	#build structure for transcript
	$transcript{'id'}           = $feature->{'feature_id'};
	$transcript{'chrom'}        = $chrom;
	$transcript{'biotype'}      = $gene_type;
	$transcript{'status'}       = $gene_status;
	$transcript{'type'}         = "transcript";
	$transcript{'start'}        = $feature->{'start'};
	$transcript{'end'}          = $feature->{'end'};
	$transcript{'strand'}       = $feature->{'orientation'};
	$transcript{'description'}  = $feature->{'feature_id'};
	$transcript{'created_on'}   = $timestamp_created;
	$transcript{'updated_on'}   = $timestamp_updated;

	#print out transcript object
	if($VERBOSE){
	  print "TRANSCRIPT:\n";
	  print_element(\%transcript);
	}
	#store / update transcript
	($current_transcript_id, $updated) = store_features($tracking_dbh, $prepare_hash, \%transcript,
						'transcript', $current_gene_id, 0, 
						$user_id, $category_id);

      }
      @$features = ();
    }
  }

  return \%new_features;
}


1;
