#!/bin/bash

# Run maintanance queries on the AnnoTrack databases
# Please add your databases parameters below and run script as cron job

##### define queries ######

#update issue-category count
sql[1]='update tmp_values t join issue_categories c on t.field_name=c.name set t.field_value=((select count(*) from issues where category_id=c.id and status_id NOT in (6,9) )) where t.field_group="issue_category";'

#update unresolved flag count
sql[2]='update tmp_values t set t.field_value=(select count(*) as count from flags f, issues i where i.id=f.issue_id and f.flag_name not like "TEC%" AND f.checked_date is NULL and f.issue_id > 0 and i.status_id NOT in (6,9)) where t.field_name="unresolved_flags";'

#update resolved flag count
sql[3]='update tmp_values set field_value=(select count(*) as count from flags where flag_name not like "TEC%" AND checked_date is not NULL and issue_id > 0) where field_name="resolved_flags";'

#update un-resolved flag-category count
sql[4]='update tmp_values t left join flags f on  t.field_name=f.flag_name set t.field_value=(select count(distinct f.id) from flags f, issues i where f.checked_date is NULL AND f.flag_name=t.field_name and f.issue_id>0 and i.id=f.issue_id and i.status_id NOT in (6,9)) where t.field_group="flags";'

#optimize tables
sql[5]='optimize table projects;optimize table issues;optimize table flags;optimize table journals;optimize table journal_details;optimize table subfeatures;'

#update total number of issues
sql[6]='UPDATE tmp_values SET field_value=(select count(*) from issues, issue_statuses, projects where issues.status_id=issue_statuses.id and issues.project_id=projects.id and (issue_statuses.is_closed=0) AND ((projects.status NOT in (6,9) AND EXISTS (SELECT em.id FROM enabled_modules em WHERE em.name="issue_tracking" AND em.project_id=projects.id)) AND (1=0 OR projects.is_public = 1))) WHERE field_name="default_count";'

##### execute queries #######

for i in 1 2 3 4 5 6
do

 #test server
 mysql -hhost -Pport -uuser -ppassword -Ddev_db_name -e "${sql[i]}"

 #production server
 mysql -hhost -Pport -uuser -ppassword -Dprod_db_name -e "${sql[i]}"

done
