
=head1 NAME

gencode_tracking_system / remove_redundant_flags

=head1 DESCRIPTION

Helper script for the GENCODE tracking system.
remove duplicated flags so that for one problem (missing cDNA eg)
there will be only one transcript/ticket reported per locus/project

=head1 CONTACT

Felix Kokocinski, fsk@sanger.ac.uk

=head1 COPYRIGHT

Copyright Felix Kokocinski, 2008-2009, 
supported by Wellcome Trust Sanger Institute (UK) 
and National Human Genome Research Institute (USA).




=cut

use strict;
use warnings;
use gencode_tracking_system::core;
use gencode_tracking_system::config;

my ($flag_name, $chrom);
my ($sql, $sth1, $sth2, $sth3);

my $tracking_dbh = connect_db($DBHOST, $DBPORT, $DBNAME, $DBUSER, $DBPASS)
  or die "cant connect to to database $DBNAME @ $DBHOST.\n";
print "Conected to $DBNAME @ $DBHOST.\n";

my (%flags, %checked);

$chrom     = "21";

if($chrom){
  $sql = 'select f.id, f.flag_issue_id, i.subject, p.name, f.checked_date, i.active_flags '.
         'from flags f, issues i, projects p '.
         'where f.issue_id=i.id and i.project_id=p.id and flag_name = ? and i.Tchrom !=? '.
         'order by f.flag_issue_id,  p.name, f.checked_date desc;';
}
else{
  $sql = 'select f.id, f.flag_issue_id, i.subject, p.name, f.checked_date, i.active_flags '.
         'from flags f, issues i, projects p '.
         'where f.issue_id=i.id and i.project_id=p.id and flag_name = ? '.
         'order by f.flag_issue_id,  p.name, f.checked_date desc;';
}
$sth1 = $tracking_dbh->prepare($sql);

$sql  = "delete from flags where id = ?;";
$sth2 = $tracking_dbh->prepare($sql);

$sql  = "update issues set active_flags = ? where id = ?;";
$sth3 = $tracking_dbh->prepare($sql);

$flag_name = "missing_cDNA";
execute_query($flag_name, $chrom);

$flag_name = "missing_exon";
execute_query($flag_name, $chrom);

$flag_name = "missing_intron";
execute_query($flag_name, $chrom);

$sth1->finish;
$sth2->finish;
$sth3->finish;


sub execute_query {
  my ($flag_name, $chrom) = @_;

  if($chrom){
    print "$sql\n";
    $sth1->execute($flag_name, $chrom);
  }
  else{
    $sth1->execute($flag_name);
  }

  while(my ($flag_id, $flag_issue_id, $transcript_id, $gene_id, $checked, $active_flags) = $sth1->fetchrow_array){
    print "$flag_id / $flag_issue_id / $gene_id / $transcript_id";

    if(!exists($flags{$flag_issue_id}{$gene_id})){
      $flags{$flag_issue_id}{$gene_id} = $transcript_id;
      $checked{$flag_issue_id}{$gene_id} = $checked;
    }
    else{
      if(!$checked){
	remove_flag($flag_id, $active_flags, $flag_name, $flag_issue_id);
      }
      else{
	print " -> already resolved!\n";
	#remove the other one instead?
	#if(!($checked{$flag_issue_id}{$gene_id})){
	#  remove_flag(
	#}
      }
    }
    print "\n";
  }
}


sub remove_flag {
  my ($flag_id, $active_flags, $flag_name, $flag_issue_id) = @_;

  print " -> remove flag $flag_id / $active_flags / $flag_name!\n";

  if($WRITE){
    $sth2->execute($flag_id);
  }

  my @flags = split(', ', $active_flags);
  my @new_flags = ();

  foreach my $flag (@flags){
    if(!($flag =~ /$flag_name/i)){
      push(@new_flags, $flag);
    }
  }
  my $new_flags = join(", ", @new_flags);
  print "Setting flags of $flag_issue_id to $new_flags.\n";

  if($WRITE){
    $sth3->execute($new_flags, $flag_issue_id);
  }
}

